/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleInitCommand
extends GitCommand {
    private final Collection paths = new ArrayList();

    public SubmoduleInitCommand(Repository repository) {
        super(repository);
    }

    public SubmoduleInitCommand addPath(String string) {
        this.paths.add(string);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection call() {
        this.checkCallable();
        try (SubmoduleWalk submoduleWalk = SubmoduleWalk.forIndex(this.repo);){
            Object object;
            if (!this.paths.isEmpty()) {
                submoduleWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            StoredConfig storedConfig = this.repo.getConfig();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (submoduleWalk.next()) {
                if (submoduleWalk.getConfigUrl() != null) continue;
                object = submoduleWalk.getPath();
                String string = submoduleWalk.getModuleName();
                String string2 = submoduleWalk.getRemoteUrl();
                String string3 = submoduleWalk.getModulesUpdate();
                if (string2 != null) {
                    storedConfig.setString("submodule", string, "url", string2);
                }
                if (string3 != null) {
                    storedConfig.setString("submodule", string, "update", string3);
                }
                if (string2 == null && string3 == null) continue;
                arrayList.add(object);
            }
            if (!arrayList.isEmpty()) {
                storedConfig.save();
            }
            object = arrayList;
            return object;
        }
        catch (IOException | ConfigInvalidException exception) {
            throw new JGitInternalException(exception.getMessage(), exception);
        }
    }
}

