/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleDeinitCommand$NoSuchSubmoduleException;
import org.eclipse.jgit.api.SubmoduleDeinitCommand$SubmoduleDeinitStatus;
import org.eclipse.jgit.api.SubmoduleDeinitResult;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FileUtils;

public class SubmoduleDeinitCommand
extends GitCommand {
    private final Collection paths = new ArrayList();
    private boolean force;

    public SubmoduleDeinitCommand(Repository repository) {
        super(repository);
    }

    @Override
    public Collection call() {
        this.checkCallable();
        try {
            Object object2;
            if (this.paths.isEmpty()) {
                return Collections.emptyList();
            }
            for (Object object2 : this.paths) {
                if (this.submoduleExists((String)object2)) continue;
                throw new SubmoduleDeinitCommand$NoSuchSubmoduleException((String)object2);
            }
            ArrayList arrayList = new ArrayList(this.paths.size());
            object2 = new RevWalk(this.repo);
            Throwable throwable = null;
            try (SubmoduleWalk submoduleWalk = SubmoduleWalk.forIndex(this.repo);){
                submoduleWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
                StoredConfig storedConfig = this.repo.getConfig();
                while (submoduleWalk.next()) {
                    String string = submoduleWalk.getPath();
                    String string2 = submoduleWalk.getModuleName();
                    SubmoduleDeinitCommand$SubmoduleDeinitStatus submoduleDeinitCommand$SubmoduleDeinitStatus = this.checkDirty((RevWalk)object2, string);
                    switch (submoduleDeinitCommand$SubmoduleDeinitStatus) {
                        case SUCCESS: {
                            this.deinit(string);
                            break;
                        }
                        case ALREADY_DEINITIALIZED: {
                            break;
                        }
                        case DIRTY: {
                            if (!this.force) break;
                            this.deinit(string);
                            submoduleDeinitCommand$SubmoduleDeinitStatus = SubmoduleDeinitCommand$SubmoduleDeinitStatus.FORCED;
                            break;
                        }
                        default: {
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().unexpectedSubmoduleStatus, new Object[]{submoduleDeinitCommand$SubmoduleDeinitStatus}));
                        }
                    }
                    storedConfig.unsetSection("submodule", string2);
                    arrayList.add(new SubmoduleDeinitResult(string, submoduleDeinitCommand$SubmoduleDeinitStatus));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((RevWalk)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((RevWalk)object2).close();
                    }
                }
            }
            return arrayList;
        }
        catch (ConfigInvalidException configInvalidException) {
            throw new InvalidConfigurationException(configInvalidException.getMessage(), configInvalidException);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    private void deinit(String string) {
        File file = new File(this.repo.getWorkTree(), string);
        if (!file.isDirectory()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().expectedDirectoryNotSubmodule, string));
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                FileUtils.delete(file2, 1);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private SubmoduleDeinitCommand$SubmoduleDeinitStatus checkDirty(RevWalk var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean submoduleExists(String string) {
        PathFilter pathFilter = PathFilter.create(string);
        try (SubmoduleWalk submoduleWalk = SubmoduleWalk.forIndex(this.repo);){
            boolean bl2 = submoduleWalk.setFilter(pathFilter).next();
            return bl2;
        }
    }

    public SubmoduleDeinitCommand addPath(String string) {
        this.paths.add(string);
        return this;
    }

    public SubmoduleDeinitCommand setForce(boolean bl2) {
        this.force = bl2;
        return this;
    }
}

