/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator$SubmoduleValidationException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;

public class SubmoduleAddCommand
extends TransportCommand {
    private String name;
    private String path;
    private String uri;
    private ProgressMonitor monitor;

    public SubmoduleAddCommand(Repository repository) {
        super(repository);
    }

    public SubmoduleAddCommand setName(String string) {
        this.name = string;
        return this;
    }

    public SubmoduleAddCommand setPath(String string) {
        this.path = string;
        return this;
    }

    public SubmoduleAddCommand setURI(String string) {
        this.uri = string;
        return this;
    }

    public SubmoduleAddCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
        return this;
    }

    protected boolean submoduleExists() {
        PathFilter pathFilter = PathFilter.create(this.path);
        try (SubmoduleWalk submoduleWalk = SubmoduleWalk.forIndex(this.repo);){
            boolean bl2 = submoduleWalk.setFilter(pathFilter).next();
            return bl2;
        }
    }

    @Override
    public Repository call() {
        String string;
        this.checkCallable();
        if (this.path == null || this.path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = this.path;
        }
        try {
            SubmoduleValidator.assertValidSubmoduleName(this.name);
            SubmoduleValidator.assertValidSubmodulePath(this.path);
            SubmoduleValidator.assertValidSubmoduleUri(this.uri);
        }
        catch (SubmoduleValidator$SubmoduleValidationException submoduleValidator$SubmoduleValidationException) {
            throw new IllegalArgumentException(submoduleValidator$SubmoduleValidationException.getMessage());
        }
        try {
            if (this.submoduleExists()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().submoduleExists, this.path));
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        try {
            string = SubmoduleWalk.getSubmoduleRemoteUrl(this.repo, this.uri);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        File file = SubmoduleWalk.getSubmoduleDirectory(this.repo, this.path);
        CloneCommand cloneCommand = Git.cloneRepository();
        this.configure(cloneCommand);
        cloneCommand.setDirectory(file);
        cloneCommand.setGitDir(new File(this.repo.getDirectoryChild("modules"), this.path));
        cloneCommand.setURI(string);
        if (this.monitor != null) {
            cloneCommand.setProgressMonitor(this.monitor);
        }
        Repository repository = null;
        Object object = cloneCommand.call();
        Object object2 = null;
        try {
            repository = ((Git)object).getRepository();
            repository.incrementOpen();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((Git)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((Git)object).close();
                }
            }
        }
        object = this.repo.getConfig();
        ((Config)object).setString("submodule", this.name, "url", string);
        try {
            ((StoredConfig)object).save();
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        object2 = new FileBasedConfig(new File(this.repo.getWorkTree(), ".gitmodules"), this.repo.getFS());
        try {
            ((FileBasedConfig)object2).load();
            ((Config)object2).setString("submodule", this.name, "path", this.path);
            ((Config)object2).setString("submodule", this.name, "url", this.uri);
            ((FileBasedConfig)object2).save();
        }
        catch (IOException | ConfigInvalidException exception) {
            throw new JGitInternalException(exception.getMessage(), exception);
        }
        AddCommand addCommand = new AddCommand(this.repo);
        addCommand.addFilepattern(".gitmodules");
        addCommand.addFilepattern(this.path);
        try {
            addCommand.call();
        }
        catch (NoFilepatternException noFilepatternException) {
            throw new JGitInternalException(noFilepatternException.getMessage(), noFilepatternException);
        }
        return repository;
    }
}

