/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class StatusCommand
extends GitCommand {
    private WorkingTreeIterator workingTreeIt;
    private List paths = null;
    private ProgressMonitor progressMonitor = null;
    private SubmoduleWalk.IgnoreSubmoduleMode ignoreSubmoduleMode = null;

    protected StatusCommand(Repository repository) {
        super(repository);
    }

    public StatusCommand setIgnoreSubmodules(SubmoduleWalk.IgnoreSubmoduleMode ignoreSubmoduleMode) {
        this.ignoreSubmoduleMode = ignoreSubmoduleMode;
        return this;
    }

    public StatusCommand addPath(String string) {
        if (this.paths == null) {
            this.paths = new LinkedList();
        }
        this.paths.add(string);
        return this;
    }

    public List getPaths() {
        return this.paths;
    }

    @Override
    public Status call() {
        if (this.workingTreeIt == null) {
            this.workingTreeIt = new FileTreeIterator(this.repo);
        }
        try {
            IndexDiff indexDiff = new IndexDiff(this.repo, "HEAD", this.workingTreeIt);
            if (this.ignoreSubmoduleMode != null) {
                indexDiff.setIgnoreSubmoduleMode(this.ignoreSubmoduleMode);
            }
            if (this.paths != null) {
                indexDiff.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            if (this.progressMonitor == null) {
                indexDiff.diff();
            } else {
                indexDiff.diff(this.progressMonitor, 0, 0, "");
            }
            return new Status(indexDiff);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    public StatusCommand setWorkingTreeIt(WorkingTreeIterator workingTreeIterator) {
        this.workingTreeIt = workingTreeIterator;
        return this;
    }

    public StatusCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        return this;
    }
}

