/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.IndexDiff;

public class Status {
    private final IndexDiff diff;
    private final boolean clean;
    private final boolean hasUncommittedChanges;

    public Status(IndexDiff indexDiff) {
        this.diff = indexDiff;
        this.hasUncommittedChanges = !indexDiff.getAdded().isEmpty() || !indexDiff.getChanged().isEmpty() || !indexDiff.getRemoved().isEmpty() || !indexDiff.getMissing().isEmpty() || !indexDiff.getModified().isEmpty() || !indexDiff.getConflicting().isEmpty();
        this.clean = !this.hasUncommittedChanges && indexDiff.getUntracked().isEmpty();
    }

    public boolean isClean() {
        return this.clean;
    }

    public boolean hasUncommittedChanges() {
        return this.hasUncommittedChanges;
    }

    public Set getAdded() {
        return Collections.unmodifiableSet(this.diff.getAdded());
    }

    public Set getChanged() {
        return Collections.unmodifiableSet(this.diff.getChanged());
    }

    public Set getRemoved() {
        return Collections.unmodifiableSet(this.diff.getRemoved());
    }

    public Set getMissing() {
        return Collections.unmodifiableSet(this.diff.getMissing());
    }

    public Set getModified() {
        return Collections.unmodifiableSet(this.diff.getModified());
    }

    public Set getUntracked() {
        return Collections.unmodifiableSet(this.diff.getUntracked());
    }

    public Set getUntrackedFolders() {
        return Collections.unmodifiableSet(this.diff.getUntrackedFolders());
    }

    public Set getConflicting() {
        return Collections.unmodifiableSet(this.diff.getConflicting());
    }

    public Map getConflictingStageState() {
        return Collections.unmodifiableMap(this.diff.getConflictingStageStates());
    }

    public Set getIgnoredNotInIndex() {
        return Collections.unmodifiableSet(this.diff.getIgnoredNotInIndex());
    }

    public Set getUncommittedChanges() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.diff.getAdded());
        hashSet.addAll(this.diff.getChanged());
        hashSet.addAll(this.diff.getRemoved());
        hashSet.addAll(this.diff.getMissing());
        hashSet.addAll(this.diff.getModified());
        hashSet.addAll(this.diff.getConflicting());
        return hashSet;
    }
}

