/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.ReflogCommand;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class StashListCommand
extends GitCommand {
    public StashListCommand(Repository repository) {
        super(repository);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection call() {
        this.checkCallable();
        try {
            if (this.repo.exactRef("refs/stash") == null) {
                return Collections.emptyList();
            }
        }
        catch (IOException iOException) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), iOException);
        }
        ReflogCommand reflogCommand = new ReflogCommand(this.repo);
        reflogCommand.setRef("refs/stash");
        Collection collection = reflogCommand.call();
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RevCommit> arrayList = new ArrayList<RevCommit>(collection.size());
        try (RevWalk revWalk = new RevWalk(this.repo);){
            for (ReflogEntry reflogEntry : collection) {
                try {
                    arrayList.add(revWalk.parseCommit(reflogEntry.getNewId()));
                }
                catch (IOException iOException) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, reflogEntry.getNewId()), iOException);
                    return arrayList;
                }
            }
        }
    }
}

