/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.ReflogWriter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;

public class StashDropCommand
extends GitCommand {
    private int stashRefEntry;
    private boolean all;

    public StashDropCommand(Repository repository) {
        super(repository);
        if (!(repository.getRefDatabase() instanceof RefDirectory)) {
            throw new UnsupportedOperationException(JGitText.get().stashDropNotSupported);
        }
    }

    public StashDropCommand setStashRef(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.stashRefEntry = n2;
        return this;
    }

    public StashDropCommand setAll(boolean bl2) {
        this.all = bl2;
        return this;
    }

    private Ref getRef() {
        try {
            return this.repo.exactRef("refs/stash");
        }
        catch (IOException iOException) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), iOException);
        }
    }

    private RefUpdate createRefUpdate(Ref ref) {
        RefUpdate refUpdate = this.repo.updateRef("refs/stash");
        refUpdate.disableRefLog();
        refUpdate.setExpectedOldObjectId(ref.getObjectId());
        refUpdate.setForceUpdate(true);
        return refUpdate;
    }

    private void deleteRef(Ref ref) {
        try {
            RefUpdate$Result refUpdate$Result = this.createRefUpdate(ref).delete();
            if (RefUpdate$Result.FORCED != refUpdate$Result) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().stashDropDeleteRefFailed, new Object[]{refUpdate$Result}));
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, iOException);
        }
    }

    private void updateRef(Ref ref, ObjectId objectId) {
        try {
            RefUpdate refUpdate = this.createRefUpdate(ref);
            refUpdate.setNewObjectId(objectId);
            RefUpdate$Result refUpdate$Result = refUpdate.update();
            switch (refUpdate$Result) {
                case FORCED: 
                case NEW: 
                case NO_CHANGE: {
                    return;
                }
            }
            throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"refs/stash", objectId, refUpdate$Result}));
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, iOException);
        }
    }

    @Override
    public ObjectId call() {
        List list;
        Object object;
        this.checkCallable();
        Ref ref = this.getRef();
        if (ref == null) {
            return null;
        }
        if (this.all) {
            this.deleteRef(ref);
            return null;
        }
        try {
            object = this.repo.getReflogReader("refs/stash");
            if (object == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, ref));
            }
            list = object.getReverseEntries();
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, iOException);
        }
        if (this.stashRefEntry >= list.size()) {
            throw new JGitInternalException(JGitText.get().stashDropMissingReflog);
        }
        if (list.size() == 1) {
            this.deleteRef(ref);
            return null;
        }
        object = (RefDirectory)this.repo.getRefDatabase();
        ReflogWriter reflogWriter = new ReflogWriter((RefDirectory)object, true);
        String string = ReflogWriter.refLockFor("refs/stash");
        File file = ((RefDirectory)object).logFor(string);
        File file2 = ((RefDirectory)object).logFor("refs/stash");
        if (file.exists()) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, new LockFailedException(file2));
        }
        list.remove(this.stashRefEntry);
        ObjectId objectId = ObjectId.zeroId();
        try {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                ReflogEntry reflogEntry = (ReflogEntry)list.get(i2);
                reflogWriter.log(string, objectId, reflogEntry.getNewId(), reflogEntry.getWho(), reflogEntry.getComment());
                objectId = reflogEntry.getNewId();
            }
            try {
                FileUtils.rename(file, file2, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException iOException) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().renameFileFailed, file.getPath(), file2.getPath()), iOException);
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, iOException);
        }
        this.updateRef(ref, objectId);
        try {
            Ref ref2 = this.repo.exactRef("refs/stash");
            return ref2 != null ? ref2.getObjectId() : null;
        }
        catch (IOException iOException) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), iOException);
        }
    }
}

