/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class StashCreateCommand
extends GitCommand {
    private static final String MSG_INDEX = "index on {0}: {1} {2}";
    private static final String MSG_UNTRACKED = "untracked files on {0}: {1} {2}";
    private static final String MSG_WORKING_DIR = "WIP on {0}: {1} {2}";
    private String indexMessage = "index on {0}: {1} {2}";
    private String workingDirectoryMessage = "WIP on {0}: {1} {2}";
    private String ref = "refs/stash";
    private PersonIdent person;
    private boolean includeUntracked;

    public StashCreateCommand(Repository repository) {
        super(repository);
        this.person = new PersonIdent(repository);
    }

    public StashCreateCommand setIndexMessage(String string) {
        this.indexMessage = string;
        return this;
    }

    public StashCreateCommand setWorkingDirectoryMessage(String string) {
        this.workingDirectoryMessage = string;
        return this;
    }

    public StashCreateCommand setPerson(PersonIdent personIdent) {
        this.person = personIdent;
        return this;
    }

    public StashCreateCommand setRef(String string) {
        this.ref = string;
        return this;
    }

    public StashCreateCommand setIncludeUntracked(boolean bl2) {
        this.includeUntracked = bl2;
        return this;
    }

    private RevCommit parseCommit(ObjectReader objectReader, ObjectId objectId) {
        try (RevWalk revWalk = new RevWalk(objectReader);){
            RevCommit revCommit = revWalk.parseCommit(objectId);
            return revCommit;
        }
    }

    private CommitBuilder createBuilder() {
        CommitBuilder commitBuilder = new CommitBuilder();
        PersonIdent personIdent = this.person;
        if (personIdent == null) {
            personIdent = new PersonIdent(this.repo);
        }
        commitBuilder.setAuthor(personIdent);
        commitBuilder.setCommitter(personIdent);
        return commitBuilder;
    }

    private void updateStashRef(ObjectId objectId, PersonIdent personIdent, String string) {
        if (this.ref == null) {
            return;
        }
        Ref ref = this.repo.findRef(this.ref);
        RefUpdate refUpdate = this.repo.updateRef(this.ref);
        refUpdate.setNewObjectId(objectId);
        refUpdate.setRefLogIdent(personIdent);
        refUpdate.setRefLogMessage(string, false);
        refUpdate.setForceRefLog(true);
        if (ref != null) {
            refUpdate.setExpectedOldObjectId(ref.getObjectId());
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.forceUpdate();
    }

    private Ref getHead() {
        try {
            Ref ref = this.repo.exactRef("HEAD");
            if (ref == null || ref.getObjectId() == null) {
                throw new NoHeadException(JGitText.get().headRequiredToStash);
            }
            return ref;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().stashFailed, iOException);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public RevCommit call() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 4[TRYBLOCK], 2[TRYBLOCK], 3[TRYBLOCK]], but top level block is 85[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

