/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.Checkout;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout$CheckoutMetadata;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CoreConfig$EolStreamType;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;

public class StashApplyCommand
extends GitCommand {
    private static final String DEFAULT_REF = "stash@{0}";
    private String stashRef;
    private boolean restoreIndex = true;
    private boolean restoreUntracked = true;
    private boolean ignoreRepositoryState;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;

    public StashApplyCommand(Repository repository) {
        super(repository);
    }

    public StashApplyCommand setStashRef(String string) {
        this.stashRef = string;
        return this;
    }

    public StashApplyCommand ignoreRepositoryState(boolean bl2) {
        this.ignoreRepositoryState = bl2;
        return this;
    }

    private ObjectId getStashId() {
        ObjectId objectId;
        String string = this.stashRef != null ? this.stashRef : DEFAULT_REF;
        try {
            objectId = this.repo.resolve(string);
        }
        catch (IOException iOException) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, string), iOException);
        }
        if (objectId == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, string));
        }
        return objectId;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ObjectId call() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public void setApplyIndex(boolean bl2) {
        this.restoreIndex = bl2;
    }

    public StashApplyCommand setRestoreIndex(boolean bl2) {
        this.restoreIndex = bl2;
        return this;
    }

    public StashApplyCommand setStrategy(MergeStrategy mergeStrategy) {
        this.strategy = mergeStrategy;
        return this;
    }

    public StashApplyCommand setContentMergeStrategy(ContentMergeStrategy contentMergeStrategy) {
        this.checkCallable();
        this.contentStrategy = contentMergeStrategy;
        return this;
    }

    @Deprecated
    public void setApplyUntracked(boolean bl2) {
        this.restoreUntracked = bl2;
    }

    public StashApplyCommand setRestoreUntracked(boolean bl2) {
        this.restoreUntracked = bl2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIndex(RevTree revTree) {
        DirCache dirCache = this.repo.lockDirCache();
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            DirCacheBuilder dirCacheBuilder = dirCache.builder();
            treeWalk.addTree(revTree);
            treeWalk.addTree(new DirCacheIterator(dirCache));
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                AbstractTreeIterator abstractTreeIterator = treeWalk.getTree(0, AbstractTreeIterator.class);
                if (abstractTreeIterator == null) continue;
                DirCacheEntry dirCacheEntry = new DirCacheEntry(treeWalk.getRawPath());
                dirCacheEntry.setFileMode(abstractTreeIterator.getEntryFileMode());
                dirCacheEntry.setObjectIdFromRaw(abstractTreeIterator.idBuffer(), abstractTreeIterator.idOffset());
                DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(1, DirCacheIterator.class);
                if (dirCacheIterator != null && dirCacheIterator.idEqual(abstractTreeIterator)) {
                    DirCacheEntry dirCacheEntry2 = dirCacheIterator.getDirCacheEntry();
                    dirCacheEntry.setLastModified(dirCacheEntry2.getLastModifiedInstant());
                    dirCacheEntry.setLength(dirCacheEntry2.getLength());
                }
                dirCacheBuilder.add(dirCacheEntry);
            }
            dirCacheBuilder.commit();
        }
        finally {
            dirCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUntracked(RevTree revTree) {
        HashSet<String> hashSet = new HashSet<String>();
        Checkout checkout = new Checkout(this.repo).setRecursiveDeletion(true);
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            treeWalk.addTree(revTree);
            treeWalk.addTree(new FileTreeIterator(this.repo));
            treeWalk.setRecursive(true);
            ObjectReader objectReader = treeWalk.getObjectReader();
            while (treeWalk.next()) {
                AbstractTreeIterator abstractTreeIterator = treeWalk.getTree(0, AbstractTreeIterator.class);
                if (abstractTreeIterator == null) continue;
                CoreConfig$EolStreamType coreConfig$EolStreamType = treeWalk.getEolStreamType(TreeWalk$OperationType.CHECKOUT_OP);
                DirCacheEntry dirCacheEntry = new DirCacheEntry(treeWalk.getRawPath());
                dirCacheEntry.setFileMode(abstractTreeIterator.getEntryFileMode());
                dirCacheEntry.setObjectIdFromRaw(abstractTreeIterator.idBuffer(), abstractTreeIterator.idOffset());
                FileTreeIterator fileTreeIterator = (FileTreeIterator)treeWalk.getTree(1, FileTreeIterator.class);
                String string = dirCacheEntry.getPathString();
                if (fileTreeIterator != null && fileTreeIterator.isModified(dirCacheEntry, true, objectReader)) {
                    throw new CheckoutConflictException(string);
                }
                this.checkoutPath(dirCacheEntry, string, objectReader, checkout, new DirCacheCheckout$CheckoutMetadata(coreConfig$EolStreamType, null));
                hashSet.add(string);
            }
        }
        finally {
            if (!hashSet.isEmpty()) {
                this.repo.fireEvent(new WorkingTreeModifiedEvent(hashSet, null));
            }
        }
    }

    private void checkoutPath(DirCacheEntry dirCacheEntry, String string, ObjectReader objectReader, Checkout checkout, DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata) {
        try {
            checkout.checkout(dirCacheEntry, dirCacheCheckout$CheckoutMetadata, objectReader, string);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, dirCacheEntry.getPathString()), iOException);
        }
    }
}

