/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class ShowNoteCommand
extends GitCommand {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected ShowNoteCommand(Repository repository) {
        super(repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Note call() {
        this.checkCallable();
        NoteMap noteMap = NoteMap.newEmptyMap();
        RevCommit revCommit = null;
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Ref ref = this.repo.exactRef(this.notesRef);
            if (ref != null) {
                revCommit = revWalk.parseCommit(ref.getObjectId());
                noteMap = NoteMap.read(revWalk.getObjectReader(), revCommit);
            }
            Note note = noteMap.getNote(this.id);
            return note;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    public ShowNoteCommand setObjectId(RevObject revObject) {
        this.checkCallable();
        this.id = revObject;
        return this;
    }

    public ShowNoteCommand setNotesRef(String string) {
        this.checkCallable();
        this.notesRef = string;
        return this;
    }
}

