/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class RmCommand
extends GitCommand {
    private Collection filepatterns = new LinkedList();
    private boolean cached = false;

    public RmCommand(Repository repository) {
        super(repository);
    }

    public RmCommand addFilepattern(String string) {
        this.checkCallable();
        this.filepatterns.add(string);
        return this;
    }

    public RmCommand setCached(boolean bl2) {
        this.checkCallable();
        this.cached = bl2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirCache call() {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dirCache = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            dirCache = this.repo.lockDirCache();
            DirCacheBuilder dirCacheBuilder = dirCache.builder();
            treeWalk.reset();
            treeWalk.setRecursive(true);
            treeWalk.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            treeWalk.addTree(new DirCacheBuildIterator(dirCacheBuilder));
            while (treeWalk.next()) {
                FileMode fileMode;
                if (this.cached || (fileMode = treeWalk.getFileMode(0)).getObjectType() != 3) continue;
                String string = treeWalk.getPathString();
                File file = new File(this.repo.getWorkTree(), string);
                if (!this.delete(file)) continue;
                arrayList.add(string);
            }
            dirCacheBuilder.commit();
            this.setCallable(false);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfRmCommand, iOException);
        }
        finally {
            try {
                if (dirCache != null) {
                    dirCache.unlock();
                }
            }
            finally {
                if (!arrayList.isEmpty()) {
                    this.repo.fireEvent(new WorkingTreeModifiedEvent(null, arrayList));
                }
            }
        }
        return dirCache;
    }

    private boolean delete(File file) {
        boolean bl2 = false;
        while (file != null && !file.equals(this.repo.getWorkTree()) && file.delete()) {
            bl2 = true;
            file = file.getParentFile();
        }
        return bl2;
    }
}

