/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.MergeResult$MergeStatus;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;

public class RevertCommand
extends GitCommand {
    private List commits = new LinkedList();
    private String ourCommitName = null;
    private List revertedRefs = new LinkedList();
    private MergeResult failingResult;
    private List unmergedPaths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected RevertCommand(Repository repository) {
        super(repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() {
        RevCommit revCommit = null;
        this.checkCallable();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Object object;
            Object object2;
            String string;
            ResolveMerger resolveMerger;
            RevCommit revCommit2;
            RevCommit revCommit3;
            RevCommit revCommit4;
            block35: {
                Ref ref = this.repo.exactRef("HEAD");
                if (ref == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                revCommit = revCommit4 = revWalk.parseCommit(ref.getObjectId());
                Iterator iterator = this.commits.iterator();
                while (iterator.hasNext()) {
                    Ref ref2 = (Ref)iterator.next();
                    ObjectId objectId = ref2.getPeeledObjectId();
                    if (objectId == null) {
                        objectId = ref2.getObjectId();
                    }
                    if ((revCommit3 = revWalk.parseCommit(objectId)).getParentCount() != 1) {
                        throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyRevertCommitsWithOneParent, revCommit3.name(), revCommit3.getParentCount()));
                    }
                    revCommit2 = revCommit3.getParent(0);
                    revWalk.parseHeaders(revCommit2);
                    String string2 = this.calculateOurName(ref);
                    String string3 = revCommit3.getId().abbreviate(7).name() + " " + revCommit3.getShortMessage();
                    resolveMerger = (ResolveMerger)this.strategy.newMerger(this.repo);
                    resolveMerger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                    resolveMerger.setBase(revCommit3.getTree());
                    resolveMerger.setCommitNames(new String[]{"BASE", string2, string3});
                    String string4 = "Revert \"" + revCommit3.getShortMessage() + "\"";
                    string = string4 + "\n\nThis reverts commit " + revCommit3.getId().getName() + ".\n";
                    if (!resolveMerger.merge(revCommit4, revCommit2)) break block35;
                    if (!resolveMerger.getModifiedFiles().isEmpty()) {
                        this.repo.fireEvent(new WorkingTreeModifiedEvent(resolveMerger.getModifiedFiles(), null));
                    }
                    if (AnyObjectId.isEqual(revCommit4.getTree().getId(), resolveMerger.getResultTreeId())) continue;
                    object2 = new DirCacheCheckout(this.repo, revCommit4.getTree(), this.repo.lockDirCache(), resolveMerger.getResultTreeId());
                    ((DirCacheCheckout)object2).setFailOnConflict(true);
                    ((DirCacheCheckout)object2).setProgressMonitor(this.monitor);
                    ((DirCacheCheckout)object2).checkout();
                    object = new Git(this.getRepository());
                    Throwable throwable = null;
                    try {
                        revCommit = ((Git)object).commit().setMessage(string).setReflogComment("revert: " + string4).call();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((Git)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((Git)object).close();
                            }
                        }
                    }
                    this.revertedRefs.add(ref2);
                    revCommit4 = revCommit;
                }
                return revCommit;
            }
            this.unmergedPaths = resolveMerger.getUnmergedPaths();
            object2 = resolveMerger.getFailingPaths();
            this.failingResult = object2 != null ? new MergeResult(null, resolveMerger.getBaseCommitId(), new ObjectId[]{revCommit4.getId(), revCommit2.getId()}, MergeResult$MergeStatus.FAILED, this.strategy, resolveMerger.getMergeResults(), (Map)object2, null) : new MergeResult(null, resolveMerger.getBaseCommitId(), new ObjectId[]{revCommit4.getId(), revCommit2.getId()}, MergeResult$MergeStatus.CONFLICTING, this.strategy, resolveMerger.getMergeResults(), (Map)object2, null);
            if (!resolveMerger.failed() && !this.unmergedPaths.isEmpty()) {
                object = new MergeMessageFormatter().formatWithConflicts(string, resolveMerger.getUnmergedPaths());
                this.repo.writeRevertHead(revCommit3.getId());
                this.repo.writeMergeCommitMsg((String)object);
            }
            object = null;
            return object;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfRevertCommand, iOException), iOException);
        }
    }

    public RevertCommand include(Ref ref) {
        this.checkCallable();
        this.commits.add(ref);
        return this;
    }

    public RevertCommand include(AnyObjectId anyObjectId) {
        return this.include(anyObjectId.getName(), anyObjectId);
    }

    public RevertCommand include(String string, AnyObjectId anyObjectId) {
        return this.include(new ObjectIdRef$Unpeeled(Ref$Storage.LOOSE, string, anyObjectId.copy()));
    }

    public RevertCommand setOurCommitName(String string) {
        this.ourCommitName = string;
        return this;
    }

    private String calculateOurName(Ref ref) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String string = ref.getTarget().getName();
        String string2 = Repository.shortenRefName(string);
        return string2;
    }

    public List getRevertedRefs() {
        return this.revertedRefs;
    }

    public MergeResult getFailingResult() {
        return this.failingResult;
    }

    public List getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public RevertCommand setStrategy(MergeStrategy mergeStrategy) {
        this.strategy = mergeStrategy;
        return this;
    }

    public RevertCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }
}

