/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.ResetCommand$ResetType;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class ResetCommand
extends GitCommand {
    private String ref = null;
    private ResetCommand$ResetType mode;
    private Collection filepaths = new LinkedList();
    private boolean isReflogDisabled;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    public ResetCommand(Repository repository) {
        super(repository);
    }

    @Override
    public Ref call() {
        this.checkCallable();
        try {
            RepositoryState repositoryState = this.repo.getRepositoryState();
            boolean bl2 = repositoryState.equals((Object)RepositoryState.MERGING) || repositoryState.equals((Object)RepositoryState.MERGING_RESOLVED);
            boolean bl3 = repositoryState.equals((Object)RepositoryState.CHERRY_PICKING) || repositoryState.equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED);
            boolean bl4 = repositoryState.equals((Object)RepositoryState.REVERTING) || repositoryState.equals((Object)RepositoryState.REVERTING_RESOLVED);
            ObjectId objectId = this.resolveRefToCommitId();
            if (this.ref != null && objectId == null) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().invalidRefName, this.ref));
            }
            RevTree revTree = objectId != null ? this.parseCommit(objectId).getTree() : null;
            if (!this.filepaths.isEmpty()) {
                this.resetIndexForPaths(revTree);
                this.setCallable(false);
                return this.repo.exactRef("HEAD");
            }
            if (objectId != null) {
                Object object;
                RefUpdate refUpdate = this.repo.updateRef("HEAD");
                refUpdate.setNewObjectId(objectId);
                String string = Repository.shortenRefName(this.getRefOrHEAD());
                if (this.isReflogDisabled) {
                    refUpdate.disableRefLog();
                } else {
                    object = string + ": updating " + "HEAD";
                    refUpdate.setRefLogMessage((String)object, false);
                }
                if (refUpdate.forceUpdate() == RefUpdate$Result.LOCK_FAILURE) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotLock, refUpdate.getName()));
                }
                object = refUpdate.getOldObjectId();
                if (object != null) {
                    this.repo.writeOrigHead((ObjectId)object);
                }
            }
            Ref ref = this.repo.exactRef("HEAD");
            if (this.mode == null) {
                this.mode = ResetCommand$ResetType.MIXED;
            }
            switch (this.mode) {
                case HARD: {
                    this.checkoutIndex(revTree);
                    break;
                }
                case MIXED: {
                    this.resetIndex(revTree);
                    break;
                }
                case SOFT: {
                    break;
                }
                case KEEP: 
                case MERGE: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.mode != ResetCommand$ResetType.SOFT) {
                if (bl2) {
                    this.resetMerge();
                } else if (bl3) {
                    this.resetCherryPick();
                } else if (bl4) {
                    this.resetRevert();
                } else if (this.repo.readSquashCommitMsg() != null) {
                    this.repo.writeSquashCommitMsg(null);
                }
            }
            this.setCallable(false);
            return ref;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfResetCommand, iOException.getMessage()), iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RevCommit parseCommit(ObjectId objectId) {
        try (RevWalk revWalk = new RevWalk(this.repo);){
            RevCommit revCommit = revWalk.parseCommit(objectId);
            return revCommit;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, objectId.toString()), iOException);
        }
    }

    private ObjectId resolveRefToCommitId() {
        try {
            return this.repo.resolve(this.getRefOrHEAD() + "^{commit}");
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotRead, this.getRefOrHEAD()), iOException);
        }
    }

    public ResetCommand setRef(String string) {
        this.ref = string;
        return this;
    }

    public ResetCommand setMode(ResetCommand$ResetType resetCommand$ResetType) {
        if (!this.filepaths.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "[--mixed | --soft | --hard]", "<paths>..."));
        }
        this.mode = resetCommand$ResetType;
        return this;
    }

    public ResetCommand addPath(String string) {
        if (this.mode != null) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "<paths>...", "[--mixed | --soft | --hard]"));
        }
        this.filepaths.add(string);
        return this;
    }

    public ResetCommand disableRefLog(boolean bl2) {
        this.isReflogDisabled = bl2;
        return this;
    }

    public boolean isReflogDisabled() {
        return this.isReflogDisabled;
    }

    private String getRefOrHEAD() {
        if (this.ref != null) {
            return this.ref;
        }
        return "HEAD";
    }

    public ResetCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }

    private void resetIndexForPaths(ObjectId objectId) {
        DirCache dirCache = null;
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            dirCache = this.repo.lockDirCache();
            DirCacheBuilder dirCacheBuilder = dirCache.builder();
            treeWalk.addTree(new DirCacheBuildIterator(dirCacheBuilder));
            if (objectId != null) {
                treeWalk.addTree(objectId);
            } else {
                treeWalk.addTree(new EmptyTreeIterator());
            }
            treeWalk.setFilter(PathFilterGroup.createFromStrings(this.filepaths));
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                CanonicalTreeParser canonicalTreeParser = (CanonicalTreeParser)treeWalk.getTree(1, CanonicalTreeParser.class);
                if (canonicalTreeParser == null) continue;
                DirCacheEntry dirCacheEntry = new DirCacheEntry(treeWalk.getRawPath());
                dirCacheEntry.setFileMode(canonicalTreeParser.getEntryFileMode());
                dirCacheEntry.setObjectId(canonicalTreeParser.getEntryObjectId());
                dirCacheBuilder.add(dirCacheEntry);
            }
            dirCacheBuilder.commit();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (dirCache != null) {
                dirCache.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIndex(ObjectId objectId) {
        DirCache dirCache = this.repo.lockDirCache();
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            DirCacheBuilder dirCacheBuilder = dirCache.builder();
            if (objectId != null) {
                treeWalk.addTree(objectId);
            } else {
                treeWalk.addTree(new EmptyTreeIterator());
            }
            treeWalk.addTree(new DirCacheIterator(dirCache));
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                AbstractTreeIterator abstractTreeIterator = treeWalk.getTree(0, AbstractTreeIterator.class);
                if (abstractTreeIterator == null) continue;
                DirCacheEntry dirCacheEntry = new DirCacheEntry(treeWalk.getRawPath());
                dirCacheEntry.setFileMode(abstractTreeIterator.getEntryFileMode());
                dirCacheEntry.setObjectIdFromRaw(abstractTreeIterator.idBuffer(), abstractTreeIterator.idOffset());
                DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(1, DirCacheIterator.class);
                if (dirCacheIterator != null && dirCacheIterator.idEqual(abstractTreeIterator)) {
                    DirCacheEntry dirCacheEntry2 = dirCacheIterator.getDirCacheEntry();
                    dirCacheEntry.setLastModified(dirCacheEntry2.getLastModifiedInstant());
                    dirCacheEntry.setLength(dirCacheEntry2.getLength());
                }
                dirCacheBuilder.add(dirCacheEntry);
            }
            dirCacheBuilder.commit();
        }
        finally {
            dirCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkoutIndex(ObjectId objectId) {
        DirCache dirCache = this.repo.lockDirCache();
        try {
            DirCacheCheckout dirCacheCheckout = new DirCacheCheckout(this.repo, dirCache, objectId);
            dirCacheCheckout.setFailOnConflict(false);
            dirCacheCheckout.setProgressMonitor(this.monitor);
            try {
                dirCacheCheckout.checkout();
            }
            catch (org.eclipse.jgit.errors.CheckoutConflictException checkoutConflictException) {
                throw new CheckoutConflictException(dirCacheCheckout.getConflicts(), checkoutConflictException);
            }
        }
        finally {
            dirCache.unlock();
        }
    }

    private void resetMerge() {
        this.repo.writeMergeHeads(null);
        this.repo.writeMergeCommitMsg(null);
    }

    private void resetCherryPick() {
        this.repo.writeCherryPickHead(null);
        this.repo.writeMergeCommitMsg(null);
    }

    private void resetRevert() {
        this.repo.writeRevertHead(null);
        this.repo.writeMergeCommitMsg(null);
    }

    public String toString() {
        return "ResetCommand [repo=" + this.repo + ", ref=" + this.ref + ", mode=" + (Object)((Object)this.mode) + ", isReflogDisabled=" + this.isReflogDisabled + ", filepaths=" + this.filepaths + "]";
    }
}

