/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

public class RenameBranchCommand
extends GitCommand {
    private String oldName;
    private String newName;

    protected RenameBranchCommand(Repository repository) {
        super(repository);
    }

    @Override
    public Ref call() {
        this.checkCallable();
        if (this.newName == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, "<null>"));
        }
        try {
            Object object;
            String string;
            String string2;
            Object object2;
            Object object3;
            if (this.oldName != null) {
                object3 = this.repo.exactRef(this.oldName);
                if (object3 == null) {
                    object3 = this.repo.exactRef("refs/heads/" + this.oldName);
                    object2 = this.repo.exactRef("refs/remotes/" + this.oldName);
                    if (object3 != null && object2 != null) {
                        throw new RefNotFoundException(MessageFormat.format(JGitText.get().renameBranchFailedAmbiguous, this.oldName, object3.getName(), object2.getName()));
                    }
                    if (object3 == null) {
                        if (object2 != null) {
                            object3 = object2;
                        } else {
                            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.oldName));
                        }
                    }
                }
                string2 = object3.getName();
            } else {
                string2 = this.repo.getFullBranch();
                if (string2 == null) {
                    throw new NoHeadException(JGitText.get().invalidRepositoryStateNoHead);
                }
                if (ObjectId.isId(string2)) {
                    throw new DetachedHeadException();
                }
            }
            if (string2.startsWith("refs/remotes/")) {
                string = "refs/remotes/" + this.newName;
            } else if (string2.startsWith("refs/heads/")) {
                string = "refs/heads/" + this.newName;
            } else {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().renameBranchFailedNotABranch, string2));
            }
            if (!Repository.isValidRefName(string)) {
                throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, string));
            }
            if (this.repo.exactRef(string) != null) {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists1, string));
            }
            object3 = this.repo.renameRef(string2, string);
            object2 = ((RefRename)object3).rename();
            this.setCallable(false);
            if (RefUpdate$Result.RENAMED != object2) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().renameBranchUnexpectedResult, ((Enum)object2).name()));
            }
            if (string.startsWith("refs/heads/")) {
                object = string2.substring("refs/heads/".length());
                StoredConfig storedConfig = this.repo.getConfig();
                for (String string3 : storedConfig.getNames("branch", (String)object)) {
                    String[] stringArray = storedConfig.getStringList("branch", (String)object, string3);
                    if (stringArray.length == 0) continue;
                    String[] stringArray2 = storedConfig.getStringList("branch", this.newName, string3);
                    if (stringArray2.length > 0) {
                        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
                        System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                        System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
                        stringArray = stringArray3;
                    }
                    storedConfig.setStringList("branch", this.newName, string3, Arrays.asList(stringArray));
                }
                storedConfig.unsetSection("branch", (String)object);
                storedConfig.save();
            }
            if ((object = this.repo.exactRef(string)) == null) {
                throw new JGitInternalException(JGitText.get().renameBranchFailedUnknownReason);
            }
            return object;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    public RenameBranchCommand setNewName(String string) {
        this.checkCallable();
        this.newName = string;
        return this;
    }

    public RenameBranchCommand setOldName(String string) {
        this.checkCallable();
        this.oldName = string;
        return this;
    }
}

