/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.RemoteSetUrlCommand$UriType;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class RemoteSetUrlCommand
extends GitCommand {
    private String remoteName;
    private URIish remoteUri;
    private RemoteSetUrlCommand$UriType type;

    protected RemoteSetUrlCommand(Repository repository) {
        super(repository);
    }

    @Deprecated
    public void setName(String string) {
        this.remoteName = string;
    }

    public RemoteSetUrlCommand setRemoteName(String string) {
        this.remoteName = string;
        return this;
    }

    @Deprecated
    public void setUri(URIish uRIish) {
        this.remoteUri = uRIish;
    }

    public RemoteSetUrlCommand setRemoteUri(URIish uRIish) {
        this.remoteUri = uRIish;
        return this;
    }

    @Deprecated
    public void setPush(boolean bl2) {
        if (bl2) {
            this.setUriType(RemoteSetUrlCommand$UriType.PUSH);
        } else {
            this.setUriType(RemoteSetUrlCommand$UriType.FETCH);
        }
    }

    public RemoteSetUrlCommand setUriType(RemoteSetUrlCommand$UriType remoteSetUrlCommand$UriType) {
        this.type = remoteSetUrlCommand$UriType;
        return this;
    }

    @Override
    public RemoteConfig call() {
        this.checkCallable();
        try {
            StoredConfig storedConfig = this.repo.getConfig();
            RemoteConfig remoteConfig = new RemoteConfig(storedConfig, this.remoteName);
            if (this.type == RemoteSetUrlCommand$UriType.PUSH) {
                List list = remoteConfig.getPushURIs();
                if (list.size() > 1) {
                    throw new JGitInternalException("remote.newtest.pushurl has multiple values");
                }
                if (list.size() == 1) {
                    remoteConfig.removePushURI((URIish)list.get(0));
                }
                remoteConfig.addPushURI(this.remoteUri);
            } else {
                List list = remoteConfig.getURIs();
                if (list.size() > 1) {
                    throw new JGitInternalException("remote.newtest.url has multiple values");
                }
                if (list.size() == 1) {
                    remoteConfig.removeURI((URIish)list.get(0));
                }
                remoteConfig.addURI(this.remoteUri);
            }
            remoteConfig.update(storedConfig);
            storedConfig.save();
            return remoteConfig;
        }
        catch (IOException | URISyntaxException exception) {
            throw new JGitInternalException(exception.getMessage(), exception);
        }
    }
}

