/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;

public class RemoteRemoveCommand
extends GitCommand {
    private String remoteName;

    protected RemoteRemoveCommand(Repository repository) {
        super(repository);
    }

    @Deprecated
    public void setName(String string) {
        this.remoteName = string;
    }

    public RemoteRemoveCommand setRemoteName(String string) {
        this.remoteName = string;
        return this;
    }

    @Override
    public RemoteConfig call() {
        this.checkCallable();
        try {
            StoredConfig storedConfig = this.repo.getConfig();
            RemoteConfig remoteConfig = new RemoteConfig(storedConfig, this.remoteName);
            storedConfig.unsetSection("remote", this.remoteName);
            storedConfig.save();
            return remoteConfig;
        }
        catch (IOException | URISyntaxException exception) {
            throw new JGitInternalException(exception.getMessage(), exception);
        }
    }
}

