/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class RemoteAddCommand
extends GitCommand {
    private String name;
    private URIish uri;

    protected RemoteAddCommand(Repository repository) {
        super(repository);
    }

    public RemoteAddCommand setName(String string) {
        this.name = string;
        return this;
    }

    public RemoteAddCommand setUri(URIish uRIish) {
        this.uri = uRIish;
        return this;
    }

    @Override
    public RemoteConfig call() {
        this.checkCallable();
        try {
            StoredConfig storedConfig = this.repo.getConfig();
            RemoteConfig remoteConfig = new RemoteConfig(storedConfig, this.name);
            RefSpec refSpec = new RefSpec();
            refSpec = refSpec.setForceUpdate(true);
            refSpec = refSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + this.name + "/*");
            remoteConfig.addFetchRefSpec(refSpec);
            remoteConfig.addURI(this.uri);
            remoteConfig.update(storedConfig);
            storedConfig.save();
            return remoteConfig;
        }
        catch (IOException | URISyntaxException exception) {
            throw new JGitInternalException(exception.getMessage(), exception);
        }
    }
}

