/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;

public class ReflogCommand
extends GitCommand {
    private String ref = "HEAD";

    public ReflogCommand(Repository repository) {
        super(repository);
    }

    public ReflogCommand setRef(String string) {
        this.checkCallable();
        this.ref = string;
        return this;
    }

    @Override
    public Collection call() {
        this.checkCallable();
        try {
            ReflogReader reflogReader = this.repo.getReflogReader(this.ref);
            if (reflogReader == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.ref));
            }
            return reflogReader.getReverseEntries();
        }
        catch (IOException iOException) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, this.ref), iOException);
        }
    }
}

