/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CherryPickCommand;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeCommand$FastForwardMode;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.MergeResult$MergeStatus;
import org.eclipse.jgit.api.RebaseCommand$1;
import org.eclipse.jgit.api.RebaseCommand$InteractiveHandler;
import org.eclipse.jgit.api.RebaseCommand$Operation;
import org.eclipse.jgit.api.RebaseCommand$RebaseState;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.RebaseResult$Status;
import org.eclipse.jgit.api.ResetCommand$ResetType;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.InvalidRebaseStepException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.StashApplyFailureException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.RebaseTodoLine$Action;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.submodule.SubmoduleWalk$IgnoreSubmoduleMode;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class RebaseCommand
extends GitCommand {
    public static final String REBASE_MERGE = "rebase-merge";
    private static final String REBASE_APPLY = "rebase-apply";
    public static final String STOPPED_SHA = "stopped-sha";
    private static final String AUTHOR_SCRIPT = "author-script";
    private static final String DONE = "done";
    private static final String GIT_AUTHOR_DATE = "GIT_AUTHOR_DATE";
    private static final String GIT_AUTHOR_EMAIL = "GIT_AUTHOR_EMAIL";
    private static final String GIT_AUTHOR_NAME = "GIT_AUTHOR_NAME";
    private static final String GIT_REBASE_TODO = "git-rebase-todo";
    private static final String HEAD_NAME = "head-name";
    private static final String INTERACTIVE = "interactive";
    private static final String QUIET = "quiet";
    private static final String MESSAGE = "message";
    private static final String ONTO = "onto";
    private static final String ONTO_NAME = "onto_name";
    private static final String PATCH = "patch";
    private static final String REBASE_HEAD = "orig-head";
    private static final String REBASE_HEAD_LEGACY = "head";
    private static final String AMEND = "amend";
    private static final String MESSAGE_FIXUP = "message-fixup";
    private static final String MESSAGE_SQUASH = "message-squash";
    private static final String AUTOSTASH = "autostash";
    private static final String AUTOSTASH_MSG = "On {0}: autostash";
    private static final String REWRITTEN = "rewritten";
    private static final String CURRENT_COMMIT = "current-commit";
    private static final String REFLOG_PREFIX = "rebase:";
    private RebaseCommand$Operation operation = RebaseCommand$Operation.BEGIN;
    private RevCommit upstreamCommit;
    private String upstreamCommitName;
    private ObjectId upstreamFrom;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private final RevWalk walk;
    private final RebaseCommand$RebaseState rebaseState;
    private RebaseCommand$InteractiveHandler interactiveHandler;
    private boolean stopAfterInitialization = false;
    private RevCommit newHead;
    private boolean lastStepWasForward;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;
    private boolean preserveMerges = false;
    private boolean preserveCommitter = false;

    protected RebaseCommand(Repository repository) {
        super(repository);
        this.walk = new RevWalk(repository);
        this.rebaseState = new RebaseCommand$RebaseState(repository.getDirectory());
    }

    @Override
    public RebaseResult call() {
        this.newHead = null;
        this.lastStepWasForward = false;
        this.checkCallable();
        this.checkParameters();
        try {
            Object object;
            Iterator iterator;
            Object object2;
            switch (this.operation) {
                case ABORT: {
                    try {
                        return this.abort(RebaseResult.ABORTED_RESULT);
                    }
                    catch (IOException iOException) {
                        throw new JGitInternalException(iOException.getMessage(), iOException);
                    }
                }
                case PROCESS_STEPS: 
                case SKIP: 
                case CONTINUE: {
                    object2 = this.rebaseState.readFile(ONTO);
                    try {
                        this.upstreamCommitName = this.rebaseState.readFile(ONTO_NAME);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.upstreamCommitName = object2;
                    }
                    this.upstreamCommit = this.walk.parseCommit(this.repo.resolve((String)object2));
                    this.preserveMerges = this.rebaseState.getRewrittenDir().isDirectory();
                    break;
                }
                case BEGIN: {
                    this.autoStash();
                    if ((this.stopAfterInitialization || !this.walk.isMergedInto(this.walk.parseCommit(this.repo.resolve("HEAD")), this.upstreamCommit)) && ((Status)((Object)(iterator = Git.wrap(this.repo).status().setIgnoreSubmodules(SubmoduleWalk$IgnoreSubmoduleMode.ALL).call()))).hasUncommittedChanges()) {
                        ArrayList arrayList = new ArrayList();
                        arrayList.addAll(((Status)((Object)iterator)).getUncommittedChanges());
                        return RebaseResult.uncommittedChanges(arrayList);
                    }
                    iterator = this.initFilesAndRewind();
                    if (this.stopAfterInitialization) {
                        return RebaseResult.INTERACTIVE_PREPARED_RESULT;
                    }
                    if (iterator == null) break;
                    this.autoStashApply();
                    if (this.rebaseState.getDir().exists()) {
                        FileUtils.delete(this.rebaseState.getDir(), 1);
                    }
                    return iterator;
                }
            }
            if (this.monitor.isCancelled()) {
                return this.abort(RebaseResult.ABORTED_RESULT);
            }
            if (this.operation == RebaseCommand$Operation.CONTINUE) {
                RebaseResult rebaseResult;
                this.newHead = this.continueRebase();
                object2 = this.repo.readRebaseTodo(this.rebaseState.getPath(DONE), true);
                iterator = (RebaseTodoLine)object2.get(object2.size() - 1);
                if (this.newHead != null && ((RebaseTodoLine)((Object)iterator)).getAction() != RebaseTodoLine$Action.PICK && (rebaseResult = this.processStep((RebaseTodoLine)(object = new RebaseTodoLine(((RebaseTodoLine)((Object)iterator)).getAction(), AbbreviatedObjectId.fromObjectId(this.newHead), ((RebaseTodoLine)((Object)iterator)).getShortMessage())), false)) != null) {
                    return rebaseResult;
                }
                object = this.rebaseState.getFile(AMEND);
                boolean bl2 = ((File)object).exists();
                if (bl2) {
                    FileUtils.delete((File)object);
                }
                if (this.newHead == null && !bl2) {
                    return RebaseResult.NOTHING_TO_COMMIT_RESULT;
                }
            }
            if (this.operation == RebaseCommand$Operation.SKIP) {
                this.newHead = this.checkoutCurrentHead();
            }
            if ((object2 = this.repo.readRebaseTodo(this.rebaseState.getPath(GIT_REBASE_TODO), false)).isEmpty()) {
                return this.finishRebase(this.walk.parseCommit(this.repo.resolve("HEAD")), false);
            }
            if (this.isInteractive()) {
                this.interactiveHandler.prepareSteps((List)object2);
                this.repo.writeRebaseTodoFile(this.rebaseState.getPath(GIT_REBASE_TODO), (List)object2, false);
            }
            this.checkSteps((List)object2);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (RebaseTodoLine)iterator.next();
                this.popSteps(1);
                RebaseResult rebaseResult = this.processStep((RebaseTodoLine)object, true);
                if (rebaseResult == null) continue;
                return rebaseResult;
            }
            return this.finishRebase(this.newHead, this.lastStepWasForward);
        }
        catch (CheckoutConflictException checkoutConflictException) {
            return RebaseResult.conflicts(checkoutConflictException.getConflictingPaths());
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    private void autoStash() {
        if (this.repo.getConfig().getBoolean("rebase", AUTOSTASH, false)) {
            String string = MessageFormat.format(AUTOSTASH_MSG, Repository.shortenRefName(RebaseCommand.getHeadName(this.getHead())));
            RevCommit revCommit = Git.wrap(this.repo).stashCreate().setRef(null).setWorkingDirectoryMessage(string).call();
            if (revCommit != null) {
                FileUtils.mkdir(this.rebaseState.getDir());
                this.rebaseState.createFile(AUTOSTASH, revCommit.getName());
            }
        }
    }

    private boolean autoStashApply() {
        boolean bl2 = false;
        if (this.rebaseState.getFile(AUTOSTASH).exists()) {
            String string = this.rebaseState.readFile(AUTOSTASH);
            try (Git git = Git.wrap(this.repo);){
                git.stashApply().setStashRef(string).ignoreRepositoryState(true).setStrategy(this.strategy).call();
            }
            catch (StashApplyFailureException stashApplyFailureException) {
                bl2 = true;
                try (RevWalk revWalk = new RevWalk(this.repo);){
                    ObjectId objectId = this.repo.resolve(string);
                    RevCommit revCommit = revWalk.parseCommit(objectId);
                    this.updateStashRef(revCommit, revCommit.getAuthorIdent(), revCommit.getShortMessage());
                }
            }
        }
        return bl2;
    }

    private void updateStashRef(ObjectId objectId, PersonIdent personIdent, String string) {
        Ref ref = this.repo.exactRef("refs/stash");
        RefUpdate refUpdate = this.repo.updateRef("refs/stash");
        refUpdate.setNewObjectId(objectId);
        refUpdate.setRefLogIdent(personIdent);
        refUpdate.setRefLogMessage(string, false);
        refUpdate.setForceRefLog(true);
        if (ref != null) {
            refUpdate.setExpectedOldObjectId(ref.getObjectId());
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.forceUpdate();
    }

    private RebaseResult processStep(RebaseTodoLine rebaseTodoLine, boolean bl2) {
        ObjectReader objectReader;
        Collection collection;
        if (RebaseTodoLine$Action.COMMENT.equals((Object)rebaseTodoLine.getAction())) {
            return null;
        }
        if (this.preserveMerges && bl2 && (RebaseTodoLine$Action.EDIT.equals((Object)rebaseTodoLine.getAction()) || RebaseTodoLine$Action.PICK.equals((Object)rebaseTodoLine.getAction()))) {
            this.writeRewrittenHashes();
        }
        if ((collection = (objectReader = this.repo.newObjectReader()).resolve(rebaseTodoLine.getCommit())).size() != 1) {
            throw new JGitInternalException(JGitText.get().cannotResolveUniquelyAbbrevObjectId);
        }
        RevCommit revCommit = this.walk.parseCommit((AnyObjectId)collection.iterator().next());
        if (bl2) {
            if (this.monitor.isCancelled()) {
                return RebaseResult.result(RebaseResult$Status.STOPPED, revCommit);
            }
            RebaseResult rebaseResult = this.cherryPickCommit(revCommit);
            if (rebaseResult != null) {
                return rebaseResult;
            }
        }
        boolean bl3 = false;
        switch (rebaseTodoLine.getAction()) {
            case PICK: {
                return null;
            }
            case REWORD: {
                String string = revCommit.getFullMessage();
                String string2 = this.interactiveHandler.modifyCommitMessage(string);
                try (Git git = new Git(this.repo);){
                    this.newHead = git.commit().setMessage(string2).setAmend(true).setNoVerify(true).call();
                }
                return null;
            }
            case EDIT: {
                this.rebaseState.createFile(AMEND, revCommit.name());
                return this.stop(revCommit, RebaseResult$Status.EDIT);
            }
            case COMMENT: {
                break;
            }
            case SQUASH: {
                bl3 = true;
            }
            case FIXUP: {
                this.resetSoftToParent();
                List list = this.repo.readRebaseTodo(this.rebaseState.getPath(GIT_REBASE_TODO), false);
                RebaseTodoLine rebaseTodoLine2 = list.isEmpty() ? null : (RebaseTodoLine)list.get(0);
                File file = this.rebaseState.getFile(MESSAGE_FIXUP);
                File file2 = this.rebaseState.getFile(MESSAGE_SQUASH);
                if (bl3 && file.exists()) {
                    file.delete();
                }
                this.newHead = this.doSquashFixup(bl3, revCommit, rebaseTodoLine2, file, file2);
            }
        }
        return null;
    }

    private RebaseResult cherryPickCommit(RevCommit revCommit) {
        try {
            this.monitor.beginTask(MessageFormat.format(JGitText.get().applyingCommit, revCommit.getShortMessage()), 0);
            if (this.preserveMerges) {
                RebaseResult rebaseResult = this.cherryPickCommitPreservingMerges(revCommit);
                return rebaseResult;
            }
            RebaseResult rebaseResult = this.cherryPickCommitFlattening(revCommit);
            return rebaseResult;
        }
        finally {
            this.monitor.endTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RebaseResult cherryPickCommitFlattening(RevCommit revCommit) {
        this.newHead = this.tryFastForward(revCommit);
        this.lastStepWasForward = this.newHead != null;
        if (this.lastStepWasForward) return null;
        String string = this.getOurCommitName();
        try (Git git = new Git(this.repo);){
            CherryPickResult cherryPickResult = git.cherryPick().include(revCommit).setOurCommitName(string).setReflogPrefix(REFLOG_PREFIX).setStrategy(this.strategy).setPreserveCommitter(this.preserveCommitter).setContentMergeStrategy(this.contentStrategy).call();
            switch (cherryPickResult.getStatus()) {
                case FAILED: {
                    if (this.operation == RebaseCommand$Operation.BEGIN) {
                        RebaseResult rebaseResult = this.abort(RebaseResult.failed(cherryPickResult.getFailingPaths()));
                        return rebaseResult;
                    }
                    RebaseResult rebaseResult = this.stop(revCommit, RebaseResult$Status.STOPPED);
                    return rebaseResult;
                }
                case CONFLICTING: {
                    RebaseResult rebaseResult = this.stop(revCommit, RebaseResult$Status.STOPPED);
                    return rebaseResult;
                }
                case OK: {
                    this.newHead = cherryPickResult.getNewHead();
                    return null;
                }
            }
            return null;
        }
    }

    private RebaseResult cherryPickCommitPreservingMerges(RevCommit revCommit) {
        block42: {
            this.writeCurrentCommit(revCommit);
            List list = this.getNewParents(revCommit);
            boolean bl2 = true;
            for (int i2 = 1; i2 < revCommit.getParentCount(); ++i2) {
                bl2 &= ((RevCommit)list.get(i2)).equals(revCommit.getParent(i2));
            }
            this.newHead = bl2 ? this.tryFastForward(revCommit) : null;
            boolean bl3 = this.lastStepWasForward = this.newHead != null;
            if (!this.lastStepWasForward) {
                ObjectId objectId = this.getHead().getObjectId();
                assert (objectId != null);
                if (!AnyObjectId.isEqual(objectId, (AnyObjectId)list.get(0))) {
                    this.checkoutCommit(objectId.getName(), (RevCommit)list.get(0));
                }
                try (Git git = new Git(this.repo);){
                    if (bl2) {
                        boolean bl4 = revCommit.getParentCount() > 1;
                        String string = this.getOurCommitName();
                        CherryPickCommand cherryPickCommand = git.cherryPick().include(revCommit).setOurCommitName(string).setReflogPrefix(REFLOG_PREFIX).setStrategy(this.strategy).setContentMergeStrategy(this.contentStrategy);
                        if (bl4) {
                            cherryPickCommand.setMainlineParentNumber(1);
                            cherryPickCommand.setNoCommit(true);
                            this.writeMergeInfo(revCommit, list);
                        }
                        cherryPickCommand.setPreserveCommitter(this.preserveCommitter);
                        CherryPickResult cherryPickResult = cherryPickCommand.call();
                        switch (cherryPickResult.getStatus()) {
                            case FAILED: {
                                if (this.operation == RebaseCommand$Operation.BEGIN) {
                                    RebaseResult rebaseResult = this.abort(RebaseResult.failed(cherryPickResult.getFailingPaths()));
                                    return rebaseResult;
                                }
                                RebaseResult rebaseResult = this.stop(revCommit, RebaseResult$Status.STOPPED);
                                return rebaseResult;
                            }
                            case CONFLICTING: {
                                RebaseResult rebaseResult = this.stop(revCommit, RebaseResult$Status.STOPPED);
                                return rebaseResult;
                            }
                            case OK: {
                                if (bl4) {
                                    CommitCommand commitCommand = git.commit();
                                    commitCommand.setAuthor(revCommit.getAuthorIdent());
                                    commitCommand.setReflogComment("rebase: " + revCommit.getShortMessage());
                                    this.newHead = commitCommand.call();
                                    break;
                                }
                                this.newHead = cherryPickResult.getNewHead();
                            }
                        }
                        break block42;
                    }
                    MergeCommand mergeCommand = git.merge().setFastForward(MergeCommand$FastForwardMode.NO_FF).setProgressMonitor(this.monitor).setStrategy(this.strategy).setContentMergeStrategy(this.contentStrategy).setCommit(false);
                    for (int i3 = 1; i3 < revCommit.getParentCount(); ++i3) {
                        mergeCommand.include((AnyObjectId)list.get(i3));
                    }
                    MergeResult mergeResult = mergeCommand.call();
                    if (mergeResult.getMergeStatus().isSuccessful()) {
                        CommitCommand commitCommand = git.commit();
                        commitCommand.setAuthor(revCommit.getAuthorIdent());
                        commitCommand.setMessage(revCommit.getFullMessage());
                        commitCommand.setReflogComment("rebase: " + revCommit.getShortMessage());
                        this.newHead = commitCommand.call();
                        break block42;
                    }
                    if (this.operation == RebaseCommand$Operation.BEGIN && mergeResult.getMergeStatus() == MergeResult$MergeStatus.FAILED) {
                        RebaseResult rebaseResult = this.abort(RebaseResult.failed(mergeResult.getFailingPaths()));
                        return rebaseResult;
                    }
                    RebaseResult rebaseResult = this.stop(revCommit, RebaseResult$Status.STOPPED);
                    return rebaseResult;
                }
            }
        }
        return null;
    }

    private void writeMergeInfo(RevCommit revCommit, List list) {
        this.repo.writeMergeHeads(list.subList(1, list.size()));
        this.repo.writeMergeCommitMsg(revCommit.getFullMessage());
    }

    private List getNewParents(RevCommit revCommit) {
        ArrayList<RevCommit> arrayList = new ArrayList<RevCommit>();
        for (int i2 = 0; i2 < revCommit.getParentCount(); ++i2) {
            String string = revCommit.getParent(i2).getName();
            if (!new File(this.rebaseState.getRewrittenDir(), string).exists()) {
                arrayList.add(revCommit.getParent(i2));
                continue;
            }
            String string2 = RebaseCommand$RebaseState.access$000(this.rebaseState.getRewrittenDir(), string);
            if (string2.length() == 0) {
                arrayList.add(this.walk.parseCommit(this.repo.resolve("HEAD")));
                continue;
            }
            arrayList.add(this.walk.parseCommit(ObjectId.fromString(string2)));
        }
        return arrayList;
    }

    private void writeCurrentCommit(RevCommit revCommit) {
        RebaseCommand$RebaseState.access$100(this.rebaseState.getFile(CURRENT_COMMIT), revCommit.name());
    }

    private void writeRewrittenHashes() {
        File file = this.rebaseState.getFile(CURRENT_COMMIT);
        if (!file.exists()) {
            return;
        }
        ObjectId objectId = this.getHead().getObjectId();
        assert (objectId != null);
        String string = objectId.getName();
        String string2 = this.rebaseState.readFile(CURRENT_COMMIT);
        for (String string3 : string2.split("\n")) {
            RebaseCommand$RebaseState.access$200(this.rebaseState.getRewrittenDir(), string3, string);
        }
        FileUtils.delete(file);
    }

    private RebaseResult finishRebase(RevCommit revCommit, boolean bl2) {
        String string = this.rebaseState.readFile(HEAD_NAME);
        this.updateHead(string, revCommit, this.upstreamCommit);
        boolean bl3 = this.autoStashApply();
        this.getRepository().autoGC(this.monitor);
        FileUtils.delete(this.rebaseState.getDir(), 1);
        if (bl3) {
            return RebaseResult.STASH_APPLY_CONFLICTS_RESULT;
        }
        if (bl2 || revCommit == null) {
            return RebaseResult.FAST_FORWARD_RESULT;
        }
        return RebaseResult.OK_RESULT;
    }

    private void checkSteps(List list) {
        if (list.isEmpty()) {
            return;
        }
        if (!(!RebaseTodoLine$Action.SQUASH.equals((Object)((RebaseTodoLine)list.get(0)).getAction()) && !RebaseTodoLine$Action.FIXUP.equals((Object)((RebaseTodoLine)list.get(0)).getAction()) || this.rebaseState.getFile(DONE).exists() && this.rebaseState.readFile(DONE).trim().length() != 0)) {
            throw new InvalidRebaseStepException(MessageFormat.format(JGitText.get().cannotSquashFixupWithoutPreviousCommit, ((RebaseTodoLine)list.get(0)).getAction().name()));
        }
    }

    private RevCommit doSquashFixup(boolean bl2, RevCommit revCommit, RebaseTodoLine rebaseTodoLine, File file, File file2) {
        Object object;
        if (!file2.exists()) {
            object = this.repo.resolve("HEAD");
            RevCommit revCommit2 = this.walk.parseCommit((AnyObjectId)object);
            this.initializeSquashFixupFile(MESSAGE_SQUASH, revCommit2.getFullMessage());
            if (!bl2) {
                this.initializeSquashFixupFile(MESSAGE_FIXUP, revCommit2.getFullMessage());
            }
        }
        object = this.rebaseState.readFile(MESSAGE_SQUASH);
        int n2 = RebaseCommand.parseSquashFixupSequenceCount((String)object) + 1;
        String string = RebaseCommand.composeSquashMessage(bl2, revCommit, (String)object, n2);
        this.rebaseState.createFile(MESSAGE_SQUASH, string);
        if (file.exists()) {
            this.rebaseState.createFile(MESSAGE_FIXUP, string);
        }
        return this.squashIntoPrevious(!file.exists(), rebaseTodoLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSoftToParent() {
        Ref ref = this.repo.exactRef("ORIG_HEAD");
        ObjectId objectId = ref == null ? null : ref.getObjectId();
        try (Git git = Git.wrap(this.repo);){
            git.reset().setMode(ResetCommand$ResetType.SOFT).setRef("HEAD~1").call();
        }
        finally {
            this.repo.writeOrigHead(objectId);
        }
    }

    private RevCommit squashIntoPrevious(boolean bl2, RebaseTodoLine rebaseTodoLine) {
        RevCommit revCommit;
        String string = this.rebaseState.readFile(MESSAGE_SQUASH);
        try (Git git = new Git(this.repo);){
            if (rebaseTodoLine == null || rebaseTodoLine.getAction() != RebaseTodoLine$Action.FIXUP && rebaseTodoLine.getAction() != RebaseTodoLine$Action.SQUASH) {
                if (bl2) {
                    string = this.interactiveHandler.modifyCommitMessage(string);
                }
                revCommit = git.commit().setMessage(RebaseCommand.stripCommentLines(string)).setAmend(true).setNoVerify(true).call();
                this.rebaseState.getFile(MESSAGE_SQUASH).delete();
                this.rebaseState.getFile(MESSAGE_FIXUP).delete();
            } else {
                revCommit = git.commit().setMessage(string).setAmend(true).setNoVerify(true).call();
            }
        }
        return revCommit;
    }

    private static String stripCommentLines(String string) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split("\n")) {
            if (string2.trim().startsWith("#")) continue;
            stringBuilder.append(string2).append("\n");
        }
        if (!string.endsWith("\n") && (n2 = stringBuilder.length()) > 0 && stringBuilder.charAt(n2 - 1) == '\n') {
            stringBuilder.deleteCharAt(n2 - 1);
        }
        return stringBuilder.toString();
    }

    private static String composeSquashMessage(boolean bl2, RevCommit revCommit, String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = RebaseCommand.getOrdinal(n2);
        stringBuilder.setLength(0);
        stringBuilder.append("# This is a combination of ").append(n2).append(" commits.\n");
        stringBuilder.append(string.substring(string.indexOf(10) + 1));
        stringBuilder.append("\n");
        if (bl2) {
            stringBuilder.append("# This is the ").append(n2).append(string2).append(" commit message:\n");
            stringBuilder.append(revCommit.getFullMessage());
        } else {
            stringBuilder.append("# The ").append(n2).append(string2).append(" commit message will be skipped:\n# ");
            stringBuilder.append(revCommit.getFullMessage().replaceAll("([\n\r])", "$1# "));
        }
        return stringBuilder.toString();
    }

    private static String getOrdinal(int n2) {
        switch (n2 % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    static int parseSquashFixupSequenceCount(String string) {
        String string2 = "This is a combination of (.*) commits";
        String string3 = string.substring(0, string.indexOf(10));
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string3);
        if (!matcher.find()) {
            throw new IllegalArgumentException();
        }
        return Integer.parseInt(matcher.group(1));
    }

    private void initializeSquashFixupFile(String string, String string2) {
        this.rebaseState.createFile(string, "# This is a combination of 1 commits.\n# The first commit's message is:\n" + string2);
    }

    private String getOurCommitName() {
        String string = "Upstream, based on " + Repository.shortenRefName(this.upstreamCommitName);
        return string;
    }

    private void updateHead(String string, RevCommit revCommit, RevCommit revCommit2) {
        if (string.startsWith("refs/")) {
            RefUpdate refUpdate = this.repo.updateRef(string);
            refUpdate.setNewObjectId(revCommit);
            refUpdate.setRefLogMessage("rebase finished: " + string + " onto " + revCommit2.getName(), false);
            RefUpdate$Result refUpdate$Result = refUpdate.forceUpdate();
            switch (refUpdate$Result) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new JGitInternalException(JGitText.get().updatingHeadFailed);
                }
            }
            refUpdate = this.repo.updateRef("HEAD");
            refUpdate.setRefLogMessage("rebase finished: returning to " + string, false);
            refUpdate$Result = refUpdate.link(string);
            switch (refUpdate$Result) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new JGitInternalException(JGitText.get().updatingHeadFailed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevCommit checkoutCurrentHead() {
        Object object;
        Object object2;
        Object object3;
        ObjectId objectId = this.repo.resolve("HEAD^{tree}");
        if (objectId == null) {
            throw new NoHeadException(JGitText.get().cannotRebaseWithoutCurrentHead);
        }
        DirCache dirCache = this.repo.lockDirCache();
        try {
            object3 = new DirCacheCheckout(this.repo, dirCache, objectId);
            ((DirCacheCheckout)object3).setFailOnConflict(false);
            ((DirCacheCheckout)object3).setProgressMonitor(this.monitor);
            boolean bl2 = ((DirCacheCheckout)object3).checkout();
            if (bl2) {
                object2 = ((DirCacheCheckout)object3).getToBeDeleted();
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    File file = new File(this.repo.getWorkTree(), string);
                    if (!this.repo.getFS().exists(file)) continue;
                    FileUtils.delete(file, 3);
                }
            }
        }
        finally {
            dirCache.unlock();
        }
        object3 = new RevWalk(this.repo);
        Throwable throwable = null;
        try {
            object = object2 = ((RevWalk)object3).parseCommit(this.repo.resolve("HEAD"));
            return object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object3 != null) {
                if (throwable != null) {
                    try {
                        ((RevWalk)object3).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((RevWalk)object3).close();
                }
            }
        }
    }

    private RevCommit continueRebase() {
        boolean bl2;
        Object object;
        DirCache dirCache = this.repo.readDirCache();
        boolean bl3 = dirCache.hasUnmergedPaths();
        if (bl3) {
            throw new UnmergedPathsException();
        }
        try (AutoCloseable autoCloseable = new TreeWalk(this.repo);){
            ((TreeWalk)autoCloseable).reset();
            ((TreeWalk)autoCloseable).setRecursive(true);
            ((TreeWalk)autoCloseable).addTree(new DirCacheIterator(dirCache));
            object = this.repo.resolve("HEAD^{tree}");
            if (object == null) {
                throw new NoHeadException(JGitText.get().cannotRebaseWithoutCurrentHead);
            }
            ((TreeWalk)autoCloseable).addTree((AnyObjectId)object);
            ((TreeWalk)autoCloseable).setFilter(TreeFilter.ANY_DIFF);
            bl2 = ((TreeWalk)autoCloseable).next();
        }
        if (bl2) {
            autoCloseable = new Git(this.repo);
            var5_4 = null;
            try {
                object = ((Git)autoCloseable).commit();
                ((CommitCommand)object).setMessage(this.rebaseState.readFile(MESSAGE));
                ((CommitCommand)object).setAuthor(this.parseAuthor());
                RevCommit revCommit = ((CommitCommand)object).call();
                return revCommit;
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
            finally {
                if (autoCloseable != null) {
                    if (var5_4 != null) {
                        try {
                            ((Git)autoCloseable).close();
                        }
                        catch (Throwable throwable) {
                            var5_4.addSuppressed(throwable);
                        }
                    } else {
                        ((Git)autoCloseable).close();
                    }
                }
            }
        }
        return null;
    }

    private PersonIdent parseAuthor() {
        byte[] byArray;
        File file = this.rebaseState.getFile(AUTHOR_SCRIPT);
        try {
            byArray = IO.readFully(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file.exists()) {
                throw fileNotFoundException;
            }
            return null;
        }
        return this.parseAuthor(byArray);
    }

    private RebaseResult stop(RevCommit revCommit, RebaseResult$Status rebaseResult$Status) {
        PersonIdent personIdent = revCommit.getAuthorIdent();
        String string = this.toAuthorScript(personIdent);
        this.rebaseState.createFile(AUTHOR_SCRIPT, string);
        this.rebaseState.createFile(MESSAGE, revCommit.getFullMessage());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DiffFormatter diffFormatter = new DiffFormatter(byteArrayOutputStream);){
            diffFormatter.setRepository(this.repo);
            diffFormatter.format(revCommit.getParent(0), revCommit);
        }
        this.rebaseState.createFile(PATCH, new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8));
        this.rebaseState.createFile(STOPPED_SHA, this.repo.newObjectReader().abbreviate(revCommit).name());
        this.repo.writeCherryPickHead(null);
        return RebaseResult.result(rebaseResult$Status, revCommit);
    }

    String toAuthorScript(PersonIdent personIdent) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(GIT_AUTHOR_NAME);
        stringBuilder.append("='");
        stringBuilder.append(personIdent.getName());
        stringBuilder.append("'\n");
        stringBuilder.append(GIT_AUTHOR_EMAIL);
        stringBuilder.append("='");
        stringBuilder.append(personIdent.getEmailAddress());
        stringBuilder.append("'\n");
        stringBuilder.append(GIT_AUTHOR_DATE);
        stringBuilder.append("='");
        stringBuilder.append("@");
        String string = personIdent.toExternalString();
        stringBuilder.append(string.substring(string.lastIndexOf(62) + 2));
        stringBuilder.append("'\n");
        return stringBuilder.toString();
    }

    private void popSteps(int n2) {
        if (n2 == 0) {
            return;
        }
        LinkedList<RebaseTodoLine> linkedList = new LinkedList<RebaseTodoLine>();
        LinkedList<RebaseTodoLine> linkedList2 = new LinkedList<RebaseTodoLine>();
        for (RebaseTodoLine rebaseTodoLine : this.repo.readRebaseTodo(this.rebaseState.getPath(GIT_REBASE_TODO), true)) {
            if (linkedList2.size() >= n2 || RebaseTodoLine$Action.COMMENT.equals((Object)rebaseTodoLine.getAction())) {
                linkedList.add(rebaseTodoLine);
                continue;
            }
            linkedList2.add(rebaseTodoLine);
        }
        this.repo.writeRebaseTodoFile(this.rebaseState.getPath(GIT_REBASE_TODO), linkedList, false);
        if (!linkedList2.isEmpty()) {
            this.repo.writeRebaseTodoFile(this.rebaseState.getPath(DONE), linkedList2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebaseResult initFilesAndRewind() {
        Ref ref = this.getHead();
        ObjectId objectId = ref.getObjectId();
        if (objectId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        String string = RebaseCommand.getHeadName(ref);
        RevCommit revCommit = this.walk.lookupCommit(objectId);
        RevCommit revCommit2 = this.walk.lookupCommit(this.upstreamCommit.getId());
        if (!this.isInteractive() && this.walk.isMergedInto(revCommit2, revCommit)) {
            return RebaseResult.UP_TO_DATE_RESULT;
        }
        if (!this.isInteractive() && this.walk.isMergedInto(revCommit, revCommit2)) {
            this.monitor.beginTask(MessageFormat.format(JGitText.get().resettingHead, this.upstreamCommit.getShortMessage()), 0);
            this.checkoutCommit(string, this.upstreamCommit);
            this.monitor.endTask();
            this.updateHead(string, this.upstreamCommit, revCommit2);
            return RebaseResult.FAST_FORWARD_RESULT;
        }
        this.monitor.beginTask(JGitText.get().obtainingCommitsForCherryPick, 0);
        FileUtils.mkdir(this.rebaseState.getDir(), true);
        this.repo.writeOrigHead(objectId);
        this.rebaseState.createFile(REBASE_HEAD, objectId.name());
        this.rebaseState.createFile(REBASE_HEAD_LEGACY, objectId.name());
        this.rebaseState.createFile(HEAD_NAME, string);
        this.rebaseState.createFile(ONTO, this.upstreamCommit.name());
        this.rebaseState.createFile(ONTO_NAME, this.upstreamCommitName);
        if (this.isInteractive() || this.preserveMerges) {
            this.rebaseState.createFile(INTERACTIVE, "");
        }
        this.rebaseState.createFile(QUIET, "");
        ArrayList<RebaseTodoLine> arrayList = new ArrayList<RebaseTodoLine>();
        arrayList.add(new RebaseTodoLine("# Created by EGit: rebasing " + objectId.name() + " onto " + this.upstreamCommit.name()));
        List list = this.calculatePickList(revCommit);
        ObjectReader objectReader = this.walk.getObjectReader();
        for (RevCommit revCommit3 : list) {
            arrayList.add(new RebaseTodoLine(RebaseTodoLine$Action.PICK, objectReader.abbreviate(revCommit3), revCommit3.getShortMessage()));
        }
        this.repo.writeRebaseTodoFile(this.rebaseState.getPath(GIT_REBASE_TODO), arrayList, false);
        this.monitor.endTask();
        this.monitor.beginTask(MessageFormat.format(JGitText.get().rewinding, this.upstreamCommit.getShortMessage()), 0);
        boolean bl2 = false;
        try {
            bl2 = this.checkoutCommit(string, this.upstreamCommit);
        }
        finally {
            if (!bl2) {
                FileUtils.delete(this.rebaseState.getDir(), 1);
            }
        }
        this.monitor.endTask();
        return null;
    }

    private List calculatePickList(RevCommit revCommit) {
        RevCommit revCommit2;
        Iterator iterator;
        ArrayList<RevCommit> arrayList = new ArrayList<RevCommit>();
        Object object = new RevWalk(this.repo);
        Serializable serializable = null;
        try {
            ((RevWalk)object).sort(RevSort.TOPO_KEEP_BRANCH_TOGETHER, true);
            ((RevWalk)object).sort(RevSort.COMMIT_TIME_DESC, true);
            ((RevWalk)object).markUninteresting(((RevWalk)object).lookupCommit(this.upstreamCommit));
            ((RevWalk)object).markStart(((RevWalk)object).lookupCommit(revCommit));
            iterator = ((RevWalk)object).iterator();
            while (iterator.hasNext()) {
                revCommit2 = (RevCommit)iterator.next();
                if (!this.preserveMerges && revCommit2.getParentCount() != 1) continue;
                arrayList.add(revCommit2);
            }
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (serializable != null) {
                    try {
                        ((RevWalk)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)serializable).addSuppressed(throwable);
                    }
                } else {
                    ((RevWalk)object).close();
                }
            }
        }
        Collections.reverse(arrayList);
        if (this.preserveMerges) {
            object = this.rebaseState.getRewrittenDir();
            FileUtils.mkdir((File)object, false);
            this.walk.reset();
            this.walk.setRevFilter(RevFilter.MERGE_BASE);
            this.walk.markStart(this.upstreamCommit);
            this.walk.markStart(revCommit);
            while ((serializable = this.walk.next()) != null) {
                RebaseCommand$RebaseState.access$200((File)object, ((AnyObjectId)((Object)serializable)).getName(), this.upstreamCommit.getName());
            }
            iterator = arrayList.iterator();
            block11: while (iterator.hasNext()) {
                revCommit2 = (RevCommit)iterator.next();
                for (int i2 = 0; i2 < revCommit2.getParentCount(); ++i2) {
                    boolean bl2 = new File((File)object, revCommit2.getParent(i2).getName()).exists();
                    if (!bl2) continue;
                    new File((File)object, revCommit2.getName()).createNewFile();
                    continue block11;
                }
                iterator.remove();
            }
        }
        return arrayList;
    }

    private static String getHeadName(Ref ref) {
        String string;
        if (ref.isSymbolic()) {
            string = ref.getTarget().getName();
        } else {
            ObjectId objectId = ref.getObjectId();
            assert (objectId != null);
            string = objectId.getName();
        }
        return string;
    }

    private Ref getHead() {
        Ref ref = this.repo.exactRef("HEAD");
        if (ref == null || ref.getObjectId() == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        return ref;
    }

    private boolean isInteractive() {
        return this.interactiveHandler != null;
    }

    public RevCommit tryFastForward(RevCommit revCommit) {
        Ref ref = this.getHead();
        ObjectId objectId = ref.getObjectId();
        if (objectId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        RevCommit revCommit2 = this.walk.lookupCommit(objectId);
        if (this.walk.isMergedInto(revCommit, revCommit2)) {
            return revCommit;
        }
        String string = RebaseCommand.getHeadName(ref);
        return this.tryFastForward(string, revCommit2, revCommit);
    }

    private RevCommit tryFastForward(String string, RevCommit revCommit, RevCommit revCommit2) {
        boolean bl2 = false;
        for (RevCommit revCommit3 : revCommit2.getParents()) {
            if (!revCommit3.equals(revCommit)) continue;
            bl2 = true;
        }
        if (!bl2) {
            return null;
        }
        CheckoutCommand checkoutCommand = new CheckoutCommand(this.repo);
        try {
            checkoutCommand.setProgressMonitor(this.monitor);
            checkoutCommand.setName(revCommit2.name()).call();
            if (string.startsWith("refs/heads/")) {
                RefUpdate refUpdate = this.repo.updateRef(string);
                refUpdate.setExpectedOldObjectId(revCommit);
                refUpdate.setNewObjectId(revCommit2);
                refUpdate.setRefLogMessage("Fast-forward from " + revCommit.name() + " to " + revCommit2.name(), false);
                RefUpdate$Result refUpdate$Result = refUpdate.update(this.walk);
                switch (refUpdate$Result) {
                    case FAST_FORWARD: 
                    case FORCED: 
                    case NO_CHANGE: {
                        break;
                    }
                    default: {
                        throw new IOException("Could not fast-forward");
                    }
                }
            }
            return revCommit2;
        }
        catch (CheckoutConflictException | InvalidRefNameException | RefAlreadyExistsException | RefNotFoundException gitAPIException) {
            throw new JGitInternalException(gitAPIException.getMessage(), gitAPIException);
        }
    }

    private void checkParameters() {
        block9: {
            block8: {
                if (this.operation == RebaseCommand$Operation.PROCESS_STEPS && this.rebaseState.getFile(DONE).exists()) {
                    throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
                }
                if (this.operation == RebaseCommand$Operation.BEGIN) break block8;
                switch (this.repo.getRepositoryState()) {
                    case REBASING_INTERACTIVE: 
                    case REBASING: 
                    case REBASING_REBASING: 
                    case REBASING_MERGE: {
                        break block9;
                    }
                    default: {
                        throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
                    }
                }
            }
            switch (this.repo.getRepositoryState()) {
                case SAFE: {
                    if (this.upstreamCommit == null) {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().missingRequiredParameter, "upstream"));
                    }
                    return;
                }
            }
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebaseResult abort(RebaseResult rebaseResult) {
        Object object;
        Object object2;
        Object object3;
        String string;
        ObjectId objectId = this.getOriginalHead();
        try {
            string = objectId != null ? objectId.name() : null;
            this.monitor.beginTask(MessageFormat.format(JGitText.get().abortingRebase, string), 0);
            if (string == null) {
                throw new JGitInternalException(JGitText.get().abortingRebaseFailedNoOrigHead);
            }
            object3 = this.repo.resolve(string);
            RevCommit revCommit = this.walk.parseCommit((AnyObjectId)object3);
            if (rebaseResult.getStatus().equals((Object)RebaseResult$Status.FAILED)) {
                object2 = this.walk.parseCommit(this.repo.resolve("HEAD"));
                object = new DirCacheCheckout(this.repo, ((RevCommit)object2).getTree(), this.repo.lockDirCache(), revCommit.getTree());
            } else {
                object = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), revCommit.getTree());
            }
            ((DirCacheCheckout)object).setFailOnConflict(false);
            ((DirCacheCheckout)object).checkout();
            this.walk.close();
        }
        finally {
            this.monitor.endTask();
        }
        try {
            string = this.rebaseState.readFile(HEAD_NAME);
            this.monitor.beginTask(MessageFormat.format(JGitText.get().resettingHead, string), 0);
            object = null;
            object3 = this.repo.updateRef("HEAD", false);
            ((RefUpdate)object3).setRefLogMessage("rebase: aborting", false);
            if (string.startsWith("refs/")) {
                object = ((RefUpdate)object3).link(string);
            } else {
                ((RefUpdate)object3).setNewObjectId(objectId);
                object = ((RefUpdate)object3).forceUpdate();
            }
            switch (RebaseCommand$1.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[((Enum)object).ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new JGitInternalException(JGitText.get().abortingRebaseFailed);
                }
            }
            boolean bl2 = this.autoStashApply();
            FileUtils.delete(this.rebaseState.getDir(), 1);
            this.repo.writeCherryPickHead(null);
            this.repo.writeMergeHeads(null);
            if (bl2) {
                object2 = RebaseResult.STASH_APPLY_CONFLICTS_RESULT;
                return object2;
            }
            object2 = rebaseResult;
            return object2;
        }
        finally {
            this.monitor.endTask();
        }
    }

    private ObjectId getOriginalHead() {
        try {
            return ObjectId.fromString(this.rebaseState.readFile(REBASE_HEAD));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                return ObjectId.fromString(this.rebaseState.readFile(REBASE_HEAD_LEGACY));
            }
            catch (FileNotFoundException fileNotFoundException2) {
                return this.repo.readOrigHead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkoutCommit(String string, RevCommit revCommit) {
        try {
            RevCommit revCommit2 = this.walk.parseCommit(this.repo.resolve("HEAD"));
            DirCacheCheckout dirCacheCheckout = new DirCacheCheckout(this.repo, revCommit2.getTree(), this.repo.lockDirCache(), revCommit.getTree());
            dirCacheCheckout.setFailOnConflict(true);
            dirCacheCheckout.setProgressMonitor(this.monitor);
            try {
                dirCacheCheckout.checkout();
            }
            catch (org.eclipse.jgit.errors.CheckoutConflictException checkoutConflictException) {
                throw new CheckoutConflictException(dirCacheCheckout.getConflicts(), checkoutConflictException);
            }
            RefUpdate refUpdate = this.repo.updateRef("HEAD", true);
            refUpdate.setExpectedOldObjectId(revCommit2);
            refUpdate.setNewObjectId(revCommit);
            refUpdate.setRefLogMessage("checkout: moving from " + Repository.shortenRefName(string) + " to " + revCommit.getName(), false);
            RefUpdate$Result refUpdate$Result = refUpdate.forceUpdate();
            switch (refUpdate$Result) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    return true;
                }
                default: {
                    throw new IOException(JGitText.get().couldNotRewindToUpstreamCommit);
                }
            }
        }
        finally {
            this.walk.close();
            this.monitor.endTask();
        }
    }

    public RebaseCommand setUpstream(RevCommit revCommit) {
        this.upstreamCommit = revCommit;
        this.upstreamCommitName = revCommit.name();
        return this;
    }

    public RebaseCommand setUpstream(AnyObjectId anyObjectId) {
        try {
            this.upstreamCommit = this.walk.parseCommit(anyObjectId);
            this.upstreamCommitName = anyObjectId.name();
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().couldNotReadObjectWhileParsingCommit, anyObjectId.name()), iOException);
        }
        return this;
    }

    public RebaseCommand setUpstream(String string) {
        try {
            ObjectId objectId = this.repo.resolve(string);
            if (objectId == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, string));
            }
            this.upstreamCommit = this.walk.parseCommit(this.repo.resolve(string));
            this.upstreamCommitName = string;
            return this;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    public RebaseCommand setUpstreamFrom(ObjectId objectId) {
        this.upstreamFrom = objectId;
        return this;
    }

    public RebaseCommand setUpstreamName(String string) {
        if (this.upstreamCommit == null) {
            throw new IllegalStateException("setUpstreamName must be called after setUpstream.");
        }
        this.upstreamCommitName = string;
        return this;
    }

    public RebaseCommand setOperation(RebaseCommand$Operation rebaseCommand$Operation) {
        this.operation = rebaseCommand$Operation;
        return this;
    }

    public RebaseCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }

    public RebaseCommand runInteractively(RebaseCommand$InteractiveHandler rebaseCommand$InteractiveHandler) {
        return this.runInteractively(rebaseCommand$InteractiveHandler, false);
    }

    public RebaseCommand runInteractively(RebaseCommand$InteractiveHandler rebaseCommand$InteractiveHandler, boolean bl2) {
        this.stopAfterInitialization = bl2;
        this.interactiveHandler = rebaseCommand$InteractiveHandler;
        return this;
    }

    public RebaseCommand setStrategy(MergeStrategy mergeStrategy) {
        this.strategy = mergeStrategy;
        return this;
    }

    public RebaseCommand setContentMergeStrategy(ContentMergeStrategy contentMergeStrategy) {
        this.contentStrategy = contentMergeStrategy;
        return this;
    }

    public RebaseCommand setPreserveMerges(boolean bl2) {
        this.preserveMerges = bl2;
        return this;
    }

    public RebaseCommand setPreserveCommitter(boolean bl2) {
        this.preserveCommitter = bl2;
        return this;
    }

    PersonIdent parseAuthor(byte[] byArray) {
        int n2;
        int n3;
        if (byArray.length == 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n4 = 0;
        while (n4 < byArray.length && (n3 = RawParseUtils.nextLF(byArray, n4)) != n4 && (n2 = RawParseUtils.next(byArray, n4, '=')) != n3) {
            String string = RawParseUtils.decode(byArray, n4, n2 - 1);
            String string2 = RawParseUtils.decode(byArray, n2 + 1, n3 - 2);
            n4 = n3;
            hashMap.put(string, string2);
        }
        String string = (String)hashMap.get(GIT_AUTHOR_NAME);
        String string3 = (String)hashMap.get(GIT_AUTHOR_EMAIL);
        String string4 = (String)hashMap.get(GIT_AUTHOR_DATE);
        int n5 = 0;
        n5 = string4.startsWith("@") ? 1 : 0;
        long l2 = Long.parseLong(string4.substring(n5, string4.indexOf(32))) * 1000L;
        String string5 = string4.substring(string4.indexOf(32) + 1);
        int n6 = -1;
        if (string5.charAt(0) == '+') {
            n6 = 1;
        }
        int n7 = Integer.parseInt(string5.substring(1, 3));
        int n8 = Integer.parseInt(string5.substring(3, 5));
        int n9 = (n7 * 60 + n8) * n6;
        if (string != null && string3 != null) {
            return new PersonIdent(string, string3, l2, n9);
        }
        return null;
    }
}

