/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

class RebaseCommand$RebaseState {
    private final File repoDirectory;
    private File dir;

    public RebaseCommand$RebaseState(File file) {
        this.repoDirectory = file;
    }

    public File getDir() {
        if (this.dir == null) {
            File file;
            File file2 = new File(this.repoDirectory, "rebase-apply");
            this.dir = file2.exists() ? file2 : (file = new File(this.repoDirectory, "rebase-merge"));
        }
        return this.dir;
    }

    public File getRewrittenDir() {
        return new File(this.getDir(), "rewritten");
    }

    public String readFile(String string) {
        try {
            return RebaseCommand$RebaseState.readFile(this.getDir(), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file;
            if ("onto_name".equals(string) && (file = this.getFile("onto_name".replace('_', '-'))).exists()) {
                return RebaseCommand$RebaseState.readFile(file);
            }
            throw fileNotFoundException;
        }
    }

    public void createFile(String string, String string2) {
        RebaseCommand$RebaseState.createFile(this.getDir(), string, string2);
    }

    public File getFile(String string) {
        return new File(this.getDir(), string);
    }

    public String getPath(String string) {
        return this.getDir().getName() + "/" + string;
    }

    private static String readFile(File file) {
        byte[] byArray = IO.readFully(file);
        int n2 = RawParseUtils.prevLF(byArray, byArray.length);
        return RawParseUtils.decode(byArray, 0, n2 + 1);
    }

    private static String readFile(File file, String string) {
        return RebaseCommand$RebaseState.readFile(new File(file, string));
    }

    private static void createFile(File file, String string, String string2) {
        File file2 = new File(file, string);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            fileOutputStream.write(string2.getBytes(StandardCharsets.UTF_8));
            fileOutputStream.write(10);
        }
    }

    private static void appendToFile(File file, String string) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, true);){
            fileOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            fileOutputStream.write(10);
        }
    }

    static /* synthetic */ String access$000(File file, String string) {
        return RebaseCommand$RebaseState.readFile(file, string);
    }

    static /* synthetic */ void access$100(File file, String string) {
        RebaseCommand$RebaseState.appendToFile(file, string);
    }

    static /* synthetic */ void access$200(File file, String string, String string2) {
        RebaseCommand$RebaseState.createFile(file, string, string2);
    }
}

