/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TooLargeObjectInPackException;
import org.eclipse.jgit.api.errors.TooLargePackException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefLeaseSpec;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.Transport$Operation;

public class PushCommand
extends TransportCommand {
    private String remote = "origin";
    private final List refSpecs;
    private final Map refLeaseSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private String receivePack = "git-receive-pack";
    private boolean dryRun;
    private boolean atomic;
    private boolean force;
    private boolean thin = false;
    private OutputStream out;
    private List pushOptions;

    protected PushCommand(Repository repository) {
        super(repository);
        this.refSpecs = new ArrayList(3);
        this.refLeaseSpecs = new HashMap();
    }

    @Override
    public Iterable call() {
        this.checkCallable();
        ArrayList<PushResult> arrayList = new ArrayList<PushResult>(3);
        try {
            Object object;
            if (this.refSpecs.isEmpty()) {
                object = new RemoteConfig(this.repo.getConfig(), this.getRemote());
                this.refSpecs.addAll(((RemoteConfig)object).getPushRefSpecs());
            }
            if (this.refSpecs.isEmpty() && (object = this.repo.exactRef("HEAD")) != null && object.isSymbolic()) {
                this.refSpecs.add(new RefSpec(object.getLeaf().getName()));
            }
            if (this.force) {
                for (int i2 = 0; i2 < this.refSpecs.size(); ++i2) {
                    this.refSpecs.set(i2, ((RefSpec)this.refSpecs.get(i2)).setForceUpdate(true));
                }
            }
            List list = Transport.openAll(this.repo, this.remote, Transport$Operation.PUSH);
            for (Transport transport : list) {
                transport.setPushThin(this.thin);
                transport.setPushAtomic(this.atomic);
                if (this.receivePack != null) {
                    transport.setOptionReceivePack(this.receivePack);
                }
                transport.setDryRun(this.dryRun);
                transport.setPushOptions(this.pushOptions);
                this.configure(transport);
                Collection collection = transport.findRemoteRefUpdatesFor(this.refSpecs, this.refLeaseSpecs);
                try {
                    PushResult pushResult = transport.push(this.monitor, collection, this.out);
                    arrayList.add(pushResult);
                }
                catch (org.eclipse.jgit.errors.TooLargePackException tooLargePackException) {
                    throw new TooLargePackException(tooLargePackException.getMessage(), tooLargePackException);
                }
                catch (org.eclipse.jgit.errors.TooLargeObjectInPackException tooLargeObjectInPackException) {
                    throw new TooLargeObjectInPackException(tooLargeObjectInPackException.getMessage(), tooLargeObjectInPackException);
                }
                catch (org.eclipse.jgit.errors.TransportException transportException) {
                    throw new TransportException(transportException.getMessage(), transportException);
                }
                finally {
                    transport.close();
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), uRISyntaxException);
        }
        catch (org.eclipse.jgit.errors.TransportException transportException) {
            throw new TransportException(transportException.getMessage(), transportException);
        }
        catch (NotSupportedException notSupportedException) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, notSupportedException);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, iOException);
        }
        return arrayList;
    }

    public PushCommand setRemote(String string) {
        this.checkCallable();
        this.remote = string;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public PushCommand setReceivePack(String string) {
        this.checkCallable();
        this.receivePack = string;
        return this;
    }

    public String getReceivePack() {
        return this.receivePack;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public PushCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        this.checkCallable();
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }

    public List getRefLeaseSpecs() {
        return new ArrayList(this.refLeaseSpecs.values());
    }

    public PushCommand setRefLeaseSpecs(RefLeaseSpec ... refLeaseSpecArray) {
        return this.setRefLeaseSpecs(Arrays.asList(refLeaseSpecArray));
    }

    public PushCommand setRefLeaseSpecs(List list) {
        this.checkCallable();
        this.refLeaseSpecs.clear();
        for (RefLeaseSpec refLeaseSpec : list) {
            this.refLeaseSpecs.put(refLeaseSpec.getRef(), refLeaseSpec);
        }
        return this;
    }

    public List getRefSpecs() {
        return this.refSpecs;
    }

    public PushCommand setRefSpecs(RefSpec ... refSpecArray) {
        this.checkCallable();
        this.refSpecs.clear();
        Collections.addAll(this.refSpecs, refSpecArray);
        return this;
    }

    public PushCommand setRefSpecs(List list) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(list);
        return this;
    }

    public PushCommand setPushAll() {
        this.refSpecs.add(Transport.REFSPEC_PUSH_ALL);
        return this;
    }

    public PushCommand setPushTags() {
        this.refSpecs.add(Transport.REFSPEC_TAGS);
        return this;
    }

    public PushCommand add(Ref ref) {
        this.refSpecs.add(new RefSpec(ref.getLeaf().getName()));
        return this;
    }

    public PushCommand add(String string) {
        if (0 <= string.indexOf(58)) {
            this.refSpecs.add(new RefSpec(string));
        } else {
            Ref ref;
            try {
                ref = this.repo.findRef(string);
            }
            catch (IOException iOException) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, iOException);
            }
            if (ref != null) {
                this.add(ref);
            }
        }
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public PushCommand setDryRun(boolean bl2) {
        this.checkCallable();
        this.dryRun = bl2;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public PushCommand setThin(boolean bl2) {
        this.checkCallable();
        this.thin = bl2;
        return this;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public PushCommand setAtomic(boolean bl2) {
        this.checkCallable();
        this.atomic = bl2;
        return this;
    }

    public boolean isForce() {
        return this.force;
    }

    public PushCommand setForce(boolean bl2) {
        this.checkCallable();
        this.force = bl2;
        return this;
    }

    public PushCommand setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        return this;
    }

    public List getPushOptions() {
        return this.pushOptions;
    }

    public PushCommand setPushOptions(List list) {
        this.pushOptions = list;
        return this;
    }
}

