/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.transport.FetchResult;

public class PullResult {
    private final FetchResult fetchResult;
    private final MergeResult mergeResult;
    private final RebaseResult rebaseResult;
    private final String fetchedFrom;

    PullResult(FetchResult fetchResult, String string, MergeResult mergeResult) {
        this.fetchResult = fetchResult;
        this.fetchedFrom = string;
        this.mergeResult = mergeResult;
        this.rebaseResult = null;
    }

    PullResult(FetchResult fetchResult, String string, RebaseResult rebaseResult) {
        this.fetchResult = fetchResult;
        this.fetchedFrom = string;
        this.mergeResult = null;
        this.rebaseResult = rebaseResult;
    }

    public FetchResult getFetchResult() {
        return this.fetchResult;
    }

    public MergeResult getMergeResult() {
        return this.mergeResult;
    }

    public RebaseResult getRebaseResult() {
        return this.rebaseResult;
    }

    public String getFetchedFrom() {
        return this.fetchedFrom;
    }

    public boolean isSuccessful() {
        if (this.mergeResult != null) {
            return this.mergeResult.getMergeStatus().isSuccessful();
        }
        if (this.rebaseResult != null) {
            return this.rebaseResult.getStatus().isSuccessful();
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fetchResult != null) {
            stringBuilder.append(this.fetchResult.toString());
        } else {
            stringBuilder.append("No fetch result");
        }
        stringBuilder.append("\n");
        if (this.mergeResult != null) {
            stringBuilder.append(this.mergeResult.toString());
        } else if (this.rebaseResult != null) {
            stringBuilder.append(this.rebaseResult.toString());
        } else {
            stringBuilder.append("No update result");
        }
        return stringBuilder.toString();
    }
}

