/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeCommand$FastForwardMode;
import org.eclipse.jgit.api.MergeCommand$FastForwardMode$Merge;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseCommand$Operation;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.RebaseResult$Status;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefNotAdvertisedException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchConfig$BranchRebaseMode;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.SubmoduleConfig;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.TagOpt;

public class PullCommand
extends TransportCommand {
    private static final String DOT = ".";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private BranchConfig$BranchRebaseMode pullRebaseMode = null;
    private String remote;
    private String remoteBranchName;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;
    private TagOpt tagOption;
    private MergeCommand$FastForwardMode fastForwardMode;
    private SubmoduleConfig.FetchRecurseSubmodulesMode submoduleRecurseMode = null;

    protected PullCommand(Repository repository) {
        super(repository);
    }

    public PullCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }

    public PullCommand setRebase(boolean bl2) {
        this.checkCallable();
        this.pullRebaseMode = bl2 ? BranchConfig$BranchRebaseMode.REBASE : BranchConfig$BranchRebaseMode.NONE;
        return this;
    }

    public PullCommand setRebase(BranchConfig$BranchRebaseMode branchConfig$BranchRebaseMode) {
        this.checkCallable();
        this.pullRebaseMode = branchConfig$BranchRebaseMode;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PullResult call() {
        PullResult pullResult;
        Object object;
        OperationResult operationResult;
        Object object2;
        String string;
        boolean bl2;
        this.checkCallable();
        this.monitor.beginTask(JGitText.get().pullTaskName, 2);
        StoredConfig storedConfig = this.repo.getConfig();
        String string2 = null;
        try {
            String string3 = this.repo.getFullBranch();
            if (string3 != null && string3.startsWith("refs/heads/")) {
                string2 = string3.substring("refs/heads/".length());
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, iOException);
        }
        if (this.remoteBranchName == null && string2 != null) {
            this.remoteBranchName = storedConfig.getString("branch", string2, "merge");
        }
        if (this.remoteBranchName == null) {
            this.remoteBranchName = string2;
        }
        if (this.remoteBranchName == null) {
            throw new NoHeadException(JGitText.get().cannotCheckoutFromUnbornBranch);
        }
        if (!this.repo.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotPullOnARepoWithState, this.repo.getRepositoryState().name()));
        }
        if (this.remote == null && string2 != null) {
            this.remote = storedConfig.getString("branch", string2, "remote");
        }
        if (this.remote == null) {
            this.remote = "origin";
        }
        if (this.pullRebaseMode == null && string2 != null) {
            this.pullRebaseMode = PullCommand.getRebaseMode(string2, storedConfig);
        }
        boolean bl3 = bl2 = !this.remote.equals(DOT);
        if (bl2) {
            string = storedConfig.getString("remote", this.remote, "url");
            if (string == null) {
                String string4 = "remote." + this.remote + DOT + "url";
                throw new InvalidConfigurationException(MessageFormat.format(JGitText.get().missingConfigurationForKey, string4));
            }
            if (this.monitor.isCancelled()) {
                throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().pullTaskName));
            }
            object2 = new FetchCommand(this.repo).setRemote(this.remote).setProgressMonitor(this.monitor).setTagOpt(this.tagOption).setRecurseSubmodules(this.submoduleRecurseMode);
            this.configure((TransportCommand)object2);
            operationResult = ((FetchCommand)object2).call();
        } else {
            string = JGitText.get().localRepository;
            operationResult = null;
        }
        this.monitor.update(1);
        if (this.monitor.isCancelled()) {
            throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().pullTaskName));
        }
        if (bl2) {
            object = null;
            if (operationResult != null && (object = operationResult.getAdvertisedRef(this.remoteBranchName)) == null) {
                object = operationResult.getAdvertisedRef("refs/heads/" + this.remoteBranchName);
            }
            if (object == null) {
                throw new RefNotAdvertisedException(MessageFormat.format(JGitText.get().couldNotGetAdvertisedRef, this.remote, this.remoteBranchName));
            }
            object2 = object.getObjectId();
        } else {
            try {
                object2 = this.repo.resolve(this.remoteBranchName);
                if (object2 == null) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.remoteBranchName));
                }
            }
            catch (IOException iOException) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, iOException);
            }
        }
        object = MessageFormat.format(JGitText.get().upstreamBranchName, Repository.shortenRefName(this.remoteBranchName), string);
        if (this.pullRebaseMode != BranchConfig$BranchRebaseMode.NONE) {
            Object object3;
            Object object4;
            try {
                object4 = this.repo.exactRef("HEAD");
                if (object4 == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                object3 = object4.getObjectId();
                if (object3 == null) {
                    try (RevWalk revWalk = new RevWalk(this.repo);){
                        RevCommit revCommit = revWalk.parseCommit((AnyObjectId)object2);
                        DirCacheCheckout dirCacheCheckout = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), revCommit.getTree());
                        dirCacheCheckout.setFailOnConflict(true);
                        dirCacheCheckout.setProgressMonitor(this.monitor);
                        dirCacheCheckout.checkout();
                        RefUpdate refUpdate = this.repo.updateRef(object4.getTarget().getName());
                        refUpdate.setNewObjectId((AnyObjectId)object2);
                        refUpdate.setExpectedOldObjectId(null);
                        refUpdate.setRefLogMessage("initial pull", false);
                        if (refUpdate.update() != RefUpdate$Result.NEW) {
                            throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                        }
                        this.monitor.endTask();
                        PullResult pullResult2 = new PullResult((FetchResult)operationResult, this.remote, RebaseResult.result(RebaseResult$Status.FAST_FORWARD, revCommit));
                        return pullResult2;
                    }
                }
            }
            catch (NoHeadException noHeadException) {
                throw noHeadException;
            }
            catch (IOException iOException) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, iOException);
            }
            object4 = new RebaseCommand(this.repo);
            object3 = ((RebaseCommand)object4).setUpstream((AnyObjectId)object2).setProgressMonitor(this.monitor).setUpstreamName((String)object).setOperation(RebaseCommand$Operation.BEGIN).setStrategy(this.strategy).setContentMergeStrategy(this.contentStrategy).setPreserveMerges(this.pullRebaseMode == BranchConfig$BranchRebaseMode.PRESERVE).call();
            pullResult = new PullResult((FetchResult)operationResult, this.remote, (RebaseResult)object3);
        } else {
            MergeCommand mergeCommand = new MergeCommand(this.repo);
            MergeResult mergeResult = mergeCommand.include((String)object, (AnyObjectId)object2).setProgressMonitor(this.monitor).setStrategy(this.strategy).setContentMergeStrategy(this.contentStrategy).setFastForward(this.getFastForwardMode()).call();
            this.monitor.update(1);
            pullResult = new PullResult((FetchResult)operationResult, this.remote, mergeResult);
        }
        this.monitor.endTask();
        return pullResult;
    }

    public PullCommand setRemote(String string) {
        this.checkCallable();
        this.remote = string;
        return this;
    }

    public PullCommand setRemoteBranchName(String string) {
        this.checkCallable();
        this.remoteBranchName = string;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getRemoteBranchName() {
        return this.remoteBranchName;
    }

    public PullCommand setStrategy(MergeStrategy mergeStrategy) {
        this.strategy = mergeStrategy;
        return this;
    }

    public PullCommand setContentMergeStrategy(ContentMergeStrategy contentMergeStrategy) {
        this.contentStrategy = contentMergeStrategy;
        return this;
    }

    public PullCommand setTagOpt(TagOpt tagOpt) {
        this.checkCallable();
        this.tagOption = tagOpt;
        return this;
    }

    public PullCommand setFastForward(@Nullable MergeCommand$FastForwardMode mergeCommand$FastForwardMode) {
        this.checkCallable();
        this.fastForwardMode = mergeCommand$FastForwardMode;
        return this;
    }

    public PullCommand setRecurseSubmodules(@Nullable SubmoduleConfig.FetchRecurseSubmodulesMode fetchRecurseSubmodulesMode) {
        this.submoduleRecurseMode = fetchRecurseSubmodulesMode;
        return this;
    }

    public static BranchConfig$BranchRebaseMode getRebaseMode(String string, Config config) {
        BranchConfig$BranchRebaseMode branchConfig$BranchRebaseMode = (BranchConfig$BranchRebaseMode)config.getEnum(BranchConfig$BranchRebaseMode.values(), "branch", string, "rebase", null);
        if (branchConfig$BranchRebaseMode == null) {
            branchConfig$BranchRebaseMode = (BranchConfig$BranchRebaseMode)config.getEnum(BranchConfig$BranchRebaseMode.values(), "pull", null, "rebase", BranchConfig$BranchRebaseMode.NONE);
        }
        return branchConfig$BranchRebaseMode;
    }

    private MergeCommand$FastForwardMode getFastForwardMode() {
        if (this.fastForwardMode != null) {
            return this.fastForwardMode;
        }
        StoredConfig storedConfig = this.repo.getConfig();
        MergeCommand$FastForwardMode$Merge mergeCommand$FastForwardMode$Merge = (MergeCommand$FastForwardMode$Merge)storedConfig.getEnum(MergeCommand$FastForwardMode$Merge.values(), "pull", null, "ff", null);
        return mergeCommand$FastForwardMode$Merge != null ? MergeCommand$FastForwardMode.valueOf(mergeCommand$FastForwardMode$Merge) : null;
    }
}

