/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.NameRevCommand$1;
import org.eclipse.jgit.api.NameRevCommand$NameRevCommit;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

public class NameRevCommand
extends GitCommand {
    private static final int COMMIT_TIME_SLOP = 86400;
    private static final int MERGE_COST = 65535;
    private final RevWalk walk;
    private final List prefixes = new ArrayList(2);
    private final List revs = new ArrayList(2);
    private List refs;
    private int mergeCost = 65535;

    protected NameRevCommand(Repository repository) {
        super(repository);
        this.walk = new NameRevCommand$1(this, repository);
    }

    @Override
    public Map call() {
        try {
            LinkedHashMap<NameRevCommand$NameRevCommit, String> linkedHashMap2;
            HashMap hashMap = new HashMap();
            FIFORevQueue fIFORevQueue = new FIFORevQueue();
            if (this.refs != null) {
                for (LinkedHashMap<NameRevCommand$NameRevCommit, String> linkedHashMap2 : this.refs) {
                    this.addRef((Ref)((Object)linkedHashMap2), hashMap, fIFORevQueue);
                }
            }
            this.addPrefixes(hashMap, fIFORevQueue);
            int n2 = this.minCommitTime() - 86400;
            while ((linkedHashMap2 = (NameRevCommand$NameRevCommit)fIFORevQueue.next()) != null) {
                if (((RevCommit)((Object)linkedHashMap2)).getCommitTime() < n2) continue;
                for (int i2 = 0; i2 < ((RevCommit)((Object)linkedHashMap2)).getParentCount(); ++i2) {
                    ObjectId objectId = (NameRevCommand$NameRevCommit)this.walk.parseCommit(((RevCommit)((Object)linkedHashMap2)).getParent(i2));
                    long l2 = NameRevCommand$NameRevCommit.access$100(linkedHashMap2) + (long)(i2 > 0 ? this.mergeCost : 1);
                    if (NameRevCommand$NameRevCommit.access$200(objectId) != null && this.compare(NameRevCommand$NameRevCommit.access$200(linkedHashMap2), l2, NameRevCommand$NameRevCommit.access$200(objectId), NameRevCommand$NameRevCommit.access$100(objectId)) >= 0L) continue;
                    if (i2 > 0) {
                        NameRevCommand$NameRevCommit.access$202(objectId, NameRevCommand$NameRevCommit.access$300(linkedHashMap2).append('^').append(i2 + 1).toString());
                        NameRevCommand$NameRevCommit.access$402(objectId, 0);
                    } else {
                        NameRevCommand$NameRevCommit.access$202(objectId, NameRevCommand$NameRevCommit.access$200(linkedHashMap2));
                        NameRevCommand$NameRevCommit.access$402(objectId, NameRevCommand$NameRevCommit.access$400(linkedHashMap2) + 1);
                    }
                    NameRevCommand$NameRevCommit.access$102(objectId, l2);
                    fIFORevQueue.add((RevCommit)objectId);
                }
            }
            linkedHashMap2 = new LinkedHashMap<NameRevCommand$NameRevCommit, String>(this.revs.size());
            for (ObjectId objectId : this.revs) {
                Object object;
                RevObject revObject = this.walk.parseAny(objectId);
                if (revObject instanceof NameRevCommand$NameRevCommit) {
                    object = (NameRevCommand$NameRevCommit)revObject;
                    if (NameRevCommand$NameRevCommit.access$200((NameRevCommand$NameRevCommit)object) == null) continue;
                    linkedHashMap2.put((NameRevCommand$NameRevCommit)objectId, NameRevCommand.simplify(NameRevCommand$NameRevCommit.access$300((NameRevCommand$NameRevCommit)object).toString()));
                    continue;
                }
                object = (String)hashMap.get(objectId);
                if (object == null) continue;
                linkedHashMap2.put((NameRevCommand$NameRevCommit)objectId, NameRevCommand.simplify((String)object));
            }
            this.setCallable(false);
            LinkedHashMap<NameRevCommand$NameRevCommit, String> linkedHashMap3 = linkedHashMap2;
            return linkedHashMap3;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        finally {
            this.walk.close();
        }
    }

    public NameRevCommand add(ObjectId objectId) {
        this.checkCallable();
        try {
            this.walk.parseAny(objectId);
        }
        catch (MissingObjectException missingObjectException) {
            throw missingObjectException;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        this.revs.add(objectId.copy());
        return this;
    }

    public NameRevCommand add(Iterable iterable) {
        for (ObjectId objectId : iterable) {
            this.add(objectId);
        }
        return this;
    }

    public NameRevCommand addPrefix(String string) {
        this.checkCallable();
        this.prefixes.add(string);
        return this;
    }

    public NameRevCommand addAnnotatedTags() {
        this.checkCallable();
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        try {
            for (Ref ref : this.repo.getRefDatabase().getRefsByPrefix("refs/tags/")) {
                ObjectId objectId = ref.getObjectId();
                if (objectId == null || !(this.walk.parseAny(objectId) instanceof RevTag)) continue;
                this.addRef(ref);
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        return this;
    }

    public NameRevCommand addRef(Ref ref) {
        this.checkCallable();
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        this.refs.add(ref);
        return this;
    }

    NameRevCommand setMergeCost(int n2) {
        this.mergeCost = n2;
        return this;
    }

    private void addPrefixes(Map map, FIFORevQueue fIFORevQueue) {
        if (!this.prefixes.isEmpty()) {
            for (String string : this.prefixes) {
                this.addPrefix(string, map, fIFORevQueue);
            }
        } else if (this.refs == null) {
            this.addPrefix("refs/", map, fIFORevQueue);
        }
    }

    private void addPrefix(String string, Map map, FIFORevQueue fIFORevQueue) {
        for (Ref ref : this.repo.getRefDatabase().getRefsByPrefix(string)) {
            this.addRef(ref, map, fIFORevQueue);
        }
    }

    private void addRef(Ref ref, Map map, FIFORevQueue fIFORevQueue) {
        RevObject revObject;
        if (ref.getObjectId() == null) {
            return;
        }
        RevObject revObject2 = this.walk.parseAny(ref.getObjectId());
        while (revObject2 instanceof RevTag) {
            revObject = (RevTag)revObject2;
            map.put(revObject2, ref.getName());
            revObject2 = ((RevTag)revObject).getObject();
            this.walk.parseHeaders(revObject2);
        }
        if (revObject2 instanceof NameRevCommand$NameRevCommit) {
            revObject = (NameRevCommand$NameRevCommit)revObject2;
            if (NameRevCommand$NameRevCommit.access$200((NameRevCommand$NameRevCommit)revObject) == null) {
                NameRevCommand$NameRevCommit.access$202((NameRevCommand$NameRevCommit)revObject, ref.getName());
            }
            fIFORevQueue.add((RevCommit)revObject);
        } else if (!map.containsKey(revObject2)) {
            map.put(revObject2, ref.getName());
        }
    }

    private int minCommitTime() {
        int n2 = Integer.MAX_VALUE;
        for (ObjectId objectId : this.revs) {
            RevCommit revCommit;
            RevObject revObject = this.walk.parseAny(objectId);
            while (revObject instanceof RevTag) {
                revObject = ((RevTag)revObject).getObject();
                this.walk.parseHeaders(revObject);
            }
            if (!(revObject instanceof RevCommit) || (revCommit = (RevCommit)revObject).getCommitTime() >= n2) continue;
            n2 = revCommit.getCommitTime();
        }
        return n2;
    }

    private long compare(String string, long l2, String string2, long l3) {
        long l4 = l2 - l3;
        if (l4 != 0L || this.prefixes.isEmpty()) {
            return l4;
        }
        int n2 = -1;
        int n3 = -1;
        for (int i2 = 0; i2 < this.prefixes.size(); ++i2) {
            String string3 = (String)this.prefixes.get(i2);
            if (n2 < 0 && string.startsWith(string3)) {
                n2 = i2;
            }
            if (n3 >= 0 || !string2.startsWith(string3)) continue;
            n3 = i2;
        }
        return n2 - n3;
    }

    private static String simplify(String string) {
        if (string.startsWith("refs/heads/")) {
            return string.substring("refs/heads/".length());
        }
        if (string.startsWith("refs/tags/")) {
            return string.substring("refs/tags/".length());
        }
        if (string.startsWith("refs/")) {
            return string.substring("refs/".length());
        }
        return string;
    }
}

