/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.MergeResult$MergeStatus;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeChunk$ConflictState;
import org.eclipse.jgit.merge.MergeStrategy;

public class MergeResult {
    private ObjectId[] mergedCommits;
    private ObjectId base;
    private ObjectId newHead;
    private Map conflicts;
    private MergeResult$MergeStatus mergeStatus;
    private String description;
    private MergeStrategy mergeStrategy;
    private Map failingPaths;
    private List checkoutConflicts;

    public MergeResult(ObjectId objectId, ObjectId objectId2, ObjectId[] objectIdArray, MergeResult$MergeStatus mergeResult$MergeStatus, MergeStrategy mergeStrategy, Map map) {
        this(objectId, objectId2, objectIdArray, mergeResult$MergeStatus, mergeStrategy, map, null);
    }

    public MergeResult(ObjectId objectId, ObjectId objectId2, ObjectId[] objectIdArray, MergeResult$MergeStatus mergeResult$MergeStatus, MergeStrategy mergeStrategy, Map map, String string) {
        this(objectId, objectId2, objectIdArray, mergeResult$MergeStatus, mergeStrategy, map, null, string);
    }

    public MergeResult(ObjectId objectId, ObjectId objectId2, ObjectId[] objectIdArray, MergeResult$MergeStatus mergeResult$MergeStatus, MergeStrategy mergeStrategy, Map map, Map map2, String string) {
        this.newHead = objectId;
        this.mergedCommits = objectIdArray;
        this.base = objectId2;
        this.mergeStatus = mergeResult$MergeStatus;
        this.mergeStrategy = mergeStrategy;
        this.description = string;
        this.failingPaths = map2;
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.addConflict((String)entry.getKey(), (org.eclipse.jgit.merge.MergeResult)entry.getValue());
            }
        }
    }

    public MergeResult(List list) {
        this.checkoutConflicts = list;
        this.mergeStatus = MergeResult$MergeStatus.CHECKOUT_CONFLICT;
    }

    public ObjectId getNewHead() {
        return this.newHead;
    }

    public MergeResult$MergeStatus getMergeStatus() {
        return this.mergeStatus;
    }

    public ObjectId[] getMergedCommits() {
        return this.mergedCommits;
    }

    public ObjectId getBase() {
        return this.base;
    }

    public String toString() {
        boolean bl2 = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (ObjectId objectId : this.mergedCommits) {
            if (!bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = false;
            }
            stringBuilder.append(ObjectId.toString(objectId));
        }
        return MessageFormat.format(JGitText.get().mergeUsingStrategyResultedInDescription, new Object[]{stringBuilder, ObjectId.toString(this.base), this.mergeStrategy.getName(), this.mergeStatus, this.description == null ? "" : ", " + this.description});
    }

    public void setConflicts(Map map) {
        this.conflicts = map;
    }

    public void addConflict(String string, int[][] nArray) {
        if (this.conflicts == null) {
            this.conflicts = new HashMap();
        }
        this.conflicts.put(string, nArray);
    }

    public void addConflict(String string, org.eclipse.jgit.merge.MergeResult mergeResult) {
        Object object2;
        if (!mergeResult.containsConflicts()) {
            return;
        }
        if (this.conflicts == null) {
            this.conflicts = new HashMap();
        }
        int n2 = 0;
        for (Object object2 : mergeResult) {
            if (!((MergeChunk)object2).getConflictState().equals((Object)MergeChunk$ConflictState.FIRST_CONFLICTING_RANGE)) continue;
            ++n2;
        }
        int n3 = -1;
        object2 = new int[n2][this.mergedCommits.length + 1];
        for (MergeChunk mergeChunk : mergeResult) {
            int n4 = 0;
            if (mergeChunk.getConflictState().equals((Object)MergeChunk$ConflictState.FIRST_CONFLICTING_RANGE)) {
                if (n3 > -1) {
                    object2[n3][this.mergedCommits.length] = n4;
                }
                n4 = mergeChunk.getEnd();
                object2[++n3][mergeChunk.getSequenceIndex()] = mergeChunk.getBegin();
            }
            if (!mergeChunk.getConflictState().equals((Object)MergeChunk$ConflictState.NEXT_CONFLICTING_RANGE)) continue;
            if (mergeChunk.getEnd() > n4) {
                n4 = mergeChunk.getEnd();
            }
            object2[n3][mergeChunk.getSequenceIndex()] = mergeChunk.getBegin();
        }
        this.conflicts.put(string, object2);
    }

    public Map getConflicts() {
        return this.conflicts;
    }

    public Map getFailingPaths() {
        return this.failingPaths;
    }

    public List getCheckoutConflicts() {
        return this.checkoutConflicts;
    }
}

