/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.MergeCommand$FastForwardMode;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.MergeResult$MergeStatus;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeConfig;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.SquashMessageFormatter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.treewalk.FileTreeIterator;

public class MergeCommand
extends GitCommand {
    private MergeStrategy mergeStrategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;
    private List commits = new LinkedList();
    private Boolean squash;
    private MergeCommand$FastForwardMode fastForwardMode;
    private String message;
    private boolean insertChangeId;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private Boolean commit;

    protected MergeCommand(Repository repository) {
        super(repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MergeResult call() {
        this.checkCallable();
        this.fallBackToConfiguration();
        this.checkParameters();
        DirCacheCheckout dirCacheCheckout = null;
        try (RevWalk revWalk = new RevWalk(this.repo);){
            boolean bl2;
            Object object;
            Object object2;
            Ref ref = this.repo.exactRef("HEAD");
            if (ref == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            StringBuilder stringBuilder = new StringBuilder("merge ");
            Ref ref2 = (Ref)this.commits.get(0);
            stringBuilder.append(ref2.getName());
            ref2 = this.repo.getRefDatabase().peel(ref2);
            ObjectId objectId = ref2.getPeeledObjectId();
            if (objectId == null) {
                objectId = ref2.getObjectId();
            }
            RevCommit revCommit = revWalk.lookupCommit(objectId);
            ObjectId objectId2 = ref.getObjectId();
            if (objectId2 == null) {
                revWalk.parseHeaders(revCommit);
                dirCacheCheckout = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), revCommit.getTree());
                dirCacheCheckout.setFailOnConflict(true);
                dirCacheCheckout.setProgressMonitor(this.monitor);
                dirCacheCheckout.checkout();
                RefUpdate refUpdate = this.repo.updateRef(ref.getTarget().getName());
                refUpdate.setNewObjectId(objectId);
                refUpdate.setExpectedOldObjectId(null);
                refUpdate.setRefLogMessage("initial pull", false);
                if (refUpdate.update() != RefUpdate$Result.NEW) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                this.setCallable(false);
                MergeResult mergeResult = new MergeResult(revCommit, revCommit, new ObjectId[]{null, revCommit}, MergeResult$MergeStatus.FAST_FORWARD, this.mergeStrategy, null, null);
                return mergeResult;
            }
            RevCommit revCommit2 = revWalk.lookupCommit(objectId2);
            if (revWalk.isMergedInto(revCommit, revCommit2)) {
                this.setCallable(false);
                MergeResult mergeResult = new MergeResult(revCommit2, revCommit, new ObjectId[]{revCommit2, revCommit}, MergeResult$MergeStatus.ALREADY_UP_TO_DATE, this.mergeStrategy, null, null);
                return mergeResult;
            }
            if (revWalk.isMergedInto(revCommit2, revCommit) && this.fastForwardMode != MergeCommand$FastForwardMode.NO_FF) {
                Object object3;
                ObjectId objectId3;
                stringBuilder.append(": " + (Object)((Object)MergeResult$MergeStatus.FAST_FORWARD));
                dirCacheCheckout = new DirCacheCheckout(this.repo, revCommit2.getTree(), this.repo.lockDirCache(), revCommit.getTree());
                dirCacheCheckout.setProgressMonitor(this.monitor);
                dirCacheCheckout.setFailOnConflict(true);
                dirCacheCheckout.checkout();
                String string = null;
                ObjectId objectId4 = null;
                MergeResult$MergeStatus mergeResult$MergeStatus = null;
                if (!this.squash.booleanValue()) {
                    this.updateHead(stringBuilder, revCommit, objectId2);
                    objectId3 = objectId4 = revCommit;
                    mergeResult$MergeStatus = MergeResult$MergeStatus.FAST_FORWARD;
                } else {
                    string = JGitText.get().squashCommitNotUpdatingHEAD;
                    objectId3 = objectId4 = objectId2;
                    mergeResult$MergeStatus = MergeResult$MergeStatus.FAST_FORWARD_SQUASHED;
                    object3 = RevWalkUtils.find(revWalk, revCommit, revCommit2);
                    String string2 = new SquashMessageFormatter().format((List)object3, ref);
                    this.repo.writeSquashCommitMsg(string2);
                }
                this.setCallable(false);
                object3 = new MergeResult(objectId3, objectId4, new ObjectId[]{revCommit2, revCommit}, mergeResult$MergeStatus, this.mergeStrategy, null, string);
                return object3;
            }
            if (this.fastForwardMode == MergeCommand$FastForwardMode.FF_ONLY) {
                MergeResult mergeResult = new MergeResult(revCommit2, revCommit, new ObjectId[]{revCommit2, revCommit}, MergeResult$MergeStatus.ABORTED, this.mergeStrategy, null, null);
                return mergeResult;
            }
            String string = "";
            if (!this.squash.booleanValue()) {
                string = this.message != null ? this.message : new MergeMessageFormatter().format(this.commits, ref);
                this.repo.writeMergeCommitMsg(string);
                this.repo.writeMergeHeads(Arrays.asList(ref2.getObjectId()));
            } else {
                object2 = RevWalkUtils.find(revWalk, revCommit, revCommit2);
                String string3 = new SquashMessageFormatter().format((List)object2, ref);
                this.repo.writeSquashCommitMsg(string3);
            }
            object2 = this.mergeStrategy.newMerger(this.repo);
            ((Merger)object2).setProgressMonitor(this.monitor);
            Map map = null;
            Map map2 = null;
            List list = null;
            if (object2 instanceof ResolveMerger) {
                object = (ResolveMerger)object2;
                ((ResolveMerger)object).setContentMergeStrategy(this.contentStrategy);
                ((ResolveMerger)object).setCommitNames(new String[]{"BASE", "HEAD", ref2.getName()});
                ((ResolveMerger)object).setWorkingTreeIterator(new FileTreeIterator(this.repo));
                bl2 = ((Merger)object2).merge(revCommit2, revCommit);
                map = ((ResolveMerger)object).getMergeResults();
                map2 = ((ResolveMerger)object).getFailingPaths();
                list = ((ResolveMerger)object).getUnmergedPaths();
                if (!((ResolveMerger)object).getModifiedFiles().isEmpty()) {
                    this.repo.fireEvent(new WorkingTreeModifiedEvent(((ResolveMerger)object).getModifiedFiles(), null));
                }
            } else {
                bl2 = ((Merger)object2).merge(revCommit2, revCommit);
            }
            stringBuilder.append(": Merge made by ");
            if (!revWalk.isMergedInto(revCommit2, revCommit)) {
                stringBuilder.append(this.mergeStrategy.getName());
            } else {
                stringBuilder.append("recursive");
            }
            stringBuilder.append('.');
            if (bl2) {
                Object object4;
                dirCacheCheckout = new DirCacheCheckout(this.repo, revCommit2.getTree(), this.repo.lockDirCache(), ((Merger)object2).getResultTreeId());
                dirCacheCheckout.setFailOnConflict(true);
                dirCacheCheckout.setProgressMonitor(this.monitor);
                dirCacheCheckout.checkout();
                object = null;
                ObjectId objectId5 = null;
                MergeResult$MergeStatus mergeResult$MergeStatus = null;
                if (!this.commit.booleanValue() && this.squash.booleanValue()) {
                    mergeResult$MergeStatus = MergeResult$MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                }
                if (!this.commit.booleanValue() && !this.squash.booleanValue()) {
                    mergeResult$MergeStatus = MergeResult$MergeStatus.MERGED_NOT_COMMITTED;
                }
                if (this.commit.booleanValue() && !this.squash.booleanValue()) {
                    object4 = new Git(this.getRepository());
                    Throwable throwable = null;
                    try {
                        objectId5 = ((Git)object4).commit().setReflogComment(stringBuilder.toString()).setInsertChangeId(this.insertChangeId).call().getId();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object4 != null) {
                            if (throwable != null) {
                                try {
                                    ((Git)object4).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((Git)object4).close();
                            }
                        }
                    }
                    mergeResult$MergeStatus = MergeResult$MergeStatus.MERGED;
                    this.getRepository().autoGC(this.monitor);
                }
                if (this.commit.booleanValue() && this.squash.booleanValue()) {
                    object = JGitText.get().squashCommitNotUpdatingHEAD;
                    objectId5 = revCommit2.getId();
                    mergeResult$MergeStatus = MergeResult$MergeStatus.MERGED_SQUASHED;
                }
                object4 = new MergeResult(objectId5, null, new ObjectId[]{revCommit2.getId(), revCommit.getId()}, mergeResult$MergeStatus, this.mergeStrategy, null, (String)object);
                return object4;
            }
            if (map2 != null) {
                this.repo.writeMergeCommitMsg(null);
                this.repo.writeMergeHeads(null);
                object = new MergeResult(null, ((Merger)object2).getBaseCommitId(), new ObjectId[]{revCommit2.getId(), revCommit.getId()}, MergeResult$MergeStatus.FAILED, this.mergeStrategy, map, map2, null);
                return object;
            }
            object = new MergeMessageFormatter().formatWithConflicts(string, list);
            this.repo.writeMergeCommitMsg((String)object);
            MergeResult mergeResult = new MergeResult(null, ((Merger)object2).getBaseCommitId(), new ObjectId[]{revCommit2.getId(), revCommit.getId()}, MergeResult$MergeStatus.CONFLICTING, this.mergeStrategy, map, null);
            return mergeResult;
        }
        catch (org.eclipse.jgit.errors.CheckoutConflictException checkoutConflictException) {
            List list = dirCacheCheckout == null ? Collections.emptyList() : dirCacheCheckout.getConflicts();
            throw new CheckoutConflictException(list, checkoutConflictException);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfMergeCommand, iOException), iOException);
        }
    }

    private void checkParameters() {
        if (this.squash.booleanValue() && this.fastForwardMode == MergeCommand$FastForwardMode.NO_FF) {
            throw new JGitInternalException(JGitText.get().cannotCombineSquashWithNoff);
        }
        if (this.commits.size() != 1) {
            throw new InvalidMergeHeadsException(this.commits.isEmpty() ? JGitText.get().noMergeHeadSpecified : MessageFormat.format(JGitText.get().mergeStrategyDoesNotSupportHeads, this.mergeStrategy.getName(), this.commits.size()));
        }
    }

    private void fallBackToConfiguration() {
        MergeConfig mergeConfig = MergeConfig.getConfigForCurrentBranch(this.repo);
        if (this.squash == null) {
            this.squash = mergeConfig.isSquash();
        }
        if (this.commit == null) {
            this.commit = mergeConfig.isCommit();
        }
        if (this.fastForwardMode == null) {
            this.fastForwardMode = mergeConfig.getFastForwardMode();
        }
    }

    private void updateHead(StringBuilder stringBuilder, ObjectId objectId, ObjectId objectId2) {
        RefUpdate refUpdate = this.repo.updateRef("HEAD");
        refUpdate.setNewObjectId(objectId);
        refUpdate.setRefLogMessage(stringBuilder.toString(), false);
        refUpdate.setExpectedOldObjectId(objectId2);
        RefUpdate$Result refUpdate$Result = refUpdate.update();
        switch (refUpdate$Result) {
            case NEW: 
            case FAST_FORWARD: {
                return;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), refUpdate$Result);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", objectId.toString(), refUpdate$Result}));
    }

    public MergeCommand setStrategy(MergeStrategy mergeStrategy) {
        this.checkCallable();
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    public MergeCommand setContentMergeStrategy(ContentMergeStrategy contentMergeStrategy) {
        this.checkCallable();
        this.contentStrategy = contentMergeStrategy;
        return this;
    }

    public MergeCommand include(Ref ref) {
        this.checkCallable();
        this.commits.add(ref);
        return this;
    }

    public MergeCommand include(AnyObjectId anyObjectId) {
        return this.include(anyObjectId.getName(), anyObjectId);
    }

    public MergeCommand include(String string, AnyObjectId anyObjectId) {
        return this.include(new ObjectIdRef$Unpeeled(Ref$Storage.LOOSE, string, anyObjectId.copy()));
    }

    public MergeCommand setSquash(boolean bl2) {
        this.checkCallable();
        this.squash = bl2;
        return this;
    }

    public MergeCommand setFastForward(@Nullable MergeCommand$FastForwardMode mergeCommand$FastForwardMode) {
        this.checkCallable();
        this.fastForwardMode = mergeCommand$FastForwardMode;
        return this;
    }

    public MergeCommand setCommit(boolean bl2) {
        this.commit = bl2;
        return this;
    }

    public MergeCommand setMessage(String string) {
        this.message = string;
        return this;
    }

    public MergeCommand setInsertChangeId(boolean bl2) {
        this.checkCallable();
        this.insertChangeId = bl2;
        return this;
    }

    public MergeCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }
}

