/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.revwalk.filter.SkipRevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class LogCommand
extends GitCommand {
    private RevWalk walk;
    private boolean startSpecified = false;
    private RevFilter revFilter;
    private final List pathFilters = new ArrayList();
    private final List excludeTreeFilters = new ArrayList();
    private int maxCount = -1;
    private int skip = -1;

    protected LogCommand(Repository repository) {
        super(repository);
        this.walk = new RevWalk(repository);
    }

    @Override
    public Iterable call() {
        this.checkCallable();
        ArrayList<TreeFilter> arrayList = new ArrayList<TreeFilter>();
        if (!this.pathFilters.isEmpty()) {
            arrayList.add(AndTreeFilter.create(PathFilterGroup.create(this.pathFilters), TreeFilter.ANY_DIFF));
        }
        if (!this.excludeTreeFilters.isEmpty()) {
            for (TreeFilter treeFilter : this.excludeTreeFilters) {
                arrayList.add(AndTreeFilter.create(treeFilter, TreeFilter.ANY_DIFF));
            }
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.size() == 1) {
                arrayList.add(TreeFilter.ANY_DIFF);
            }
            this.walk.setTreeFilter(AndTreeFilter.create(arrayList));
        }
        if (this.skip > -1 && this.maxCount > -1) {
            this.walk.setRevFilter(AndRevFilter.create(SkipRevFilter.create(this.skip), MaxCountRevFilter.create(this.maxCount)));
        } else if (this.skip > -1) {
            this.walk.setRevFilter(SkipRevFilter.create(this.skip));
        } else if (this.maxCount > -1) {
            this.walk.setRevFilter(MaxCountRevFilter.create(this.maxCount));
        }
        if (!this.startSpecified) {
            try {
                ObjectId objectId = this.repo.resolve("HEAD");
                if (objectId == null) {
                    throw new NoHeadException(JGitText.get().noHEADExistsAndNoExplicitStartingRevisionWasSpecified);
                }
                this.add(objectId);
            }
            catch (IOException iOException) {
                throw new JGitInternalException(JGitText.get().anExceptionOccurredWhileTryingToAddTheIdOfHEAD, iOException);
            }
        }
        if (this.revFilter != null) {
            this.walk.setRevFilter(this.revFilter);
        }
        this.setCallable(false);
        return this.walk;
    }

    public LogCommand add(AnyObjectId anyObjectId) {
        return this.add(true, anyObjectId);
    }

    public LogCommand not(AnyObjectId anyObjectId) {
        return this.add(false, anyObjectId);
    }

    public LogCommand addRange(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        return this.not(anyObjectId).add(anyObjectId2);
    }

    public LogCommand all() {
        for (Ref ref : this.getRepository().getRefDatabase().getRefs()) {
            ObjectId objectId;
            if (!ref.isPeeled()) {
                ref = this.getRepository().getRefDatabase().peel(ref);
            }
            if ((objectId = ref.getPeeledObjectId()) == null) {
                objectId = ref.getObjectId();
            }
            RevCommit revCommit = null;
            try {
                revCommit = this.walk.parseCommit(objectId);
            }
            catch (IncorrectObjectTypeException | MissingObjectException iOException) {
                // empty catch block
            }
            if (revCommit == null) continue;
            this.add(revCommit);
        }
        return this;
    }

    public LogCommand addPath(String string) {
        this.checkCallable();
        this.pathFilters.add(PathFilter.create(string));
        return this;
    }

    public LogCommand excludePath(String string) {
        this.checkCallable();
        this.excludeTreeFilters.add(PathFilter.create(string).negate());
        return this;
    }

    public LogCommand setSkip(int n2) {
        this.checkCallable();
        this.skip = n2;
        return this;
    }

    public LogCommand setMaxCount(int n2) {
        this.checkCallable();
        this.maxCount = n2;
        return this;
    }

    private LogCommand add(boolean bl2, AnyObjectId anyObjectId) {
        this.checkCallable();
        try {
            if (bl2) {
                this.walk.markStart(this.walk.lookupCommit(anyObjectId));
                this.startSpecified = true;
            } else {
                this.walk.markUninteresting(this.walk.lookupCommit(anyObjectId));
            }
            return this;
        }
        catch (IncorrectObjectTypeException | MissingObjectException iOException) {
            throw iOException;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringAddingOfOptionToALogCommand, anyObjectId), iOException);
        }
    }

    public LogCommand setRevFilter(RevFilter revFilter) {
        this.checkCallable();
        this.revFilter = revFilter;
        return this;
    }
}

