/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

public class ListTagCommand
extends GitCommand {
    protected ListTagCommand(Repository repository) {
        super(repository);
    }

    @Override
    public List call() {
        this.checkCallable();
        ArrayList<Ref> arrayList = new ArrayList<Ref>();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            List list = this.repo.getRefDatabase().getRefsByPrefix("refs/tags/");
            for (Ref ref3 : list) {
                arrayList.add(ref3);
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        Collections.sort(arrayList, (ref, ref2) -> ref.getName().compareTo(ref2.getName()));
        this.setCallable(false);
        return arrayList;
    }
}

