/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ListNotesCommand
extends GitCommand {
    private String notesRef = "refs/notes/commits";

    protected ListNotesCommand(Repository repository) {
        super(repository);
    }

    @Override
    public List call() {
        this.checkCallable();
        ArrayList arrayList = new ArrayList();
        NoteMap noteMap = NoteMap.newEmptyMap();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Object object;
            Ref ref = this.repo.findRef(this.notesRef);
            if (ref != null) {
                object = revWalk.parseCommit(ref.getObjectId());
                noteMap = NoteMap.read(revWalk.getObjectReader(), (RevCommit)object);
            }
            object = noteMap.iterator();
            while (object.hasNext()) {
                arrayList.add(object.next());
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        return arrayList;
    }

    public ListNotesCommand setNotesRef(String string) {
        this.checkCallable();
        this.notesRef = string;
        return this;
    }
}

