/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.ListBranchCommand$ListMode;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;

public class ListBranchCommand
extends GitCommand {
    private ListBranchCommand$ListMode listMode;
    private String containsCommitish;

    protected ListBranchCommand(Repository repository) {
        super(repository);
    }

    @Override
    public List call() {
        ArrayList arrayList;
        this.checkCallable();
        try {
            ArrayList<Ref> arrayList2 = new ArrayList<Ref>();
            Ref ref3 = this.repo.exactRef("HEAD");
            if (ref3 != null && ref3.getLeaf().getName().equals("HEAD")) {
                arrayList2.add(ref3);
            }
            if (this.listMode == null) {
                arrayList2.addAll(this.repo.getRefDatabase().getRefsByPrefix("refs/heads/"));
            } else if (this.listMode == ListBranchCommand$ListMode.REMOTE) {
                arrayList2.addAll(this.repo.getRefDatabase().getRefsByPrefix("refs/remotes/"));
            } else {
                arrayList2.addAll(this.repo.getRefDatabase().getRefsByPrefix("refs/heads/", "refs/remotes/"));
            }
            arrayList = new ArrayList(this.filterRefs(arrayList2));
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        Collections.sort(arrayList, (ref, ref2) -> ref.getName().compareTo(ref2.getName()));
        this.setCallable(false);
        return arrayList;
    }

    private Collection filterRefs(Collection collection) {
        if (this.containsCommitish == null) {
            return collection;
        }
        try (RevWalk revWalk = new RevWalk(this.repo);){
            ObjectId objectId = this.repo.resolve(this.containsCommitish);
            if (objectId == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.containsCommitish));
            }
            RevCommit revCommit = revWalk.parseCommit(objectId);
            List list = RevWalkUtils.findBranchesReachableFrom(revCommit, revWalk, collection);
            return list;
        }
    }

    public ListBranchCommand setListMode(ListBranchCommand$ListMode listBranchCommand$ListMode) {
        this.checkCallable();
        this.listMode = listBranchCommand$ListMode;
        return this;
    }

    public ListBranchCommand setContains(String string) {
        this.checkCallable();
        this.containsCommitish = string;
        return this;
    }
}

