/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class InitCommand
implements Callable {
    private File directory;
    private File gitDir;
    private boolean bare;
    private FS fs;
    private String initialBranch;

    public Git call() {
        try {
            Object object;
            RepositoryBuilder repositoryBuilder = new RepositoryBuilder();
            if (this.bare) {
                repositoryBuilder.setBare();
            }
            if (this.fs != null) {
                repositoryBuilder.setFS(this.fs);
            }
            repositoryBuilder.readEnvironment();
            if (this.gitDir != null) {
                repositoryBuilder.setGitDir(this.gitDir);
            } else {
                this.gitDir = repositoryBuilder.getGitDir();
            }
            if (this.directory != null) {
                if (this.bare) {
                    repositoryBuilder.setGitDir(this.directory);
                } else {
                    repositoryBuilder.setWorkTree(this.directory);
                    if (this.gitDir == null) {
                        repositoryBuilder.setGitDir(new File(this.directory, ".git"));
                    }
                }
            } else if (repositoryBuilder.getGitDir() == null) {
                object = SystemReader.getInstance().getProperty("user.dir");
                if (object == null) {
                    object = ".";
                }
                File file = new File((String)object);
                if (!this.bare) {
                    file = new File(file, ".git");
                }
                repositoryBuilder.setGitDir(file);
            } else if (!this.bare) {
                object = SystemReader.getInstance().getProperty("user.dir");
                if (object == null) {
                    object = ".";
                }
                repositoryBuilder.setWorkTree(new File((String)object));
            }
            repositoryBuilder.setInitialBranch(StringUtils.isEmptyOrNull(this.initialBranch) ? SystemReader.getInstance().getUserConfig().getString("init", null, "defaultbranch") : this.initialBranch);
            object = repositoryBuilder.build();
            if (!((Repository)object).getObjectDatabase().exists()) {
                ((Repository)object).create(this.bare);
            }
            return new Git((Repository)object, true);
        }
        catch (IOException | ConfigInvalidException exception) {
            throw new JGitInternalException(exception.getMessage(), exception);
        }
    }

    public InitCommand setDirectory(File file) {
        InitCommand.validateDirs(file, this.gitDir, this.bare);
        this.directory = file;
        return this;
    }

    public InitCommand setGitDir(File file) {
        InitCommand.validateDirs(this.directory, file, this.bare);
        this.gitDir = file;
        return this;
    }

    private static void validateDirs(File file, File file2, boolean bl2) {
        if (file != null) {
            if (bl2) {
                if (file2 != null && !file2.equals(file)) {
                    throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedBareRepoDifferentDirs, file2, file));
                }
            } else if (file2 != null && file2.equals(file)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedNonBareRepoSameDirs, file2, file));
            }
        }
    }

    public InitCommand setBare(boolean bl2) {
        InitCommand.validateDirs(this.directory, this.gitDir, bl2);
        this.bare = bl2;
        return this;
    }

    public InitCommand setFs(FS fS) {
        this.fs = fS;
        return this;
    }

    public InitCommand setInitialBranch(String string) {
        this.initialBranch = string;
        return this;
    }
}

