/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;

public abstract class GitCommand
implements Callable {
    protected final Repository repo;
    private AtomicBoolean callable = new AtomicBoolean(true);

    protected GitCommand(Repository repository) {
        this.repo = repository;
    }

    public Repository getRepository() {
        return this.repo;
    }

    protected void setCallable(boolean bl2) {
        this.callable.set(bl2);
    }

    protected void checkCallable() {
        if (!this.callable.get()) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().commandWasCalledInTheWrongState, this.getClass().getName()));
        }
    }

    public abstract Object call();
}

