/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DfsGarbageCollector;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.GC;
import org.eclipse.jgit.internal.storage.file.GC$RepoStatistics;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.pack.PackConfig;

public class GarbageCollectCommand
extends GitCommand {
    public static final int DEFAULT_GC_AGGRESSIVE_DEPTH = 250;
    public static final int DEFAULT_GC_AGGRESSIVE_WINDOW = 250;
    private ProgressMonitor monitor;
    private Date expire;
    private PackConfig pconfig;
    private Boolean packKeptObjects;

    protected GarbageCollectCommand(Repository repository) {
        super(repository);
        this.pconfig = new PackConfig(repository);
    }

    public GarbageCollectCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
        return this;
    }

    public GarbageCollectCommand setExpire(Date date) {
        this.expire = date;
        return this;
    }

    public GarbageCollectCommand setAggressive(boolean bl2) {
        if (bl2) {
            StoredConfig storedConfig = this.repo.getConfig();
            this.pconfig.setDeltaSearchWindowSize(storedConfig.getInt("gc", "aggressiveWindow", 250));
            this.pconfig.setMaxDeltaDepth(storedConfig.getInt("gc", "aggressiveDepth", 250));
            this.pconfig.setReuseObjects(false);
        } else {
            this.pconfig = new PackConfig(this.repo);
        }
        return this;
    }

    public GarbageCollectCommand setPackKeptObjects(boolean bl2) {
        this.packKeptObjects = bl2;
        return this;
    }

    public GarbageCollectCommand setPreserveOldPacks(boolean bl2) {
        if (this.pconfig == null) {
            this.pconfig = new PackConfig(this.repo);
        }
        this.pconfig.setPreserveOldPacks(bl2);
        return this;
    }

    public GarbageCollectCommand setPrunePreserved(boolean bl2) {
        if (this.pconfig == null) {
            this.pconfig = new PackConfig(this.repo);
        }
        this.pconfig.setPrunePreserved(bl2);
        return this;
    }

    @Override
    public Properties call() {
        this.checkCallable();
        try {
            if (this.repo instanceof FileRepository) {
                GC gC = new GC((FileRepository)this.repo);
                gC.setPackConfig(this.pconfig);
                gC.setProgressMonitor(this.monitor);
                if (this.expire != null) {
                    gC.setExpire(this.expire);
                }
                if (this.packKeptObjects != null) {
                    gC.setPackKeptObjects(this.packKeptObjects);
                }
                try {
                    gC.gc();
                    return GarbageCollectCommand.toProperties(gC.getStatistics());
                }
                catch (ParseException parseException) {
                    throw new JGitInternalException(JGitText.get().gcFailed, parseException);
                }
            }
            if (this.repo instanceof DfsRepository) {
                DfsGarbageCollector dfsGarbageCollector = new DfsGarbageCollector((DfsRepository)this.repo);
                dfsGarbageCollector.setPackConfig(this.pconfig);
                dfsGarbageCollector.pack(this.monitor);
                return new Properties();
            }
            throw new UnsupportedOperationException(MessageFormat.format(JGitText.get().unsupportedGC, this.repo.getClass().toString()));
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().gcFailed, iOException);
        }
    }

    public Properties getStatistics() {
        try {
            if (this.repo instanceof FileRepository) {
                GC gC = new GC((FileRepository)this.repo);
                return GarbageCollectCommand.toProperties(gC.getStatistics());
            }
            return new Properties();
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().couldNotGetRepoStatistics, iOException);
        }
    }

    private static Properties toProperties(GC$RepoStatistics gC$RepoStatistics) {
        Properties properties = new Properties();
        properties.put("numberOfLooseObjects", (Object)gC$RepoStatistics.numberOfLooseObjects);
        properties.put("numberOfLooseRefs", (Object)gC$RepoStatistics.numberOfLooseRefs);
        properties.put("numberOfPackedObjects", (Object)gC$RepoStatistics.numberOfPackedObjects);
        properties.put("numberOfPackedRefs", (Object)gC$RepoStatistics.numberOfPackedRefs);
        properties.put("numberOfPackFiles", (Object)gC$RepoStatistics.numberOfPackFiles);
        properties.put("sizeOfLooseObjects", (Object)gC$RepoStatistics.sizeOfLooseObjects);
        properties.put("sizeOfPackedObjects", (Object)gC$RepoStatistics.sizeOfPackedObjects);
        return properties;
    }
}

