/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.FetchCommand$Callback;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.SubmoduleConfig$FetchRecurseSubmodulesMode;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;

public class FetchCommand
extends TransportCommand {
    private String remote = "origin";
    private List refSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean checkFetchedObjects;
    private Boolean removeDeletedRefs;
    private boolean dryRun;
    private boolean thin = true;
    private TagOpt tagOption;
    private SubmoduleConfig$FetchRecurseSubmodulesMode submoduleRecurseMode = null;
    private FetchCommand$Callback callback;
    private boolean isForceUpdate;
    private String initialBranch;

    protected FetchCommand(Repository repository) {
        super(repository);
        this.refSpecs = new ArrayList(3);
    }

    private SubmoduleConfig$FetchRecurseSubmodulesMode getRecurseMode(String string) {
        if (this.submoduleRecurseMode != null) {
            return this.submoduleRecurseMode;
        }
        SubmoduleConfig$FetchRecurseSubmodulesMode submoduleConfig$FetchRecurseSubmodulesMode = (SubmoduleConfig$FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig$FetchRecurseSubmodulesMode.values(), "submodule", string, "fetchRecurseSubmodules", null);
        if (submoduleConfig$FetchRecurseSubmodulesMode != null) {
            return submoduleConfig$FetchRecurseSubmodulesMode;
        }
        submoduleConfig$FetchRecurseSubmodulesMode = (SubmoduleConfig$FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig$FetchRecurseSubmodulesMode.values(), "fetch", null, "recurseSubmodules", null);
        if (submoduleConfig$FetchRecurseSubmodulesMode != null) {
            return submoduleConfig$FetchRecurseSubmodulesMode;
        }
        return SubmoduleConfig$FetchRecurseSubmodulesMode.ON_DEMAND;
    }

    private void fetchSubmodules(FetchResult fetchResult) {
        try (SubmoduleWalk submoduleWalk = new SubmoduleWalk(this.repo);
             RevWalk revWalk = new RevWalk(this.repo);){
            ObjectId objectId = this.repo.resolve("FETCH_HEAD");
            if (objectId == null) {
                return;
            }
            if (revWalk.parseAny(objectId).getType() == 3) {
                return;
            }
            submoduleWalk.setTree(revWalk.parseTree(objectId));
            while (submoduleWalk.next()) {
                Repository repository = submoduleWalk.getRepository();
                Throwable throwable = null;
                try {
                    SubmoduleConfig$FetchRecurseSubmodulesMode submoduleConfig$FetchRecurseSubmodulesMode;
                    if (repository == null || submoduleWalk.getModulesPath() == null || submoduleWalk.getConfigUrl() == null || ((submoduleConfig$FetchRecurseSubmodulesMode = this.getRecurseMode(submoduleWalk.getPath())) != SubmoduleConfig$FetchRecurseSubmodulesMode.ON_DEMAND || repository.getObjectDatabase().has(submoduleWalk.getObjectId())) && submoduleConfig$FetchRecurseSubmodulesMode != SubmoduleConfig$FetchRecurseSubmodulesMode.YES) continue;
                    FetchCommand fetchCommand = new FetchCommand(repository).setProgressMonitor(this.monitor).setTagOpt(this.tagOption).setCheckFetchedObjects(this.checkFetchedObjects).setRemoveDeletedRefs(this.isRemoveDeletedRefs()).setThin(this.thin).setRefSpecs(this.applyOptions(this.refSpecs)).setDryRun(this.dryRun).setRecurseSubmodules(submoduleConfig$FetchRecurseSubmodulesMode);
                    this.configure(fetchCommand);
                    if (this.callback != null) {
                        this.callback.fetchingSubmodule(submoduleWalk.getPath());
                    }
                    fetchResult.addSubmodule(submoduleWalk.getPath(), fetchCommand.call());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (repository == null) continue;
                    if (throwable != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    repository.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        catch (ConfigInvalidException configInvalidException) {
            throw new InvalidConfigurationException(configInvalidException.getMessage(), configInvalidException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FetchResult call() {
        this.checkCallable();
        try (Transport transport = Transport.open(this.repo, this.remote);){
            transport.setCheckFetchedObjects(this.checkFetchedObjects);
            transport.setRemoveDeletedRefs(this.isRemoveDeletedRefs());
            transport.setDryRun(this.dryRun);
            if (this.tagOption != null) {
                transport.setTagOpt(this.tagOption);
            }
            transport.setFetchThin(this.thin);
            this.configure(transport);
            FetchResult fetchResult = transport.fetch(this.monitor, this.applyOptions(this.refSpecs), this.initialBranch);
            if (!this.repo.isBare()) {
                this.fetchSubmodules(fetchResult);
            }
            FetchResult fetchResult2 = fetchResult;
            return fetchResult2;
        }
        catch (NoRemoteRepositoryException noRemoteRepositoryException) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), noRemoteRepositoryException);
        }
        catch (org.eclipse.jgit.errors.TransportException transportException) {
            throw new TransportException(transportException.getMessage(), transportException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), uRISyntaxException);
        }
        catch (NotSupportedException notSupportedException) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfFetchCommand, notSupportedException);
        }
    }

    private List applyOptions(List list) {
        if (!this.isForceUpdate()) {
            return list;
        }
        ArrayList<RefSpec> arrayList = new ArrayList<RefSpec>(3);
        for (RefSpec refSpec : list) {
            arrayList.add(refSpec.setForceUpdate(true));
        }
        return arrayList;
    }

    public FetchCommand setRecurseSubmodules(@Nullable SubmoduleConfig$FetchRecurseSubmodulesMode submoduleConfig$FetchRecurseSubmodulesMode) {
        this.checkCallable();
        this.submoduleRecurseMode = submoduleConfig$FetchRecurseSubmodulesMode;
        return this;
    }

    public FetchCommand setRemote(String string) {
        this.checkCallable();
        this.remote = string;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isCheckFetchedObjects() {
        return this.checkFetchedObjects;
    }

    public FetchCommand setCheckFetchedObjects(boolean bl2) {
        this.checkCallable();
        this.checkFetchedObjects = bl2;
        return this;
    }

    public boolean isRemoveDeletedRefs() {
        if (this.removeDeletedRefs != null) {
            return this.removeDeletedRefs;
        }
        boolean bl2 = false;
        StoredConfig storedConfig = this.repo.getConfig();
        bl2 = storedConfig.getBoolean("fetch", null, "prune", bl2);
        bl2 = storedConfig.getBoolean("remote", this.remote, "prune", bl2);
        return bl2;
    }

    public FetchCommand setRemoveDeletedRefs(boolean bl2) {
        this.checkCallable();
        this.removeDeletedRefs = bl2;
        return this;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public FetchCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        this.checkCallable();
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }

    public List getRefSpecs() {
        return this.refSpecs;
    }

    public FetchCommand setRefSpecs(String ... stringArray) {
        return this.setRefSpecs(Arrays.stream(stringArray).map(RefSpec::new).collect(Collectors.toList()));
    }

    public FetchCommand setRefSpecs(RefSpec ... refSpecArray) {
        return this.setRefSpecs(Arrays.asList(refSpecArray));
    }

    public FetchCommand setRefSpecs(List list) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(list);
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public FetchCommand setDryRun(boolean bl2) {
        this.checkCallable();
        this.dryRun = bl2;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public FetchCommand setThin(boolean bl2) {
        this.checkCallable();
        this.thin = bl2;
        return this;
    }

    public FetchCommand setTagOpt(TagOpt tagOpt) {
        this.checkCallable();
        this.tagOption = tagOpt;
        return this;
    }

    public FetchCommand setInitialBranch(String string) {
        this.initialBranch = string;
        return this;
    }

    public FetchCommand setCallback(FetchCommand$Callback fetchCommand$Callback) {
        this.callback = fetchCommand$Callback;
        return this;
    }

    public boolean isForceUpdate() {
        return this.isForceUpdate;
    }

    public FetchCommand setForceUpdate(boolean bl2) {
        this.isForceUpdate = bl2;
        return this;
    }
}

