/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.NullOutputStream;

public class DiffCommand
extends GitCommand {
    private AbstractTreeIterator oldTree;
    private AbstractTreeIterator newTree;
    private boolean cached;
    private TreeFilter pathFilter = TreeFilter.ALL;
    private boolean showNameAndStatusOnly;
    private OutputStream out;
    private int contextLines = -1;
    private String sourcePrefix;
    private String destinationPrefix;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected DiffCommand(Repository repository) {
        super(repository);
    }

    private DiffFormatter getDiffFormatter() {
        return this.out != null && !this.showNameAndStatusOnly ? new DiffFormatter(new BufferedOutputStream(this.out)) : new DiffFormatter(NullOutputStream.INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List call() {
        try (DiffFormatter diffFormatter = this.getDiffFormatter();){
            Object object;
            Object object2;
            diffFormatter.setRepository(this.repo);
            diffFormatter.setProgressMonitor(this.monitor);
            if (this.cached) {
                if (this.oldTree == null) {
                    object2 = this.repo.resolve("HEAD^{tree}");
                    if (object2 == null) {
                        throw new NoHeadException(JGitText.get().cannotReadTree);
                    }
                    object = new CanonicalTreeParser();
                    try (ObjectReader objectReader = this.repo.newObjectReader();){
                        ((CanonicalTreeParser)object).reset(objectReader, (AnyObjectId)object2);
                    }
                    this.oldTree = object;
                }
                this.newTree = new DirCacheIterator(this.repo.readDirCache());
            } else {
                if (this.oldTree == null) {
                    this.oldTree = new DirCacheIterator(this.repo.readDirCache());
                }
                if (this.newTree == null) {
                    this.newTree = new FileTreeIterator(this.repo);
                }
            }
            diffFormatter.setPathFilter(this.pathFilter);
            object2 = diffFormatter.scan(this.oldTree, this.newTree);
            if (this.showNameAndStatusOnly) {
                object = object2;
                return object;
            }
            if (this.contextLines >= 0) {
                diffFormatter.setContext(this.contextLines);
            }
            if (this.destinationPrefix != null) {
                diffFormatter.setNewPrefix(this.destinationPrefix);
            }
            if (this.sourcePrefix != null) {
                diffFormatter.setOldPrefix(this.sourcePrefix);
            }
            diffFormatter.format((List)object2);
            diffFormatter.flush();
            object = object2;
            return object;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    public DiffCommand setCached(boolean bl2) {
        this.cached = bl2;
        return this;
    }

    public DiffCommand setPathFilter(TreeFilter treeFilter) {
        this.pathFilter = treeFilter;
        return this;
    }

    public DiffCommand setOldTree(AbstractTreeIterator abstractTreeIterator) {
        this.oldTree = abstractTreeIterator;
        return this;
    }

    public DiffCommand setNewTree(AbstractTreeIterator abstractTreeIterator) {
        this.newTree = abstractTreeIterator;
        return this;
    }

    public DiffCommand setShowNameAndStatusOnly(boolean bl2) {
        this.showNameAndStatusOnly = bl2;
        return this;
    }

    public DiffCommand setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        return this;
    }

    public DiffCommand setContextLines(int n2) {
        this.contextLines = n2;
        return this;
    }

    public DiffCommand setSourcePrefix(String string) {
        this.sourcePrefix = string;
        return this;
    }

    public DiffCommand setDestinationPrefix(String string) {
        this.destinationPrefix = string;
        return this;
    }

    public DiffCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }
}

