/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.api.DescribeCommand$1;
import org.eclipse.jgit.api.DescribeCommand$1Candidate;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;

public class DescribeCommand
extends GitCommand {
    private final RevWalk w;
    private RevCommit target;
    private int maxCandidates = 10;
    private boolean longDesc;
    private List matchers = new ArrayList();
    private boolean useAll;
    private boolean useTags;
    private boolean always;
    private final Comparator TAG_TIE_BREAKER = new DescribeCommand$1(this);

    protected DescribeCommand(Repository repository) {
        super(repository);
        this.w = new RevWalk(repository);
        this.w.setRetainBody(false);
    }

    public DescribeCommand setTarget(ObjectId objectId) {
        this.target = this.w.parseCommit(objectId);
        return this;
    }

    public DescribeCommand setTarget(String string) {
        ObjectId objectId = this.repo.resolve(string);
        if (objectId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, string));
        }
        return this.setTarget(objectId);
    }

    public DescribeCommand setLong(boolean bl2) {
        this.longDesc = bl2;
        return this;
    }

    public DescribeCommand setAll(boolean bl2) {
        this.useAll = bl2;
        return this;
    }

    public DescribeCommand setTags(boolean bl2) {
        this.useTags = bl2;
        return this;
    }

    public DescribeCommand setAlways(boolean bl2) {
        this.always = bl2;
        return this;
    }

    private String longDescription(Ref ref, int n2, ObjectId objectId) {
        return String.format("%s-%d-g%s", this.formatRefName(ref.getName()), n2, this.w.getObjectReader().abbreviate(objectId).name());
    }

    public DescribeCommand setMatch(String ... stringArray) {
        for (String string : stringArray) {
            this.matchers.add(new FileNameMatcher(string, null));
        }
        return this;
    }

    private Optional getBestMatch(List list) {
        if (list == null || list.isEmpty()) {
            return Optional.empty();
        }
        if (this.matchers.isEmpty()) {
            Collections.sort(list, this.TAG_TIE_BREAKER);
            return Optional.of(list.get(0));
        }
        Stream<Object> stream2 = Stream.empty();
        for (FileNameMatcher fileNameMatcher : this.matchers) {
            Stream<Ref> stream3 = list.stream().filter(ref -> {
                fileNameMatcher.append(this.formatRefName(ref.getName()));
                boolean bl2 = fileNameMatcher.isMatch();
                fileNameMatcher.reset();
                return bl2;
            });
            stream2 = Stream.of(stream2, stream3).flatMap(stream -> stream);
        }
        return stream2.sorted(this.TAG_TIE_BREAKER).findFirst();
    }

    private ObjectId getObjectIdFromRef(Ref ref) {
        try {
            ObjectId objectId = this.repo.getRefDatabase().peel(ref).getPeeledObjectId();
            if (objectId == null) {
                objectId = ref.getObjectId();
            }
            return objectId;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public String call() {
        try {
            Object object;
            RevCommit revCommit;
            this.checkCallable();
            if (this.target == null) {
                this.setTarget("HEAD");
            }
            List list = this.repo.getRefDatabase().getRefsByPrefix(this.useAll ? "refs/" : "refs/tags/");
            Map<ObjectId, List<Ref>> map = list.stream().filter(this::filterLightweightTags).collect(Collectors.groupingBy(this::getObjectIdFromRef));
            RevFlagSet revFlagSet = new RevFlagSet();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Optional optional = this.getBestMatch(map.get(this.target));
            if (optional.isPresent()) {
                String string = this.longDesc ? this.longDescription((Ref)optional.get(), 0, this.target) : this.formatRefName(((Ref)optional.get()).getName());
                return string;
            }
            this.w.markStart(this.target);
            int n2 = 0;
            while ((revCommit = this.w.next()) != null) {
                if (!revCommit.hasAny(revFlagSet) && (optional = this.getBestMatch(map.get(revCommit))).isPresent()) {
                    object = new DescribeCommand$1Candidate(this, revCommit, (Ref)optional.get(), revFlagSet);
                    arrayList.add(object);
                    ((DescribeCommand$1Candidate)object).depth = n2;
                }
                for (DescribeCommand$1Candidate describeCommand$1Candidate3 : arrayList) {
                    if (describeCommand$1Candidate3.reaches(revCommit)) continue;
                    ++describeCommand$1Candidate3.depth;
                }
                if (arrayList.size() >= this.maxCandidates) break;
                ++n2;
            }
            while ((revCommit = this.w.next()) != null) {
                if (revCommit.hasAll(revFlagSet)) {
                    for (RevCommit revCommit2 : revCommit.getParents()) {
                        revCommit2.add(RevFlag.SEEN);
                    }
                    continue;
                }
                for (DescribeCommand$1Candidate describeCommand$1Candidate4 : arrayList) {
                    if (describeCommand$1Candidate4.reaches(revCommit)) continue;
                    ++describeCommand$1Candidate4.depth;
                }
            }
            if (arrayList.isEmpty()) {
                object = this.always ? this.w.getObjectReader().abbreviate(this.target).name() : null;
                return object;
            }
            object = (DescribeCommand$1Candidate)Collections.min(arrayList, (describeCommand$1Candidate, describeCommand$1Candidate2) -> describeCommand$1Candidate.depth - describeCommand$1Candidate2.depth);
            String string = ((DescribeCommand$1Candidate)object).describe(this.target);
            return string;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        finally {
            this.setCallable(false);
            this.w.close();
        }
    }

    private String formatRefName(String string) {
        return string.startsWith("refs/tags/") ? string.substring("refs/tags/".length()) : string.substring("refs/".length());
    }

    private boolean filterLightweightTags(Ref ref) {
        ObjectId objectId = ref.getObjectId();
        try {
            return this.useAll || this.useTags || objectId != null && this.w.parseTag(objectId) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static /* synthetic */ RevWalk access$000(DescribeCommand describeCommand) {
        return describeCommand.w;
    }

    static /* synthetic */ String access$100(DescribeCommand describeCommand, Ref ref, int n2, ObjectId objectId) {
        return describeCommand.longDescription(ref, n2, objectId);
    }
}

