/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;

public class DeleteTagCommand
extends GitCommand {
    private final Set tags = new HashSet();

    protected DeleteTagCommand(Repository repository) {
        super(repository);
    }

    @Override
    public List call() {
        this.checkCallable();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.tags.isEmpty()) {
            return arrayList;
        }
        try {
            this.setCallable(false);
            for (String string : this.tags) {
                Ref ref;
                if (string == null || (ref = this.repo.findRef(string)) == null) continue;
                String string2 = ref.getName();
                RefUpdate refUpdate = this.repo.updateRef(string2);
                refUpdate.setForceUpdate(true);
                RefUpdate$Result refUpdate$Result = refUpdate.delete();
                boolean bl2 = true;
                switch (refUpdate$Result) {
                    case IO_FAILURE: 
                    case LOCK_FAILURE: 
                    case REJECTED: {
                        bl2 = false;
                        break;
                    }
                }
                if (bl2) {
                    arrayList.add(string2);
                    continue;
                }
                throw new JGitInternalException(MessageFormat.format(JGitText.get().deleteTagUnexpectedResult, refUpdate$Result.name()));
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    public DeleteTagCommand setTags(String ... stringArray) {
        this.checkCallable();
        this.tags.clear();
        this.tags.addAll(Arrays.asList(stringArray));
        return this;
    }
}

