/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.DeleteBranchCommand$1;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class DeleteBranchCommand
extends GitCommand {
    private final Set branchNames = new HashSet();
    private boolean force;

    protected DeleteBranchCommand(Repository repository) {
        super(repository);
    }

    @Override
    public List call() {
        this.checkCallable();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.branchNames.isEmpty()) {
            return arrayList;
        }
        try {
            Object object;
            Object object2;
            String string = this.repo.getFullBranch();
            if (!this.force) {
                RevWalk revWalk = new RevWalk(this.repo);
                Object object3 = null;
                try {
                    object2 = revWalk.parseCommit(this.repo.resolve("HEAD"));
                    for (Object object4 : this.branchNames) {
                        RevCommit revCommit;
                        if (object4 == null || (object = this.repo.findRef((String)object4)) == null || revWalk.isMergedInto(revCommit = revWalk.parseCommit(this.repo.resolve((String)object4)), (RevCommit)object2)) continue;
                        throw new NotMergedException();
                    }
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (revWalk != null) {
                        if (object3 != null) {
                            try {
                                revWalk.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            revWalk.close();
                        }
                    }
                }
            }
            this.setCallable(false);
            for (Object object3 : this.branchNames) {
                Object object4;
                if (object3 == null || (object2 = this.repo.findRef((String)object3)) == null) continue;
                String string2 = object2.getName();
                if (string2.equals(string)) {
                    throw new CannotDeleteCurrentBranchException(MessageFormat.format(JGitText.get().cannotDeleteCheckedOutBranch, object3));
                }
                object4 = this.repo.updateRef(string2);
                ((RefUpdate)object4).setRefLogMessage("branch deleted", false);
                ((RefUpdate)object4).setForceUpdate(true);
                object = ((RefUpdate)object4).delete();
                boolean bl2 = true;
                switch (DeleteBranchCommand$1.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[((Enum)object).ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl2 = false;
                        break;
                    }
                }
                if (bl2) {
                    arrayList.add(string2);
                    if (!string2.startsWith("refs/heads/")) continue;
                    String string3 = string2.substring("refs/heads/".length());
                    StoredConfig storedConfig = this.repo.getConfig();
                    storedConfig.unsetSection("branch", string3);
                    storedConfig.save();
                    continue;
                }
                throw new JGitInternalException(MessageFormat.format(JGitText.get().deleteBranchUnexpectedResult, ((Enum)object).name()));
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    public DeleteBranchCommand setBranchNames(String ... stringArray) {
        this.checkCallable();
        this.branchNames.clear();
        this.branchNames.addAll(Arrays.asList(stringArray));
        return this;
    }

    public DeleteBranchCommand setForce(boolean bl2) {
        this.checkCallable();
        this.force = bl2;
        return this;
    }
}

