/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.CreateBranchCommand$1;
import org.eclipse.jgit.api.CreateBranchCommand$SetupUpstreamMode;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class CreateBranchCommand
extends GitCommand {
    private String name;
    private boolean force = false;
    private CreateBranchCommand$SetupUpstreamMode upstreamMode;
    private String startPoint = "HEAD";
    private RevCommit startCommit;

    protected CreateBranchCommand(Repository repository) {
        super(repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Ref call() {
        this.checkCallable();
        this.processOptions();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Object object;
            Object object2;
            Object object3;
            Object object4;
            boolean bl2;
            Ref ref = this.repo.findRef(this.name);
            boolean bl3 = bl2 = ref != null && ref.getName().startsWith("refs/heads/");
            if (!this.force && bl2) {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists1, this.name));
            }
            ObjectId objectId = this.getStartPointObjectId();
            String string = null;
            if (this.startPoint != null && (object4 = this.repo.findRef(this.startPoint)) != null) {
                string = object4.getName();
            }
            String string2 = "";
            if (string == null) {
                if (this.startCommit != null) {
                    object3 = this.startCommit.getShortMessage();
                } else {
                    object2 = revWalk.parseCommit(this.repo.resolve(this.getStartPointOrHead()));
                    object3 = object2.getShortMessage();
                }
                object4 = bl2 ? "branch: Reset start-point to commit " + (String)object3 : "branch: Created from commit " + (String)object3;
            } else if (string.startsWith("refs/heads/") || string.startsWith("refs/remotes/")) {
                string2 = string;
                object4 = bl2 ? "branch: Reset start-point to branch " + string : "branch: Created from branch " + string2;
            } else {
                objectId = revWalk.peel(revWalk.parseAny(objectId));
                object4 = bl2 ? "branch: Reset start-point to tag " + string : "branch: Created from tag " + string;
            }
            object3 = this.repo.updateRef("refs/heads/" + this.name);
            ((RefUpdate)object3).setNewObjectId(objectId);
            ((RefUpdate)object3).setRefLogMessage((String)object4, false);
            object2 = bl2 && this.force ? ((RefUpdate)object3).forceUpdate() : ((RefUpdate)object3).update();
            this.setCallable(false);
            boolean bl4 = false;
            switch (CreateBranchCommand$1.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[((Enum)object2).ordinal()]) {
                case 1: {
                    bl4 = !bl2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    bl4 = bl2;
                    break;
                }
            }
            if (!bl4) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().createBranchUnexpectedResult, ((Enum)object2).name()));
            }
            Ref ref2 = this.repo.findRef(this.name);
            if (ref2 == null) {
                throw new JGitInternalException(JGitText.get().createBranchFailedUnknownReason);
            }
            if (string2.length() == 0) {
                Ref ref3 = ref2;
                return ref3;
            }
            boolean bl5 = this.upstreamMode == CreateBranchCommand$SetupUpstreamMode.SET_UPSTREAM || this.upstreamMode == CreateBranchCommand$SetupUpstreamMode.TRACK ? true : (this.upstreamMode == CreateBranchCommand$SetupUpstreamMode.NOTRACK ? false : ("false".equals(object = this.repo.getConfig().getString("branch", null, "autosetupmerge")) ? false : ("always".equals(object) ? true : string2.startsWith("refs/remotes/"))));
            if (bl5) {
                object = this.repo.getConfig();
                String string3 = this.repo.getRemoteName(string2);
                if (string3 != null) {
                    String string4 = this.repo.shortenRemoteBranchName(string2);
                    ((Config)object).setString("branch", this.name, "remote", string3);
                    ((Config)object).setString("branch", this.name, "merge", "refs/heads/" + string4);
                } else {
                    ((Config)object).setString("branch", this.name, "remote", ".");
                    ((Config)object).setString("branch", this.name, "merge", string2);
                }
                ((StoredConfig)object).save();
            }
            object = ref2;
            return object;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }

    private ObjectId getStartPointObjectId() {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        String string = this.getStartPointOrHead();
        ObjectId objectId = this.repo.resolve(string);
        if (objectId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, string));
        }
        return objectId;
    }

    private String getStartPointOrHead() {
        return this.startPoint != null ? this.startPoint : "HEAD";
    }

    private void processOptions() {
        if (this.name == null || !Repository.isValidRefName("refs/heads/" + this.name) || !CreateBranchCommand.isValidBranchName(this.name)) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
    }

    public static boolean isValidBranchName(String string) {
        if ("HEAD".equals(string)) {
            return false;
        }
        return !string.startsWith("-");
    }

    public CreateBranchCommand setName(String string) {
        this.checkCallable();
        this.name = string;
        return this;
    }

    public CreateBranchCommand setForce(boolean bl2) {
        this.checkCallable();
        this.force = bl2;
        return this;
    }

    public CreateBranchCommand setStartPoint(String string) {
        this.checkCallable();
        this.startPoint = string;
        this.startCommit = null;
        return this;
    }

    public CreateBranchCommand setStartPoint(RevCommit revCommit) {
        this.checkCallable();
        this.startCommit = revCommit;
        this.startPoint = null;
        return this;
    }

    public CreateBranchCommand setUpstreamMode(CreateBranchCommand$SetupUpstreamMode createBranchCommand$SetupUpstreamMode) {
        this.checkCallable();
        this.upstreamMode = createBranchCommand$SetupUpstreamMode;
        return this;
    }
}

