/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.api.CommitCommand$1;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.ServiceUnavailableException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.hooks.Hooks;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgConfig$GpgFormat;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitCommand
extends GitCommand {
    private static final Logger log = LoggerFactory.getLogger(CommitCommand.class);
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private boolean all;
    private List only = new ArrayList();
    private boolean[] onlyProcessed;
    private boolean amend;
    private boolean insertChangeId;
    private List parents = new LinkedList();
    private String reflogComment;
    private boolean useDefaultReflogMessage = true;
    private boolean noVerify;
    private HashMap hookOutRedirect = new HashMap(3);
    private HashMap hookErrRedirect = new HashMap(3);
    private Boolean allowEmpty;
    private Boolean signCommit;
    private String signingKey;
    private GpgSigner gpgSigner;
    private GpgConfig gpgConfig;
    private CredentialsProvider credentialsProvider = CredentialsProvider.getDefault();

    protected CommitCommand(Repository repository) {
        super(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() {
        this.checkCallable();
        Collections.sort(this.only);
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Object object;
            RevCommit revCommit;
            Serializable serializable;
            Object object2;
            RepositoryState repositoryState = this.repo.getRepositoryState();
            if (!repositoryState.canCommit()) {
                throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotCommitOnARepoWithState, repositoryState.name()));
            }
            if (!this.noVerify) {
                Hooks.preCommit(this.repo, (PrintStream)this.hookOutRedirect.get("pre-commit"), (PrintStream)this.hookErrRedirect.get("pre-commit")).call();
            }
            this.processOptions(repositoryState, revWalk);
            if (this.all && !this.repo.isBare()) {
                try {
                    object2 = new Git(this.repo);
                    serializable = null;
                    try {
                        ((Git)object2).add().addFilepattern(".").setUpdate(true).call();
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (serializable != null) {
                                try {
                                    ((Git)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                            } else {
                                ((Git)object2).close();
                            }
                        }
                    }
                }
                catch (NoFilepatternException noFilepatternException) {
                    throw new JGitInternalException(noFilepatternException.getMessage(), noFilepatternException);
                }
            }
            if ((object2 = this.repo.exactRef("HEAD")) == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            serializable = this.repo.resolve("HEAD^{commit}");
            if (serializable == null && this.amend) {
                throw new WrongRepositoryStateException(JGitText.get().commitAmendOnInitialNotPossible);
            }
            if (serializable != null) {
                if (this.amend) {
                    revCommit = revWalk.parseCommit((AnyObjectId)((Object)serializable));
                    for (RevCommit objectId : revCommit.getParents()) {
                        this.parents.add(objectId.getId());
                    }
                    if (this.author == null) {
                        this.author = revCommit.getAuthorIdent();
                    }
                } else {
                    this.parents.add(0, serializable);
                }
            }
            if (!this.noVerify) {
                this.message = Hooks.commitMsg(this.repo, (PrintStream)this.hookOutRedirect.get("commit-msg"), (PrintStream)this.hookErrRedirect.get("commit-msg")).setCommitMessage(this.message).call();
            }
            Object object3 = this.repo.lockDirCache();
            try {
                object = this.repo.newObjectInserter();
                Throwable throwable = null;
                try {
                    if (!this.only.isEmpty()) {
                        object3 = this.createTemporaryIndex((ObjectId)serializable, (DirCache)object3, revWalk);
                    }
                    ObjectId throwable3 = ((DirCache)object3).writeTree((ObjectInserter)object);
                    if (this.insertChangeId) {
                        this.insertChangeId(throwable3);
                    }
                    this.checkIfEmpty(revWalk, (ObjectId)serializable, throwable3);
                    CommitBuilder commitBuilder = new CommitBuilder();
                    commitBuilder.setCommitter(this.committer);
                    commitBuilder.setAuthor(this.author);
                    commitBuilder.setMessage(this.message);
                    commitBuilder.setParentIds(this.parents);
                    commitBuilder.setTreeId(throwable3);
                    if (this.signCommit.booleanValue()) {
                        this.sign(commitBuilder);
                    }
                    ObjectId objectId = ((ObjectInserter)object).insert(commitBuilder);
                    ((ObjectInserter)object).flush();
                    revCommit = revWalk.parseCommit(objectId);
                    this.updateRef(repositoryState, (ObjectId)serializable, revCommit, objectId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((ObjectInserter)object).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            ((ObjectInserter)object).close();
                        }
                    }
                }
            }
            finally {
                ((DirCache)object3).unlock();
            }
            try {
                Hooks.postCommit(this.repo, (PrintStream)this.hookOutRedirect.get("post-commit"), (PrintStream)this.hookErrRedirect.get("post-commit")).call();
            }
            catch (Exception exception) {
                log.error(MessageFormat.format(JGitText.get().postCommitHookFailed, exception.getMessage()), (Throwable)exception);
            }
            object = revCommit;
            return object;
        }
        catch (UnmergedPathException unmergedPathException) {
            throw new UnmergedPathsException(unmergedPathException);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfCommitCommand, iOException);
        }
    }

    private void checkIfEmpty(RevWalk revWalk, ObjectId objectId, ObjectId objectId2) {
        if (objectId != null && !this.allowEmpty.booleanValue()) {
            RevCommit revCommit = revWalk.parseCommit(objectId);
            revCommit.getTree();
            if (objectId2.equals(revCommit.getTree())) {
                throw new EmptyCommitException(JGitText.get().emptyCommit);
            }
        }
    }

    private void sign(CommitBuilder commitBuilder) {
        if (this.gpgSigner == null) {
            throw new ServiceUnavailableException(JGitText.get().signingServiceUnavailable);
        }
        if (this.gpgSigner instanceof GpgObjectSigner) {
            ((GpgObjectSigner)((Object)this.gpgSigner)).signObject(commitBuilder, this.signingKey, this.committer, this.credentialsProvider, this.gpgConfig);
        } else {
            if (this.gpgConfig.getKeyFormat() != GpgConfig$GpgFormat.OPENPGP) {
                throw new UnsupportedSigningFormatException(JGitText.get().onlyOpenPgpSupportedForSigning);
            }
            this.gpgSigner.sign(commitBuilder, this.signingKey, this.committer, this.credentialsProvider);
        }
    }

    private void updateRef(RepositoryState repositoryState, ObjectId objectId, RevCommit revCommit, ObjectId objectId2) {
        Object object;
        RefUpdate refUpdate = this.repo.updateRef("HEAD");
        refUpdate.setNewObjectId(objectId2);
        if (!this.useDefaultReflogMessage) {
            refUpdate.setRefLogMessage(this.reflogComment, false);
        } else {
            object = this.amend ? "commit (amend): " : (this.parents.isEmpty() ? "commit (initial): " : "commit: ");
            refUpdate.setRefLogMessage((String)object + revCommit.getShortMessage(), false);
        }
        if (objectId != null) {
            refUpdate.setExpectedOldObjectId(objectId);
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        object = refUpdate.forceUpdate();
        switch (CommitCommand$1.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[((Enum)object).ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.setCallable(false);
                if (repositoryState == RepositoryState.MERGING_RESOLVED || this.isMergeDuringRebase(repositoryState)) {
                    this.repo.writeMergeCommitMsg(null);
                    this.repo.writeMergeHeads(null);
                    break;
                }
                if (repositoryState == RepositoryState.CHERRY_PICKING_RESOLVED) {
                    this.repo.writeMergeCommitMsg(null);
                    this.repo.writeCherryPickHead(null);
                    break;
                }
                if (repositoryState != RepositoryState.REVERTING_RESOLVED) break;
                this.repo.writeMergeCommitMsg(null);
                this.repo.writeRevertHead(null);
                break;
            }
            case 4: 
            case 5: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), (RefUpdate$Result)((Object)object));
            }
            default: {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", objectId2.toString(), object));
            }
        }
    }

    private void insertChangeId(ObjectId objectId) {
        ObjectId objectId2 = null;
        if (!this.parents.isEmpty()) {
            objectId2 = (ObjectId)this.parents.get(0);
        }
        ObjectId objectId3 = ChangeIdUtil.computeChangeId(objectId, objectId2, this.author, this.committer, this.message);
        this.message = ChangeIdUtil.insertId(this.message, objectId3);
        if (objectId3 != null) {
            this.message = this.message.replaceAll("\nChange-Id: I" + ObjectId.zeroId().getName() + "\n", "\nChange-Id: I" + objectId3.getName() + "\n");
        }
    }

    private DirCache createTemporaryIndex(ObjectId objectId, DirCache dirCache, RevWalk revWalk) {
        ObjectInserter objectInserter = null;
        DirCacheBuilder dirCacheBuilder = dirCache.builder();
        DirCache dirCache2 = DirCache.newInCore();
        DirCacheBuilder dirCacheBuilder2 = dirCache2.builder();
        this.onlyProcessed = new boolean[this.only.size()];
        boolean bl2 = true;
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            treeWalk.setOperationType(TreeWalk$OperationType.CHECKIN_OP);
            int n2 = treeWalk.addTree(new DirCacheBuildIterator(dirCacheBuilder));
            FileTreeIterator fileTreeIterator = new FileTreeIterator(this.repo);
            fileTreeIterator.setDirCacheIterator(treeWalk, 0);
            int n3 = treeWalk.addTree(fileTreeIterator);
            int n4 = -1;
            if (objectId != null) {
                n4 = treeWalk.addTree(revWalk.parseTree(objectId));
            }
            treeWalk.setRecursive(true);
            String string = null;
            while (treeWalk.next()) {
                Object object;
                String string2 = treeWalk.getPathString();
                int n5 = this.lookupOnly(string2);
                CanonicalTreeParser canonicalTreeParser = null;
                if (n4 != -1) {
                    canonicalTreeParser = (CanonicalTreeParser)treeWalk.getTree(n4, CanonicalTreeParser.class);
                }
                DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(n2, DirCacheIterator.class);
                if (n5 >= 0) {
                    object = (FileTreeIterator)treeWalk.getTree(n3, FileTreeIterator.class);
                    boolean bl3 = dirCacheIterator != null || canonicalTreeParser != null;
                    if (!bl3 || string2.equals(string)) continue;
                    string = string2;
                    if (object != null) {
                        boolean bl4;
                        DirCacheEntry dirCacheEntry = new DirCacheEntry(string2);
                        long l2 = ((WorkingTreeIterator)object).getEntryLength();
                        dirCacheEntry.setLength(l2);
                        dirCacheEntry.setLastModified(((WorkingTreeIterator)object).getEntryLastModifiedInstant());
                        dirCacheEntry.setFileMode(((WorkingTreeIterator)object).getIndexFileMode(dirCacheIterator));
                        boolean bl5 = bl4 = dirCacheIterator != null && ((AbstractTreeIterator)object).idEqual(dirCacheIterator) || canonicalTreeParser != null && ((AbstractTreeIterator)object).idEqual(canonicalTreeParser);
                        if (bl4) {
                            dirCacheEntry.setObjectId(((AbstractTreeIterator)object).getEntryObjectId());
                        } else if (FileMode.GITLINK.equals(dirCacheEntry.getFileMode())) {
                            dirCacheEntry.setObjectId(((AbstractTreeIterator)object).getEntryObjectId());
                        } else {
                            if (objectInserter == null) {
                                objectInserter = this.repo.newObjectInserter();
                            }
                            long l3 = ((WorkingTreeIterator)object).getEntryContentLength();
                            try (InputStream inputStream = ((WorkingTreeIterator)object).openEntryStream();){
                                dirCacheEntry.setObjectId(objectInserter.insert(3, l3, inputStream));
                            }
                        }
                        dirCacheBuilder.add(dirCacheEntry);
                        dirCacheBuilder2.add(dirCacheEntry);
                        if (bl2 && (canonicalTreeParser == null || !canonicalTreeParser.idEqual((AbstractTreeIterator)object) || canonicalTreeParser.getEntryRawMode() != ((AbstractTreeIterator)object).getEntryRawMode())) {
                            bl2 = false;
                        }
                    } else if (bl2 && canonicalTreeParser != null) {
                        bl2 = false;
                    }
                    this.onlyProcessed[n5] = true;
                    continue;
                }
                if (canonicalTreeParser != null) {
                    object = new DirCacheEntry(string2);
                    ((DirCacheEntry)object).setObjectId(canonicalTreeParser.getEntryObjectId());
                    ((DirCacheEntry)object).setFileMode(canonicalTreeParser.getEntryFileMode());
                    dirCacheBuilder2.add((DirCacheEntry)object);
                }
                if (dirCacheIterator == null) continue;
                dirCacheBuilder.add(dirCacheIterator.getDirCacheEntry());
            }
        }
        for (int i2 = 0; i2 < this.onlyProcessed.length; ++i2) {
            if (this.onlyProcessed[i2]) continue;
            throw new JGitInternalException(MessageFormat.format(JGitText.get().entryNotFoundByPath, this.only.get(i2)));
        }
        if (bl2 && !this.allowEmpty.booleanValue()) {
            throw new JGitInternalException(JGitText.get().emptyCommit);
        }
        dirCacheBuilder.commit();
        dirCacheBuilder2.finish();
        return dirCache2;
    }

    private int lookupOnly(String string) {
        String string2 = string;
        while (true) {
            int n2;
            if ((n2 = Collections.binarySearch(this.only, string2)) >= 0) {
                return n2;
            }
            int n3 = string2.lastIndexOf(47);
            if (n3 < 1) break;
            string2 = string2.substring(0, n3);
        }
        return -1;
    }

    private void processOptions(RepositoryState repositoryState, RevWalk revWalk) {
        if (this.committer == null) {
            this.committer = new PersonIdent(this.repo);
        }
        if (this.author == null && !this.amend) {
            this.author = this.committer;
        }
        if (this.allowEmpty == null) {
            Boolean bl2 = this.allowEmpty = this.only.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (repositoryState == RepositoryState.MERGING_RESOLVED || this.isMergeDuringRebase(repositoryState)) {
            try {
                this.parents = this.repo.readMergeHeads();
                if (this.parents != null) {
                    for (int i2 = 0; i2 < this.parents.size(); ++i2) {
                        RevObject revObject = revWalk.parseAny((AnyObjectId)this.parents.get(i2));
                        if (!(revObject instanceof RevTag)) continue;
                        this.parents.set(i2, revWalk.peel(revObject));
                    }
                }
            }
            catch (IOException iOException) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", iOException), iOException);
            }
            if (this.message == null) {
                try {
                    this.message = this.repo.readMergeCommitMsg();
                }
                catch (IOException iOException) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", iOException), iOException);
                }
            }
        } else if (repositoryState == RepositoryState.SAFE && this.message == null) {
            try {
                this.message = this.repo.readSquashCommitMsg();
                if (this.message != null) {
                    this.repo.writeSquashCommitMsg(null);
                }
            }
            catch (IOException iOException) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", iOException), iOException);
            }
        }
        if (this.message == null) {
            throw new NoMessageException(JGitText.get().commitMessageNotSpecified);
        }
        if (this.gpgConfig == null) {
            this.gpgConfig = new GpgConfig(this.repo.getConfig());
        }
        if (this.signCommit == null) {
            Boolean bl3 = this.signCommit = this.gpgConfig.isSignCommits() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.signingKey == null) {
            this.signingKey = this.gpgConfig.getSigningKey();
        }
        if (this.gpgSigner == null) {
            this.gpgSigner = GpgSigner.getDefault();
        }
    }

    private boolean isMergeDuringRebase(RepositoryState repositoryState) {
        if (repositoryState != RepositoryState.REBASING_INTERACTIVE && repositoryState != RepositoryState.REBASING_MERGE) {
            return false;
        }
        try {
            return this.repo.readMergeHeads() != null;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", iOException), iOException);
        }
    }

    public CommitCommand setMessage(String string) {
        this.checkCallable();
        this.message = string;
        return this;
    }

    public CommitCommand setAllowEmpty(boolean bl2) {
        this.allowEmpty = bl2;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommitCommand setCommitter(PersonIdent personIdent) {
        this.checkCallable();
        this.committer = personIdent;
        return this;
    }

    public CommitCommand setCommitter(String string, String string2) {
        this.checkCallable();
        return this.setCommitter(new PersonIdent(string, string2));
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public CommitCommand setAuthor(PersonIdent personIdent) {
        this.checkCallable();
        this.author = personIdent;
        return this;
    }

    public CommitCommand setAuthor(String string, String string2) {
        this.checkCallable();
        return this.setAuthor(new PersonIdent(string, string2));
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public CommitCommand setAll(boolean bl2) {
        this.checkCallable();
        if (bl2 && !this.only.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--all", "--only"));
        }
        this.all = bl2;
        return this;
    }

    public CommitCommand setAmend(boolean bl2) {
        this.checkCallable();
        this.amend = bl2;
        return this;
    }

    public CommitCommand setOnly(String string) {
        String string2;
        this.checkCallable();
        if (this.all) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--only", "--all"));
        }
        String string3 = string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        if (!this.only.contains(string2)) {
            this.only.add(string2);
        }
        return this;
    }

    public CommitCommand setInsertChangeId(boolean bl2) {
        this.checkCallable();
        this.insertChangeId = bl2;
        return this;
    }

    public CommitCommand setReflogComment(String string) {
        this.reflogComment = string;
        this.useDefaultReflogMessage = false;
        return this;
    }

    public CommitCommand setNoVerify(boolean bl2) {
        this.noVerify = bl2;
        return this;
    }

    public CommitCommand setHookOutputStream(PrintStream printStream) {
        this.setHookOutputStream("pre-commit", printStream);
        this.setHookOutputStream("commit-msg", printStream);
        this.setHookOutputStream("post-commit", printStream);
        return this;
    }

    public CommitCommand setHookErrorStream(PrintStream printStream) {
        this.setHookErrorStream("pre-commit", printStream);
        this.setHookErrorStream("commit-msg", printStream);
        this.setHookErrorStream("post-commit", printStream);
        return this;
    }

    public CommitCommand setHookOutputStream(String string, PrintStream printStream) {
        if (!("pre-commit".equals(string) || "commit-msg".equals(string) || "post-commit".equals(string))) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalHookName, string));
        }
        this.hookOutRedirect.put(string, printStream);
        return this;
    }

    public CommitCommand setHookErrorStream(String string, PrintStream printStream) {
        if (!("pre-commit".equals(string) || "commit-msg".equals(string) || "post-commit".equals(string))) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalHookName, string));
        }
        this.hookErrRedirect.put(string, printStream);
        return this;
    }

    public CommitCommand setSigningKey(String string) {
        this.checkCallable();
        this.signingKey = string;
        return this;
    }

    public CommitCommand setSign(Boolean bl2) {
        this.checkCallable();
        this.signCommit = bl2;
        return this;
    }

    public CommitCommand setGpgSigner(GpgSigner gpgSigner) {
        this.checkCallable();
        this.gpgSigner = gpgSigner;
        return this;
    }

    public CommitCommand setGpgConfig(GpgConfig gpgConfig) {
        this.checkCallable();
        this.gpgConfig = gpgConfig;
        return this;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }
}

