/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.CloneCommand$Callback;
import org.eclipse.jgit.api.CloneCommand$FETCH_TYPE;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.SubmoduleInitCommand;
import org.eclipse.jgit.api.SubmoduleUpdateCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.BranchConfig$BranchRebaseMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

public class CloneCommand
extends TransportCommand {
    private String uri;
    private File directory;
    private File gitDir;
    private boolean bare;
    private FS fs;
    private String remote = "origin";
    private String branch = "HEAD";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean cloneAllBranches;
    private boolean mirror;
    private boolean cloneSubmodules;
    private boolean noCheckout;
    private Collection branchesToClone;
    private CloneCommand$Callback callback;
    private boolean directoryExistsInitially;
    private boolean gitDirExistsInitially;
    private CloneCommand$FETCH_TYPE fetchType;
    private TagOpt tagOption;

    public CloneCommand() {
        super(null);
    }

    @Nullable
    File getDirectory() {
        return this.directory;
    }

    @Override
    public Git call() {
        URIish uRIish = null;
        try {
            uRIish = new URIish(this.uri);
            this.verifyDirectories(uRIish);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidURL, this.uri), uRISyntaxException);
        }
        this.setFetchType();
        Repository repository = this.init();
        FetchResult fetchResult = null;
        Thread thread = new Thread(() -> this.cleanup());
        try {
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            fetchResult = this.fetch(repository, uRIish);
        }
        catch (IOException iOException) {
            if (repository != null) {
                repository.close();
            }
            this.cleanup();
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            if (repository != null) {
                repository.close();
            }
            this.cleanup();
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), uRISyntaxException);
        }
        catch (RuntimeException | GitAPIException exception) {
            if (repository != null) {
                repository.close();
            }
            this.cleanup();
            throw exception;
        }
        finally {
            try {
                Runtime.getRuntime().removeShutdownHook(thread);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (!this.noCheckout) {
            try {
                this.checkout(repository, fetchResult);
            }
            catch (IOException iOException) {
                repository.close();
                throw new JGitInternalException(iOException.getMessage(), iOException);
            }
            catch (RuntimeException | GitAPIException exception) {
                repository.close();
                throw exception;
            }
        }
        return new Git(repository, true);
    }

    private void setFetchType() {
        if (this.mirror) {
            this.fetchType = CloneCommand$FETCH_TYPE.MIRROR;
            this.setBare(true);
        } else {
            this.fetchType = this.cloneAllBranches ? CloneCommand$FETCH_TYPE.ALL_BRANCHES : (this.branchesToClone != null && !this.branchesToClone.isEmpty() ? CloneCommand$FETCH_TYPE.MULTIPLE_BRANCHES : CloneCommand$FETCH_TYPE.ALL_BRANCHES);
        }
    }

    private static boolean isNonEmptyDirectory(File file) {
        if (file != null && file.exists()) {
            File[] fileArray = file.listFiles();
            return fileArray != null && fileArray.length != 0;
        }
        return false;
    }

    void verifyDirectories(URIish uRIish) {
        if (this.directory == null && this.gitDir == null) {
            this.directory = new File(uRIish.getHumanishName() + (this.bare ? ".git" : ""));
        }
        this.directoryExistsInitially = this.directory != null && this.directory.exists();
        this.gitDirExistsInitially = this.gitDir != null && this.gitDir.exists();
        CloneCommand.validateDirs(this.directory, this.gitDir, this.bare);
        if (CloneCommand.isNonEmptyDirectory(this.directory)) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cloneNonEmptyDirectory, this.directory.getName()));
        }
        if (CloneCommand.isNonEmptyDirectory(this.gitDir)) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cloneNonEmptyDirectory, this.gitDir.getName()));
        }
    }

    private Repository init() {
        InitCommand initCommand = Git.init();
        initCommand.setBare(this.bare);
        if (this.fs != null) {
            initCommand.setFs(this.fs);
        }
        if (this.directory != null) {
            initCommand.setDirectory(this.directory);
        }
        if (this.gitDir != null) {
            initCommand.setGitDir(this.gitDir);
        }
        return initCommand.call().getRepository();
    }

    private FetchResult fetch(Repository repository, URIish uRIish) {
        RemoteConfig remoteConfig = new RemoteConfig(repository.getConfig(), this.remote);
        remoteConfig.addURI(uRIish);
        boolean bl2 = this.fetchType == CloneCommand$FETCH_TYPE.ALL_BRANCHES || this.fetchType == CloneCommand$FETCH_TYPE.MIRROR;
        remoteConfig.setFetchRefSpecs(this.calculateRefSpecs(this.fetchType, remoteConfig.getName()));
        remoteConfig.setMirror(this.fetchType == CloneCommand$FETCH_TYPE.MIRROR);
        if (this.tagOption != null) {
            remoteConfig.setTagOpt(this.tagOption);
        }
        remoteConfig.update(repository.getConfig());
        repository.getConfig().save();
        FetchCommand fetchCommand = new FetchCommand(repository);
        fetchCommand.setRemote(this.remote);
        fetchCommand.setProgressMonitor(this.monitor);
        if (this.tagOption != null) {
            fetchCommand.setTagOpt(this.tagOption);
        } else {
            fetchCommand.setTagOpt(bl2 ? TagOpt.FETCH_TAGS : TagOpt.AUTO_FOLLOW);
        }
        fetchCommand.setInitialBranch(this.branch);
        this.configure(fetchCommand);
        return fetchCommand.call();
    }

    private List calculateRefSpecs(CloneCommand$FETCH_TYPE cloneCommand$FETCH_TYPE, String string) {
        ArrayList<RefSpec> arrayList = new ArrayList<RefSpec>();
        if (cloneCommand$FETCH_TYPE == CloneCommand$FETCH_TYPE.MIRROR) {
            arrayList.add(new RefSpec().setForceUpdate(true).setSourceDestination("refs/*", "refs/*"));
        } else {
            RefSpec refSpec = new RefSpec();
            refSpec = refSpec.setForceUpdate(true);
            String string2 = (this.bare ? "refs/heads/" : "refs/remotes/" + string + '/') + '*';
            refSpec = refSpec.setSourceDestination("refs/heads/*", string2);
            if (cloneCommand$FETCH_TYPE == CloneCommand$FETCH_TYPE.MULTIPLE_BRANCHES) {
                RefSpec refSpec2 = new RefSpec().setForceUpdate(true).setSourceDestination("refs/tags/*", "refs/tags/*");
                for (String string3 : this.branchesToClone) {
                    if (refSpec.matchSource(string3)) {
                        arrayList.add(refSpec.expandFromSource(string3));
                        continue;
                    }
                    if (!refSpec2.matchSource(string3)) continue;
                    arrayList.add(refSpec2.expandFromSource(string3));
                }
            } else {
                arrayList.add(refSpec);
            }
        }
        return arrayList;
    }

    private void checkout(Repository repository, FetchResult fetchResult) {
        Object object;
        Ref ref = null;
        if (this.branch.equals("HEAD") && (object = this.findBranchToCheckout(fetchResult)) != null) {
            ref = object;
        }
        if (ref == null) {
            ref = fetchResult.getAdvertisedRef(this.branch);
            if (ref == null) {
                ref = fetchResult.getAdvertisedRef("refs/heads/" + this.branch);
            }
            if (ref == null) {
                ref = fetchResult.getAdvertisedRef("refs/tags/" + this.branch);
            }
        }
        if (ref == null || ref.getObjectId() == null) {
            return;
        }
        if (ref.getName().startsWith("refs/heads/")) {
            object = repository.updateRef("HEAD");
            ((RefUpdate)object).disableRefLog();
            ((RefUpdate)object).link(ref.getName());
            this.addMergeConfig(repository, ref);
        }
        object = this.parseCommit(repository, ref);
        boolean bl2 = !ref.getName().startsWith("refs/heads/");
        RefUpdate refUpdate = repository.updateRef("HEAD", bl2);
        refUpdate.setNewObjectId(((RevObject)object).getId());
        refUpdate.forceUpdate();
        if (!this.bare) {
            DirCache dirCache = repository.lockDirCache();
            DirCacheCheckout dirCacheCheckout = new DirCacheCheckout(repository, dirCache, ((RevCommit)object).getTree());
            dirCacheCheckout.setProgressMonitor(this.monitor);
            dirCacheCheckout.checkout();
            if (this.cloneSubmodules) {
                this.cloneSubmodules(repository);
            }
        }
    }

    private void cloneSubmodules(Repository repository) {
        SubmoduleInitCommand submoduleInitCommand = new SubmoduleInitCommand(repository);
        Collection collection = submoduleInitCommand.call();
        if (collection.isEmpty()) {
            return;
        }
        if (this.callback != null) {
            this.callback.initializedSubmodules(collection);
        }
        SubmoduleUpdateCommand submoduleUpdateCommand = new SubmoduleUpdateCommand(repository);
        this.configure(submoduleUpdateCommand);
        submoduleUpdateCommand.setProgressMonitor(this.monitor);
        submoduleUpdateCommand.setCallback(this.callback);
        if (!submoduleUpdateCommand.call().isEmpty()) {
            SubmoduleWalk submoduleWalk = SubmoduleWalk.forIndex(repository);
            while (submoduleWalk.next()) {
                Repository repository2 = submoduleWalk.getRepository();
                Throwable throwable = null;
                try {
                    if (repository2 == null) continue;
                    this.cloneSubmodules(repository2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (repository2 == null) continue;
                    if (throwable != null) {
                        try {
                            repository2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    repository2.close();
                }
            }
        }
    }

    private Ref findBranchToCheckout(FetchResult fetchResult) {
        ObjectId objectId;
        ObjectId objectId2;
        Ref ref = fetchResult.getAdvertisedRef("HEAD");
        ObjectId objectId3 = objectId2 = ref != null ? ref.getObjectId() : null;
        if (objectId2 == null) {
            return null;
        }
        if (ref != null && ref.isSymbolic()) {
            return ref.getTarget();
        }
        Ref ref2 = fetchResult.getAdvertisedRef("refs/heads/master");
        ObjectId objectId4 = objectId = ref2 != null ? ref2.getObjectId() : null;
        if (objectId2.equals(objectId)) {
            return ref2;
        }
        Ref ref3 = null;
        for (Ref ref4 : fetchResult.getAdvertisedRefs()) {
            String string = ref4.getName();
            if (!string.startsWith("refs/heads/") || !objectId2.equals(ref4.getObjectId())) continue;
            ref3 = ref4;
            break;
        }
        return ref3;
    }

    private void addMergeConfig(Repository repository, Ref ref) {
        String string = Repository.shortenRefName(ref.getName());
        repository.getConfig().setString("branch", string, "remote", this.remote);
        repository.getConfig().setString("branch", string, "merge", ref.getName());
        String string2 = repository.getConfig().getString("branch", null, "autosetuprebase");
        if ("always".equals(string2) || "remote".equals(string2)) {
            repository.getConfig().setEnum("branch", string, "rebase", BranchConfig$BranchRebaseMode.REBASE);
        }
        repository.getConfig().save();
    }

    private RevCommit parseCommit(Repository repository, Ref ref) {
        RevCommit revCommit;
        try (RevWalk revWalk = new RevWalk(repository);){
            revCommit = revWalk.parseCommit(ref.getObjectId());
        }
        return revCommit;
    }

    public CloneCommand setURI(String string) {
        this.uri = string;
        return this;
    }

    public CloneCommand setDirectory(File file) {
        CloneCommand.validateDirs(file, this.gitDir, this.bare);
        this.directory = file;
        return this;
    }

    public CloneCommand setGitDir(File file) {
        CloneCommand.validateDirs(this.directory, file, this.bare);
        this.gitDir = file;
        return this;
    }

    public CloneCommand setBare(boolean bl2) {
        CloneCommand.validateDirs(this.directory, this.gitDir, bl2);
        this.bare = bl2;
        return this;
    }

    public CloneCommand setFs(FS fS) {
        this.fs = fS;
        return this;
    }

    public CloneCommand setRemote(String string) {
        if (string == null) {
            string = "origin";
        }
        this.remote = string;
        return this;
    }

    public CloneCommand setBranch(String string) {
        if (string == null) {
            string = "HEAD";
        }
        this.branch = string;
        return this;
    }

    public CloneCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }

    public CloneCommand setCloneAllBranches(boolean bl2) {
        this.cloneAllBranches = bl2;
        return this;
    }

    public CloneCommand setMirror(boolean bl2) {
        this.mirror = bl2;
        return this;
    }

    public CloneCommand setCloneSubmodules(boolean bl2) {
        this.cloneSubmodules = bl2;
        return this;
    }

    public CloneCommand setBranchesToClone(Collection collection) {
        this.branchesToClone = collection;
        return this;
    }

    public CloneCommand setTagOption(TagOpt tagOpt) {
        this.tagOption = tagOpt;
        return this;
    }

    public CloneCommand setNoTags() {
        return this.setTagOption(TagOpt.NO_TAGS);
    }

    public CloneCommand setNoCheckout(boolean bl2) {
        this.noCheckout = bl2;
        return this;
    }

    public CloneCommand setCallback(CloneCommand$Callback cloneCommand$Callback) {
        this.callback = cloneCommand$Callback;
        return this;
    }

    private static void validateDirs(File file, File file2, boolean bl2) {
        if (file != null) {
            if (file.exists() && !file.isDirectory()) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedDirIsNoDirectory, file));
            }
            if (file2 != null && file2.exists() && !file2.isDirectory()) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedGitDirIsNoDirectory, file2));
            }
            if (bl2) {
                if (file2 != null && !file2.equals(file)) {
                    throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedBareRepoDifferentDirs, file2, file));
                }
            } else if (file2 != null && file2.equals(file)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedNonBareRepoSameDirs, file2, file));
            }
        }
    }

    private void cleanup() {
        try {
            if (this.directory != null) {
                if (!this.directoryExistsInitially) {
                    FileUtils.delete(this.directory, 13);
                } else {
                    this.deleteChildren(this.directory);
                }
            }
            if (this.gitDir != null) {
                if (!this.gitDirExistsInitially) {
                    FileUtils.delete(this.gitDir, 13);
                } else {
                    this.deleteChildren(this.gitDir);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deleteChildren(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            FileUtils.delete(file2, 13);
        }
    }
}

