/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

public class CleanCommand
extends GitCommand {
    private Set paths = Collections.emptySet();
    private boolean dryRun;
    private boolean directories;
    private boolean ignore = true;
    private boolean force = false;

    protected CleanCommand(Repository repository) {
        super(repository);
    }

    @Override
    public Set call() {
        Set set = new TreeSet();
        try {
            String string;
            Object object;
            Object object22;
            StatusCommand statusCommand = new StatusCommand(this.repo);
            Status status = statusCommand.call();
            TreeSet<Object> treeSet = new TreeSet<Object>(status.getUntracked());
            TreeSet<Object> treeSet2 = new TreeSet<Object>(status.getUntrackedFolders());
            FS fS = this.getRepository().getFS();
            for (Object object22 : status.getIgnoredNotInIndex()) {
                object = new File(this.repo.getWorkTree(), (String)object22);
                if (fS.isFile((File)object) || fS.isSymLink((File)object)) {
                    treeSet.add(object22);
                    continue;
                }
                if (!fS.isDirectory((File)object)) continue;
                treeSet2.add(object22);
            }
            Set set2 = this.filterFolders(treeSet, treeSet2);
            object22 = this.filterIgnorePaths(set2, status.getIgnoredNotInIndex(), true);
            object = this.filterIgnorePaths(treeSet2, status.getIgnoredNotInIndex(), false);
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (!this.paths.isEmpty() && !this.paths.contains(string)) continue;
                set = this.cleanPath(string, set);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (!this.paths.isEmpty() && !this.paths.contains(string)) continue;
                set = this.cleanPath(string, set);
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        finally {
            if (!this.dryRun && !set.isEmpty()) {
                this.repo.fireEvent(new WorkingTreeModifiedEvent(null, set));
            }
        }
        return set;
    }

    private Set cleanPath(String string, Set set) {
        File file = new File(this.repo.getWorkTree(), string);
        if (file.isDirectory()) {
            if (this.directories) {
                if (new File(file, ".git").exists()) {
                    if (this.force) {
                        if (!this.dryRun) {
                            FileUtils.delete(file, 5);
                        }
                        set.add(string + "/");
                    }
                } else {
                    if (!this.dryRun) {
                        FileUtils.delete(file, 5);
                    }
                    set.add(string + "/");
                }
            }
        } else {
            if (!this.dryRun) {
                FileUtils.delete(file, 4);
            }
            set.add(string);
        }
        return set;
    }

    private Set filterIgnorePaths(Set set, Set set2, boolean bl2) {
        if (this.ignore) {
            TreeSet treeSet = new TreeSet(set);
            block0: for (String string : set) {
                for (String string2 : set2) {
                    if ((!bl2 || !string.equals(string2)) && (bl2 || !string.startsWith(string2))) continue;
                    treeSet.remove(string);
                    continue block0;
                }
            }
            return treeSet;
        }
        return set;
    }

    private Set filterFolders(Set set, Set set2) {
        TreeSet treeSet = new TreeSet(set);
        block0: for (String string : set) {
            for (String string2 : set2) {
                if (!string.startsWith(string2)) continue;
                treeSet.remove(string);
                continue block0;
            }
        }
        return treeSet;
    }

    public CleanCommand setPaths(Set set) {
        this.paths = set;
        return this;
    }

    public CleanCommand setDryRun(boolean bl2) {
        this.dryRun = bl2;
        return this;
    }

    public CleanCommand setForce(boolean bl2) {
        this.force = bl2;
        return this;
    }

    public CleanCommand setCleanDirectories(boolean bl2) {
        this.directories = bl2;
        return this;
    }

    public CleanCommand setIgnore(boolean bl2) {
        this.ignore = bl2;
        return this;
    }
}

