/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;

public class CherryPickCommand
extends GitCommand {
    private String reflogPrefix = "cherry-pick:";
    private List commits = new LinkedList();
    private String ourCommitName = null;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;
    private Integer mainlineParentNumber;
    private boolean noCommit = false;
    private boolean preserveCommitter = false;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected CherryPickCommand(Repository repository) {
        super(repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CherryPickResult call() {
        RevCommit revCommit = null;
        LinkedList<Ref> linkedList = new LinkedList<Ref>();
        this.checkCallable();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Object object;
            Object object2;
            List list;
            Map map;
            RevCommit revCommit2;
            block42: {
                Ref ref = this.repo.exactRef("HEAD");
                if (ref == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                revCommit = revWalk.parseCommit(ref.getObjectId());
                Iterator iterator = this.commits.iterator();
                while (iterator.hasNext()) {
                    boolean bl2;
                    Ref ref2 = (Ref)iterator.next();
                    ObjectId objectId = ref2.getPeeledObjectId();
                    if (objectId == null) {
                        objectId = ref2.getObjectId();
                    }
                    revCommit2 = revWalk.parseCommit(objectId);
                    RevCommit revCommit3 = this.getParentCommit(revCommit2, revWalk);
                    String string = this.calculateOurName(ref);
                    String string2 = revCommit2.getId().abbreviate(7).name() + " " + revCommit2.getShortMessage();
                    Merger merger = this.strategy.newMerger(this.repo);
                    merger.setProgressMonitor(this.monitor);
                    map = null;
                    list = null;
                    if (merger instanceof ResolveMerger) {
                        object2 = (ResolveMerger)merger;
                        ((ResolveMerger)object2).setContentMergeStrategy(this.contentStrategy);
                        ((ResolveMerger)object2).setCommitNames(new String[]{"BASE", string, string2});
                        ((ResolveMerger)object2).setWorkingTreeIterator(new FileTreeIterator(this.repo));
                        ((ThreeWayMerger)object2).setBase(revCommit3.getTree());
                        bl2 = merger.merge(revCommit, revCommit2);
                        map = ((ResolveMerger)object2).getFailingPaths();
                        list = ((ResolveMerger)object2).getUnmergedPaths();
                        if (!((ResolveMerger)object2).getModifiedFiles().isEmpty()) {
                            this.repo.fireEvent(new WorkingTreeModifiedEvent(((ResolveMerger)object2).getModifiedFiles(), null));
                        }
                    } else {
                        bl2 = merger.merge(revCommit, revCommit2);
                    }
                    if (!bl2) break block42;
                    if (AnyObjectId.isEqual(revCommit.getTree().getId(), merger.getResultTreeId())) continue;
                    object2 = new DirCacheCheckout(this.repo, revCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                    ((DirCacheCheckout)object2).setFailOnConflict(true);
                    ((DirCacheCheckout)object2).setProgressMonitor(this.monitor);
                    ((DirCacheCheckout)object2).checkout();
                    if (!this.noCommit) {
                        object = new Git(this.getRepository());
                        Throwable throwable = null;
                        try {
                            CommitCommand commitCommand = ((Git)object).commit().setMessage(revCommit2.getFullMessage()).setReflogComment(this.reflogPrefix + " " + revCommit2.getShortMessage()).setAuthor(revCommit2.getAuthorIdent()).setNoVerify(true);
                            if (this.preserveCommitter) {
                                commitCommand.setCommitter(revCommit2.getCommitterIdent());
                            }
                            revCommit = commitCommand.call();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (object != null) {
                                if (throwable != null) {
                                    try {
                                        ((Git)object).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((Git)object).close();
                                }
                            }
                        }
                    }
                    linkedList.add(ref2);
                }
                return new CherryPickResult(revCommit, linkedList);
            }
            if (map != null && !map.isEmpty()) {
                object2 = new CherryPickResult(map);
                return object2;
            }
            object2 = list != null ? new MergeMessageFormatter().formatWithConflicts(revCommit2.getFullMessage(), list) : revCommit2.getFullMessage();
            if (!this.noCommit) {
                this.repo.writeCherryPickHead(revCommit2.getId());
            }
            this.repo.writeMergeCommitMsg((String)object2);
            object = CherryPickResult.CONFLICT;
            return object;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, iOException), iOException);
        }
    }

    private RevCommit getParentCommit(RevCommit revCommit, RevWalk revWalk) {
        RevCommit revCommit2;
        if (this.mainlineParentNumber == null) {
            if (revCommit.getParentCount() != 1) {
                throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyCherryPickCommitsWithOneParent, revCommit.name(), revCommit.getParentCount()));
            }
            revCommit2 = revCommit.getParent(0);
        } else {
            if (this.mainlineParentNumber > revCommit.getParentCount()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().commitDoesNotHaveGivenParent, revCommit, this.mainlineParentNumber));
            }
            revCommit2 = revCommit.getParent(this.mainlineParentNumber - 1);
        }
        revWalk.parseHeaders(revCommit2);
        return revCommit2;
    }

    public CherryPickCommand include(Ref ref) {
        this.checkCallable();
        this.commits.add(ref);
        return this;
    }

    public CherryPickCommand include(AnyObjectId anyObjectId) {
        return this.include(anyObjectId.getName(), anyObjectId);
    }

    public CherryPickCommand include(String string, AnyObjectId anyObjectId) {
        return this.include(new ObjectIdRef$Unpeeled(Ref$Storage.LOOSE, string, anyObjectId.copy()));
    }

    public CherryPickCommand setOurCommitName(String string) {
        this.ourCommitName = string;
        return this;
    }

    public CherryPickCommand setReflogPrefix(String string) {
        this.reflogPrefix = string;
        return this;
    }

    public CherryPickCommand setStrategy(MergeStrategy mergeStrategy) {
        this.strategy = mergeStrategy;
        return this;
    }

    public CherryPickCommand setContentMergeStrategy(ContentMergeStrategy contentMergeStrategy) {
        this.contentStrategy = contentMergeStrategy;
        return this;
    }

    public CherryPickCommand setMainlineParentNumber(int n2) {
        this.mainlineParentNumber = n2;
        return this;
    }

    public CherryPickCommand setNoCommit(boolean bl2) {
        this.noCommit = bl2;
        return this;
    }

    public CherryPickCommand setPreserveCommitter(boolean bl2) {
        this.preserveCommitter = bl2;
        return this;
    }

    public CherryPickCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }

    private String calculateOurName(Ref ref) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String string = ref.getTarget().getName();
        String string2 = Repository.shortenRefName(string);
        return string2;
    }

    public String toString() {
        return "CherryPickCommand [repo=" + this.repo + ",\ncommits=" + this.commits + ",\nmainlineParentNumber=" + this.mainlineParentNumber + ", noCommit=" + this.noCommit + ", ourCommitName=" + this.ourCommitName + ", reflogPrefix=" + this.reflogPrefix + ", strategy=" + this.strategy + "]";
    }
}

