/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.CheckoutCommand$1;
import org.eclipse.jgit.api.CheckoutCommand$2;
import org.eclipse.jgit.api.CheckoutCommand$Stage;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.CheckoutResult$Status;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.CreateBranchCommand$SetupUpstreamMode;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.dircache.Checkout;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheCheckout$CheckoutMetadata;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig$EolStreamType;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class CheckoutCommand
extends GitCommand {
    private String name;
    private boolean forceRefUpdate = false;
    private boolean forced = false;
    private boolean createBranch = false;
    private boolean orphan = false;
    private CreateBranchCommand$SetupUpstreamMode upstreamMode;
    private String startPoint = null;
    private RevCommit startCommit;
    private CheckoutCommand$Stage checkoutStage = null;
    private CheckoutResult status;
    private List paths;
    private boolean checkoutAllPaths;
    private Set actuallyModifiedPaths;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected CheckoutCommand(Repository repository) {
        super(repository);
        this.paths = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref call() {
        this.checkCallable();
        try {
            RefUpdate$Result refUpdate$Result;
            Object object;
            ObjectId objectId;
            Object object2;
            Object object3;
            Object object4;
            this.processOptions();
            if (this.checkoutAllPaths || !this.paths.isEmpty()) {
                this.checkoutPaths();
                this.status = new CheckoutResult(CheckoutResult$Status.OK, this.paths);
                this.setCallable(false);
                Ref ref = null;
                return ref;
            }
            if (this.createBranch) {
                object4 = new Git(this.repo);
                object3 = null;
                try {
                    object2 = ((Git)object4).branchCreate();
                    ((CreateBranchCommand)object2).setName(this.name);
                    if (this.startCommit != null) {
                        ((CreateBranchCommand)object2).setStartPoint(this.startCommit);
                    } else {
                        ((CreateBranchCommand)object2).setStartPoint(this.startPoint);
                    }
                    if (this.upstreamMode != null) {
                        ((CreateBranchCommand)object2).setUpstreamMode(this.upstreamMode);
                    }
                    ((CreateBranchCommand)object2).call();
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (object4 != null) {
                        if (object3 != null) {
                            try {
                                ((Git)object4).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            ((Git)object4).close();
                        }
                    }
                }
            }
            if ((object4 = this.repo.exactRef("HEAD")) == null) {
                throw new UnsupportedOperationException(JGitText.get().cannotCheckoutFromUnbornBranch);
            }
            object3 = this.getShortBranchName((Ref)object4);
            object2 = "checkout: moving from " + (String)object3;
            if (this.orphan) {
                if (this.startPoint == null && this.startCommit == null) {
                    RefUpdate$Result refUpdate$Result2 = this.repo.updateRef("HEAD").link(this.getBranchName());
                    if (!EnumSet.of(RefUpdate$Result.NEW, RefUpdate$Result.FORCED).contains((Object)refUpdate$Result2)) {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, refUpdate$Result2.name()));
                    }
                    this.status = CheckoutResult.NOT_TRIED_RESULT;
                    Ref ref = this.repo.exactRef("HEAD");
                    return ref;
                }
                objectId = this.getStartPointObjectId();
            } else {
                objectId = this.repo.resolve(this.name);
                if (objectId == null) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.name));
                }
            }
            RevCommit revCommit = null;
            RevCommit revCommit2 = null;
            Object object5 = new RevWalk(this.repo);
            Object object6 = null;
            try {
                object = object4.getObjectId();
                revCommit = object == null ? null : ((RevWalk)object5).parseCommit((AnyObjectId)object);
                revCommit2 = ((RevWalk)object5).parseCommit(objectId);
            }
            catch (Throwable throwable) {
                object6 = throwable;
                throw throwable;
            }
            finally {
                if (object5 != null) {
                    if (object6 != null) {
                        try {
                            ((RevWalk)object5).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object6).addSuppressed(throwable);
                        }
                    } else {
                        ((RevWalk)object5).close();
                    }
                }
            }
            object5 = revCommit == null ? null : revCommit.getTree();
            object = this.repo.lockDirCache();
            try {
                object6 = new DirCacheCheckout(this.repo, (ObjectId)object5, (DirCache)object, revCommit2.getTree());
                ((DirCacheCheckout)object6).setFailOnConflict(true);
                ((DirCacheCheckout)object6).setForce(this.forced);
                if (this.forced) {
                    ((DirCacheCheckout)object6).setFailOnConflict(false);
                }
                ((DirCacheCheckout)object6).setProgressMonitor(this.monitor);
                try {
                    ((DirCacheCheckout)object6).checkout();
                }
                catch (org.eclipse.jgit.errors.CheckoutConflictException checkoutConflictException) {
                    this.status = new CheckoutResult(CheckoutResult$Status.CONFLICTS, ((DirCacheCheckout)object6).getConflicts());
                    throw new CheckoutConflictException(((DirCacheCheckout)object6).getConflicts(), checkoutConflictException);
                }
            }
            finally {
                ((DirCache)object).unlock();
            }
            Ref ref = this.repo.findRef(this.name);
            if (ref != null && !ref.getName().startsWith("refs/heads/")) {
                ref = null;
            }
            String string = Repository.shortenRefName(this.name);
            RefUpdate refUpdate = this.repo.updateRef("HEAD", ref == null);
            refUpdate.setForceUpdate(this.forceRefUpdate);
            refUpdate.setRefLogMessage((String)object2 + " to " + string, false);
            if (ref != null) {
                refUpdate$Result = refUpdate.link(ref.getName());
            } else if (this.orphan) {
                refUpdate$Result = refUpdate.link(this.getBranchName());
                ref = this.repo.exactRef("HEAD");
            } else {
                refUpdate.setNewObjectId(revCommit2);
                refUpdate$Result = refUpdate.forceUpdate();
            }
            this.setCallable(false);
            boolean bl2 = false;
            switch (refUpdate$Result) {
                case NEW: {
                    bl2 = true;
                    break;
                }
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, refUpdate$Result.name()));
            }
            this.status = !((DirCacheCheckout)object6).getToBeDeleted().isEmpty() ? new CheckoutResult(CheckoutResult$Status.NONDELETED, ((DirCacheCheckout)object6).getToBeDeleted(), new ArrayList(((DirCacheCheckout)object6).getUpdated().keySet()), ((DirCacheCheckout)object6).getRemoved()) : new CheckoutResult(new ArrayList(((DirCacheCheckout)object6).getUpdated().keySet()), ((DirCacheCheckout)object6).getRemoved());
            Ref ref2 = ref;
            return ref2;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        finally {
            if (this.status == null) {
                this.status = CheckoutResult.ERROR_RESULT;
            }
        }
    }

    private String getShortBranchName(Ref ref) {
        if (ref.isSymbolic()) {
            return Repository.shortenRefName(ref.getTarget().getName());
        }
        ObjectId objectId = ref.getObjectId();
        if (objectId == null) {
            throw new NullPointerException();
        }
        return objectId.getName();
    }

    public CheckoutCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = progressMonitor;
        return this;
    }

    public CheckoutCommand addPath(String string) {
        this.checkCallable();
        this.paths.add(string);
        return this;
    }

    public CheckoutCommand addPaths(List list) {
        this.checkCallable();
        this.paths.addAll(list);
        return this;
    }

    public CheckoutCommand setAllPaths(boolean bl2) {
        this.checkoutAllPaths = bl2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckoutCommand checkoutPaths() {
        Object object;
        this.actuallyModifiedPaths = new HashSet();
        Checkout checkout = new Checkout(this.repo).setRecursiveDeletion(true);
        DirCache dirCache = this.repo.lockDirCache();
        try {
            object = new RevWalk(this.repo);
            Throwable throwable = null;
            try (TreeWalk treeWalk = new TreeWalk(this.repo, ((RevWalk)object).getObjectReader());){
                treeWalk.setRecursive(true);
                if (!this.checkoutAllPaths) {
                    treeWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                if (this.isCheckoutIndex()) {
                    this.checkoutPathsFromIndex(treeWalk, dirCache, checkout);
                } else {
                    RevCommit revCommit = ((RevWalk)object).parseCommit(this.getStartPointObjectId());
                    this.checkoutPathsFromCommit(treeWalk, dirCache, revCommit, checkout);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((RevWalk)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((RevWalk)object).close();
                    }
                }
            }
        }
        finally {
            try {
                dirCache.unlock();
            }
            finally {
                object = new WorkingTreeModifiedEvent(this.actuallyModifiedPaths, null);
                this.actuallyModifiedPaths = null;
                if (!((WorkingTreeModifiedEvent)object).isEmpty()) {
                    this.repo.fireEvent((RepositoryEvent)object);
                }
            }
        }
        return this;
    }

    private void checkoutPathsFromIndex(TreeWalk treeWalk, DirCache dirCache, Checkout checkout) {
        DirCacheIterator dirCacheIterator = new DirCacheIterator(dirCache);
        treeWalk.addTree(dirCacheIterator);
        String string = null;
        ObjectReader objectReader = treeWalk.getObjectReader();
        DirCacheEditor dirCacheEditor = dirCache.editor();
        while (treeWalk.next()) {
            String string2 = treeWalk.getPathString();
            if (string2.equals(string)) continue;
            CoreConfig$EolStreamType coreConfig$EolStreamType = treeWalk.getEolStreamType(TreeWalk$OperationType.CHECKOUT_OP);
            String string3 = treeWalk.getFilterCommand("smudge");
            dirCacheEditor.add(new CheckoutCommand$1(this, string2, objectReader, checkout, string2, coreConfig$EolStreamType, string3));
            string = string2;
        }
        dirCacheEditor.commit();
    }

    private void checkoutPathsFromCommit(TreeWalk treeWalk, DirCache dirCache, RevCommit revCommit, Checkout checkout) {
        treeWalk.addTree(revCommit.getTree());
        ObjectReader objectReader = treeWalk.getObjectReader();
        DirCacheEditor dirCacheEditor = dirCache.editor();
        while (treeWalk.next()) {
            ObjectId objectId = treeWalk.getObjectId(0);
            FileMode fileMode = treeWalk.getFileMode(0);
            CoreConfig$EolStreamType coreConfig$EolStreamType = treeWalk.getEolStreamType(TreeWalk$OperationType.CHECKOUT_OP);
            String string = treeWalk.getFilterCommand("smudge");
            String string2 = treeWalk.getPathString();
            dirCacheEditor.add(new CheckoutCommand$2(this, string2, objectId, fileMode, objectReader, checkout, string2, coreConfig$EolStreamType, string));
        }
        dirCacheEditor.commit();
    }

    private void checkoutPath(DirCacheEntry dirCacheEntry, ObjectReader objectReader, Checkout checkout, String string, DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata) {
        try {
            checkout.checkout(dirCacheEntry, dirCacheCheckout$CheckoutMetadata, objectReader, string);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, dirCacheEntry.getPathString()), iOException);
        }
    }

    private boolean isCheckoutIndex() {
        return this.startCommit == null && this.startPoint == null;
    }

    private ObjectId getStartPointObjectId() {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        String string = this.startPoint != null ? this.startPoint : "HEAD";
        ObjectId objectId = this.repo.resolve(string);
        if (objectId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, string));
        }
        return objectId;
    }

    private void processOptions() {
        Ref ref;
        if ((!this.checkoutAllPaths && this.paths.isEmpty() || this.orphan) && (this.name == null || !Repository.isValidRefName("refs/heads/" + this.name))) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (this.orphan && (ref = this.repo.exactRef(this.getBranchName())) != null) {
            throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists, this.name));
        }
    }

    private String getBranchName() {
        if (this.name.startsWith("refs/")) {
            return this.name;
        }
        return "refs/heads/" + this.name;
    }

    public CheckoutCommand setName(String string) {
        this.checkCallable();
        this.name = string;
        return this;
    }

    public CheckoutCommand setCreateBranch(boolean bl2) {
        this.checkCallable();
        this.createBranch = bl2;
        return this;
    }

    public CheckoutCommand setOrphan(boolean bl2) {
        this.checkCallable();
        this.orphan = bl2;
        return this;
    }

    @Deprecated
    public CheckoutCommand setForce(boolean bl2) {
        return this.setForceRefUpdate(bl2);
    }

    public CheckoutCommand setForceRefUpdate(boolean bl2) {
        this.checkCallable();
        this.forceRefUpdate = bl2;
        return this;
    }

    public CheckoutCommand setForced(boolean bl2) {
        this.checkCallable();
        this.forced = bl2;
        return this;
    }

    public CheckoutCommand setStartPoint(String string) {
        this.checkCallable();
        this.startPoint = string;
        this.startCommit = null;
        this.checkOptions();
        return this;
    }

    public CheckoutCommand setStartPoint(RevCommit revCommit) {
        this.checkCallable();
        this.startCommit = revCommit;
        this.startPoint = null;
        this.checkOptions();
        return this;
    }

    public CheckoutCommand setUpstreamMode(CreateBranchCommand$SetupUpstreamMode createBranchCommand$SetupUpstreamMode) {
        this.checkCallable();
        this.upstreamMode = createBranchCommand$SetupUpstreamMode;
        return this;
    }

    public CheckoutCommand setStage(CheckoutCommand$Stage checkoutCommand$Stage) {
        this.checkCallable();
        this.checkoutStage = checkoutCommand$Stage;
        this.checkOptions();
        return this;
    }

    public CheckoutResult getResult() {
        if (this.status == null) {
            return CheckoutResult.NOT_TRIED_RESULT;
        }
        return this.status;
    }

    private void checkOptions() {
        if (this.checkoutStage != null && !this.isCheckoutIndex()) {
            throw new IllegalStateException(JGitText.get().cannotCheckoutOursSwitchBranch);
        }
    }

    static /* synthetic */ CheckoutCommand$Stage access$000(CheckoutCommand checkoutCommand) {
        return checkoutCommand.checkoutStage;
    }

    static /* synthetic */ void access$200(CheckoutCommand checkoutCommand, DirCacheEntry dirCacheEntry, ObjectReader objectReader, Checkout checkout, String string, DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata) {
        checkoutCommand.checkoutPath(dirCacheEntry, objectReader, checkout, string, dirCacheCheckout$CheckoutMetadata);
    }

    static /* synthetic */ Set access$300(CheckoutCommand checkoutCommand) {
        return checkoutCommand.actuallyModifiedPaths;
    }
}

