/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public class BlameCommand
extends GitCommand {
    private String path;
    private DiffAlgorithm diffAlgorithm;
    private RawTextComparator textComparator;
    private ObjectId startCommit;
    private Collection reverseEndCommits;
    private Boolean followFileRenames;

    public BlameCommand(Repository repository) {
        super(repository);
    }

    public BlameCommand setFilePath(String string) {
        this.path = string;
        return this;
    }

    public BlameCommand setDiffAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
        return this;
    }

    public BlameCommand setTextComparator(RawTextComparator rawTextComparator) {
        this.textComparator = rawTextComparator;
        return this;
    }

    public BlameCommand setStartCommit(AnyObjectId anyObjectId) {
        this.startCommit = anyObjectId.toObjectId();
        return this;
    }

    public BlameCommand setFollowFileRenames(boolean bl2) {
        this.followFileRenames = bl2;
        return this;
    }

    public BlameCommand reverse(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        return this.reverse(anyObjectId, Collections.singleton(anyObjectId2.toObjectId()));
    }

    public BlameCommand reverse(AnyObjectId anyObjectId, Collection collection) {
        this.startCommit = anyObjectId.toObjectId();
        this.reverseEndCommits = new ArrayList(collection);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BlameResult call() {
        this.checkCallable();
        try (BlameGenerator blameGenerator = new BlameGenerator(this.repo, this.path);){
            if (this.diffAlgorithm != null) {
                blameGenerator.setDiffAlgorithm(this.diffAlgorithm);
            }
            if (this.textComparator != null) {
                blameGenerator.setTextComparator(this.textComparator);
            }
            if (this.followFileRenames != null) {
                blameGenerator.setFollowFileRenames(this.followFileRenames);
            }
            if (this.reverseEndCommits != null) {
                blameGenerator.reverse((AnyObjectId)this.startCommit, this.reverseEndCommits);
            } else if (this.startCommit != null) {
                blameGenerator.push(null, this.startCommit);
            } else {
                blameGenerator.prepareHead();
            }
            BlameResult blameResult = blameGenerator.computeBlameResult();
            return blameResult;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
    }
}

