/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.api.ArchiveCommand$Format;
import org.eclipse.jgit.api.ArchiveCommand$FormatEntry;
import org.eclipse.jgit.api.ArchiveCommand$UnsupportedFormatException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;

public class ArchiveCommand
extends GitCommand {
    private static final Map formats = new ConcurrentHashMap();
    private OutputStream out;
    private ObjectId tree;
    private String prefix;
    private String format;
    private Map formatOptions = new HashMap();
    private List paths = new ArrayList();
    private String suffix;

    private static boolean replace(Map map, Object object, Object object2, Object object3) {
        if (object2 == null && object3 == null) {
            return true;
        }
        if (object2 == null) {
            return map.putIfAbsent(object, object3) == null;
        }
        if (object3 == null) {
            return map.remove(object, object2);
        }
        return map.replace(object, object2, object3);
    }

    public static void registerFormat(String string, ArchiveCommand$Format archiveCommand$Format) {
        ArchiveCommand$FormatEntry archiveCommand$FormatEntry;
        ArchiveCommand$FormatEntry archiveCommand$FormatEntry2;
        if (archiveCommand$Format == null) {
            throw new NullPointerException();
        }
        do {
            if ((archiveCommand$FormatEntry2 = (ArchiveCommand$FormatEntry)formats.get(string)) == null) {
                archiveCommand$FormatEntry = new ArchiveCommand$FormatEntry(archiveCommand$Format, 1);
                continue;
            }
            if (!archiveCommand$FormatEntry2.format.equals(archiveCommand$Format)) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().archiveFormatAlreadyRegistered, string));
            }
            archiveCommand$FormatEntry = new ArchiveCommand$FormatEntry(archiveCommand$FormatEntry2.format, archiveCommand$FormatEntry2.refcnt + 1);
        } while (!ArchiveCommand.replace(formats, string, archiveCommand$FormatEntry2, archiveCommand$FormatEntry));
    }

    public static void unregisterFormat(String string) {
        ArchiveCommand$FormatEntry archiveCommand$FormatEntry;
        ArchiveCommand$FormatEntry archiveCommand$FormatEntry2;
        do {
            if ((archiveCommand$FormatEntry2 = (ArchiveCommand$FormatEntry)formats.get(string)) != null) continue;
            throw new JGitInternalException(MessageFormat.format(JGitText.get().archiveFormatAlreadyAbsent, string));
        } while (!ArchiveCommand.replace(formats, string, archiveCommand$FormatEntry2, archiveCommand$FormatEntry = archiveCommand$FormatEntry2.refcnt == 1 ? null : new ArchiveCommand$FormatEntry(archiveCommand$FormatEntry2.format, archiveCommand$FormatEntry2.refcnt - 1)));
    }

    private static ArchiveCommand$Format formatBySuffix(String string) {
        if (string != null) {
            for (ArchiveCommand$FormatEntry archiveCommand$FormatEntry : formats.values()) {
                ArchiveCommand$Format archiveCommand$Format = archiveCommand$FormatEntry.format;
                for (String string2 : archiveCommand$Format.suffixes()) {
                    if (!string.endsWith(string2)) continue;
                    return archiveCommand$Format;
                }
            }
        }
        return ArchiveCommand.lookupFormat("tar");
    }

    private static ArchiveCommand$Format lookupFormat(String string) {
        ArchiveCommand$FormatEntry archiveCommand$FormatEntry = (ArchiveCommand$FormatEntry)formats.get(string);
        if (archiveCommand$FormatEntry == null) {
            throw new ArchiveCommand$UnsupportedFormatException(string);
        }
        return archiveCommand$FormatEntry.format;
    }

    public ArchiveCommand(Repository repository) {
        super(repository);
        this.setCallable(false);
    }

    /*
     * Exception decompiling
     */
    private OutputStream writeArchive(ArchiveCommand$Format var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public OutputStream call() {
        this.checkCallable();
        ArchiveCommand$Format archiveCommand$Format = this.format == null ? ArchiveCommand.formatBySuffix(this.suffix) : ArchiveCommand.lookupFormat(this.format);
        return this.writeArchive(archiveCommand$Format);
    }

    public ArchiveCommand setTree(ObjectId objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        this.tree = objectId;
        this.setCallable(true);
        return this;
    }

    public ArchiveCommand setPrefix(String string) {
        this.prefix = string;
        return this;
    }

    public ArchiveCommand setFilename(String string) {
        int n2 = string.lastIndexOf(47);
        int n3 = string.indexOf(46, n2 + 1);
        this.suffix = n3 == -1 ? "" : string.substring(n3);
        return this;
    }

    public ArchiveCommand setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        return this;
    }

    public ArchiveCommand setFormat(String string) {
        this.format = string;
        return this;
    }

    public ArchiveCommand setFormatOptions(Map map) {
        this.formatOptions = map;
        return this;
    }

    public ArchiveCommand setPaths(String ... stringArray) {
        this.paths = Arrays.asList(stringArray);
        return this;
    }

    private RevTree getTree(RevObject revObject) {
        RevTree revTree;
        if (revObject instanceof RevCommit) {
            revTree = ((RevCommit)revObject).getTree();
        } else {
            if (!(revObject instanceof RevTree)) {
                throw new IncorrectObjectTypeException(this.tree.toObjectId(), "tree");
            }
            revTree = (RevTree)revObject;
        }
        return revTree;
    }
}

