/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.api.ApplyCommand$1;
import org.eclipse.jgit.api.ApplyCommand$SHA1InputStream;
import org.eclipse.jgit.api.ApplyCommand$StreamLoader;
import org.eclipse.jgit.api.ApplyCommand$StreamSupplier;
import org.eclipse.jgit.api.ApplyResult;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.api.errors.PatchApplyException;
import org.eclipse.jgit.api.errors.PatchFormatException;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.diff.DiffEntry$ChangeType;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheCheckout$CheckoutMetadata;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig$EolStreamType;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.FileModeCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.FileHeader$PatchType;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$ExecutionResult;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.TemporaryBuffer$LocalFile;
import org.eclipse.jgit.util.io.BinaryDeltaInputStream;
import org.eclipse.jgit.util.io.BinaryHunkInputStream;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.eclipse.jgit.util.sha1.SHA1;

public class ApplyCommand
extends GitCommand {
    private InputStream in;

    ApplyCommand(Repository repository) {
        super(repository);
    }

    public ApplyCommand setPatch(InputStream inputStream) {
        this.checkCallable();
        this.in = inputStream;
        return this;
    }

    @Override
    public ApplyResult call() {
        this.checkCallable();
        this.setCallable(false);
        ApplyResult applyResult = new ApplyResult();
        try {
            Patch patch = new Patch();
            try {
                patch.parse(this.in);
            }
            finally {
                this.in.close();
            }
            if (!patch.getErrors().isEmpty()) {
                throw new PatchFormatException(patch.getErrors());
            }
            Repository repository = this.getRepository();
            FileModeCache fileModeCache = new FileModeCache(this.repo);
            DirCache dirCache = repository.readDirCache();
            for (FileHeader fileHeader : patch.getFiles()) {
                DiffEntry$ChangeType diffEntry$ChangeType = fileHeader.getChangeType();
                File file = null;
                this.verifyExistence(fileHeader, new File(this.repo.getWorkTree(), fileHeader.getOldPath()), new File(this.repo.getWorkTree(), fileHeader.getNewPath()));
                switch (diffEntry$ChangeType) {
                    case ADD: {
                        file = this.getFile(fileHeader.getNewPath(), true, fileModeCache);
                        this.apply(repository, fileHeader.getNewPath(), dirCache, file, fileHeader);
                        break;
                    }
                    case MODIFY: {
                        file = this.getFile(fileHeader.getOldPath(), false, fileModeCache);
                        this.apply(repository, fileHeader.getOldPath(), dirCache, file, fileHeader);
                        break;
                    }
                    case DELETE: {
                        file = this.getFile(fileHeader.getOldPath(), false, fileModeCache);
                        if (file.delete()) break;
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().cannotDeleteFile, file));
                    }
                    case RENAME: {
                        file = this.getFile(fileHeader.getOldPath(), false, fileModeCache);
                        File file2 = this.getFile(fileHeader.getNewPath(), false, fileModeCache);
                        try {
                            fileModeCache.safeCreateParentDirectory(fileHeader.getNewPath(), file2.getParentFile(), false);
                            FileUtils.rename(file, file2, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (IOException iOException) {
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().renameFileFailed, file, file2), iOException);
                        }
                        this.apply(repository, fileHeader.getOldPath(), dirCache, file2, fileHeader);
                        break;
                    }
                    case COPY: {
                        file = this.getFile(fileHeader.getOldPath(), false, fileModeCache);
                        File file3 = this.getFile(fileHeader.getNewPath(), false, fileModeCache);
                        fileModeCache.safeCreateParentDirectory(fileHeader.getNewPath(), file3.getParentFile(), false);
                        Files.copy(file.toPath(), file3.toPath(), new CopyOption[0]);
                        this.apply(repository, fileHeader.getOldPath(), dirCache, file3, fileHeader);
                    }
                }
                applyResult.addUpdatedFile(file);
            }
        }
        catch (IOException iOException) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, iOException.getMessage()), iOException);
        }
        return applyResult;
    }

    private void verifyExistence(FileHeader fileHeader, File file, File file2) {
        boolean bl2 = Arrays.asList(DiffEntry$ChangeType.MODIFY, DiffEntry$ChangeType.DELETE, DiffEntry$ChangeType.RENAME, DiffEntry$ChangeType.COPY).contains((Object)fileHeader.getChangeType());
        boolean bl3 = Arrays.asList(DiffEntry$ChangeType.ADD, DiffEntry$ChangeType.RENAME, DiffEntry$ChangeType.COPY).contains((Object)fileHeader.getChangeType());
        if (bl2 && !this.validGitPath(fileHeader.getOldPath())) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().applyPatchSourceInvalid, fileHeader.getOldPath()));
        }
        if (bl3 && !this.validGitPath(fileHeader.getNewPath())) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().applyPatchDestInvalid, fileHeader.getNewPath()));
        }
    }

    private boolean validGitPath(String string) {
        try {
            SystemReader.getInstance().checkPath(string);
            return true;
        }
        catch (CorruptObjectException corruptObjectException) {
            return false;
        }
    }

    private File getFile(String string, boolean bl2, FileModeCache fileModeCache) {
        File file = new File(this.getRepository().getWorkTree(), string);
        if (bl2) {
            try {
                File file2 = file.getParentFile();
                fileModeCache.safeCreateParentDirectory(string, file2, false);
                FileUtils.createNewFile(file);
            }
            catch (IOException iOException) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().createNewFileFailed, file), iOException);
            }
        }
        return file;
    }

    private void apply(Repository repository, String string, DirCache dirCache, File file, FileHeader fileHeader) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        block45: {
            if (FileHeader$PatchType.BINARY.equals((Object)fileHeader.getPatchType())) {
                return;
            }
            bl2 = this.needsCrLfConversion(file, fileHeader);
            object3 = new TreeWalk(repository);
            object2 = null;
            try {
                ((TreeWalk)object3).setOperationType(TreeWalk$OperationType.CHECKIN_OP);
                object = new FileTreeIterator(repository);
                int n2 = ((TreeWalk)object3).addTree((AbstractTreeIterator)object);
                int n3 = ((TreeWalk)object3).addTree(new DirCacheIterator(dirCache));
                ((WorkingTreeIterator)object).setDirCacheIterator((TreeWalk)object3, n3);
                ((TreeWalk)object3).setFilter(AndTreeFilter.create(PathFilterGroup.createFromStrings(string), new NotIgnoredFilter(n2)));
                ((TreeWalk)object3).setRecursive(true);
                if (!((TreeWalk)object3).next()) break block45;
                CoreConfig$EolStreamType coreConfig$EolStreamType = bl2 ? CoreConfig$EolStreamType.TEXT_CRLF : ((TreeWalk)object3).getEolStreamType(TreeWalk$OperationType.CHECKOUT_OP);
                String string2 = ((TreeWalk)object3).getFilterCommand("smudge");
                DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata = new DirCacheCheckout$CheckoutMetadata(coreConfig$EolStreamType, string2);
                FileTreeIterator fileTreeIterator = (FileTreeIterator)((TreeWalk)object3).getTree(n2, FileTreeIterator.class);
                if (fileTreeIterator == null) break block45;
                if (FileHeader$PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
                    this.applyBinary(repository, string, file, fileHeader, fileTreeIterator::openEntryStream, fileTreeIterator.getEntryObjectId(), dirCacheCheckout$CheckoutMetadata);
                } else {
                    RawText rawText;
                    string2 = ((TreeWalk)object3).getFilterCommand("clean");
                    try (InputStream inputStream = this.filterClean(repository, string, new FileInputStream(file), bl2, string2);){
                        rawText = new RawText(IO.readWholeStream(inputStream, 0).array());
                    }
                    this.applyText(repository, string, rawText, file, fileHeader, dirCacheCheckout$CheckoutMetadata);
                }
                return;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object2 != null) {
                        try {
                            ((TreeWalk)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((TreeWalk)object3).close();
                    }
                }
            }
        }
        if (FileHeader$PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
            object2 = new DirCacheCheckout$CheckoutMetadata(CoreConfig$EolStreamType.DIRECT, null);
            this.applyBinary(repository, string, file, fileHeader, () -> new FileInputStream(file), null, (DirCacheCheckout$CheckoutMetadata)object2);
        } else {
            if (bl2) {
                object = EolStreamTypeUtil.wrapInputStream(new FileInputStream(file), CoreConfig$EolStreamType.TEXT_LF);
                Throwable throwable = null;
                try {
                    object3 = new RawText(IO.readWholeStream((InputStream)object, 0).array());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                }
                object2 = new DirCacheCheckout$CheckoutMetadata(CoreConfig$EolStreamType.TEXT_CRLF, null);
            } else {
                object3 = new RawText(file);
                object2 = new DirCacheCheckout$CheckoutMetadata(CoreConfig$EolStreamType.DIRECT, null);
            }
            this.applyText(repository, string, (RawText)object3, file, fileHeader, (DirCacheCheckout$CheckoutMetadata)object2);
        }
    }

    private boolean needsCrLfConversion(File file, FileHeader fileHeader) {
        if (FileHeader$PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
            return false;
        }
        if (!ApplyCommand.hasCrLf(fileHeader)) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                boolean bl2 = RawText.isCrLfText(fileInputStream);
                return bl2;
            }
        }
        return false;
    }

    private static boolean hasCrLf(FileHeader fileHeader) {
        if (FileHeader$PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
            return false;
        }
        block0: for (HunkHeader hunkHeader : fileHeader.getHunks()) {
            byte[] byArray = hunkHeader.getBuffer();
            int n2 = hunkHeader.getEndOffset();
            int n3 = hunkHeader.getStartOffset();
            while (n3 < n2) {
                char c2;
                int n4 = RawParseUtils.nextLF(byArray, n3);
                if (n4 > n2) {
                    n4 = n2;
                }
                if (n4 <= n3) continue block0;
                if (n4 - n3 > 1 && ((c2 = (char)(byArray[n3] & 0xFF)) == ' ' || c2 == '-') && byArray[n4 - 2] == 13) {
                    return true;
                }
                n3 = n4;
            }
        }
        return false;
    }

    private InputStream filterClean(Repository repository, String string, InputStream inputStream, boolean bl2, String string2) {
        FS$ExecutionResult fS$ExecutionResult;
        InputStream inputStream2 = inputStream;
        if (bl2) {
            inputStream2 = EolStreamTypeUtil.wrapInputStream(inputStream2, CoreConfig$EolStreamType.TEXT_LF);
        }
        if (StringUtils.isEmptyOrNull(string2)) {
            return inputStream2;
        }
        if (FilterCommandRegistry.isRegistered(string2)) {
            TemporaryBuffer$LocalFile temporaryBuffer$LocalFile = new TemporaryBuffer$LocalFile(null);
            FilterCommand filterCommand = FilterCommandRegistry.createFilterCommand(string2, repository, inputStream2, temporaryBuffer$LocalFile);
            while (filterCommand.run() != -1) {
            }
            return temporaryBuffer$LocalFile.openInputStreamWithAutoDestroy();
        }
        FS fS = repository.getFS();
        ProcessBuilder processBuilder = fS.runInShell(string2, new String[0]);
        processBuilder.directory(repository.getWorkTree());
        processBuilder.environment().put("GIT_DIR", repository.getDirectory().getAbsolutePath());
        try {
            fS$ExecutionResult = fS.execute(processBuilder, this.in);
        }
        catch (IOException | InterruptedException exception) {
            throw new IOException(new FilterFailedException(exception, string2, string));
        }
        int n2 = fS$ExecutionResult.getRc();
        if (n2 != 0) {
            throw new IOException(new FilterFailedException(n2, string2, string, fS$ExecutionResult.getStdout().toByteArray(4096), RawParseUtils.decode(fS$ExecutionResult.getStderr().toByteArray(4096))));
        }
        return fS$ExecutionResult.getStdout().openInputStreamWithAutoDestroy();
    }

    private void initHash(SHA1 sHA1, long l2) {
        sHA1.update(Constants.encodedTypeString(3));
        sHA1.update((byte)32);
        sHA1.update(Constants.encodeASCII(l2));
        sHA1.update((byte)0);
    }

    private ObjectId hash(File file) {
        SHA1 sHA1 = SHA1.newInstance();
        this.initHash(sHA1, file.length());
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n2;
            byte[] byArray = new byte[8192];
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                sHA1.update(byArray, 0, n2);
            }
        }
        return sHA1.toObjectId();
    }

    private void checkOid(ObjectId objectId, ObjectId objectId2, DiffEntry$ChangeType diffEntry$ChangeType, File file, String string) {
        boolean bl2 = false;
        if (objectId2 != null) {
            bl2 = objectId.equals(objectId2);
            if (!bl2 && DiffEntry$ChangeType.ADD.equals((Object)diffEntry$ChangeType) && ObjectId.zeroId().equals(objectId)) {
                bl2 = Constants.EMPTY_BLOB_ID.equals(objectId2);
            }
        } else {
            bl2 = ObjectId.zeroId().equals(objectId) ? !file.exists() || file.length() == 0L : objectId.equals(this.hash(file));
        }
        if (!bl2) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryBaseOidWrong, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void applyBinary(Repository var1_1, String var2_2, File var3_3, FileHeader var4_4, ApplyCommand$StreamSupplier var5_5, ObjectId var6_6, DirCacheCheckout$CheckoutMetadata var7_7) {
        if (!var4_4.getOldId().isComplete() || !var4_4.getNewId().isComplete()) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryOidTooShort, new Object[]{var2_2}));
        }
        var8_8 = var4_4.getForwardBinaryHunk();
        var9_9 = RawParseUtils.nextLF(var8_8.getBuffer(), var8_8.getStartOffset());
        var10_10 = var8_8.getEndOffset() - var9_9;
        var11_11 = SHA1.newInstance();
        var12_12 = new TemporaryBuffer$LocalFile(null);
        try {
            switch (ApplyCommand$1.$SwitchMap$org$eclipse$jgit$patch$BinaryHunk$Type[var8_8.getType().ordinal()]) {
                case 1: {
                    this.checkOid(var4_4.getOldId().toObjectId(), var6_6, var4_4.getChangeType(), var3_3, var2_2);
                    this.initHash(var11_11, var8_8.getSize());
                    var13_13 = var12_12;
                    var14_15 = null;
                    try {
                        var15_17 = new ApplyCommand$SHA1InputStream(var11_11, new InflaterInputStream(new BinaryHunkInputStream(new ByteArrayInputStream(var8_8.getBuffer(), var9_9, var10_10))));
                        var16_23 = null;
                        try {
                            DirCacheCheckout.getContent(var1_1, var2_2, var7_7, new ApplyCommand$StreamLoader((ApplyCommand$StreamSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/io/InputStream;, lambda$applyBinary$1(java.io.InputStream ), ()Ljava/io/InputStream;)((InputStream)var15_17), var8_8.getSize()), null, (OutputStream)var13_13);
                            if (!var4_4.getNewId().toObjectId().equals(var11_11.toObjectId())) {
                                throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryResultOidWrong, new Object[]{var2_2}));
                            }
                        }
                        catch (Throwable var17_32) {
                            var16_23 = var17_32;
                            throw var17_32;
                        }
                        finally {
                            if (var15_17 != null) {
                                if (var16_23 != null) {
                                    try {
                                        var15_17.close();
                                    }
                                    catch (Throwable var17_31) {
                                        var16_23.addSuppressed(var17_31);
                                    }
                                } else {
                                    var15_17.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var15_19) {
                        var14_15 = var15_19;
                        throw var15_19;
                    }
                    finally {
                        if (var13_13 != null) {
                            if (var14_15 != null) {
                                try {
                                    var13_13.close();
                                }
                                catch (Throwable var15_18) {
                                    var14_15.addSuppressed(var15_18);
                                }
                            } else {
                                var13_13.close();
                            }
                        }
                    }
                    var13_13 = var12_12.openInputStream();
                    var14_15 = null;
                    Files.copy((InputStream)var13_13, var3_3.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    if (var13_13 == null) break;
                    if (var14_15 == null) ** GOTO lbl66
                    try {
                        var13_13.close();
                        ** break;
lbl61:
                        // 1 sources

                    }
                    catch (Throwable var15_20) {
                        var14_15.addSuppressed(var15_20);
                        ** break;
                    }
lbl65:
                    // 1 sources

                    break;
lbl66:
                    // 1 sources

                    var13_13.close();
                    ** break;
lbl68:
                    // 1 sources

                    break;
                    catch (Throwable var15_21) {
                        try {
                            var14_15 = var15_21;
                            throw var15_21;
                        }
                        catch (Throwable var22_43) {
                            if (var13_13 != null) {
                                if (var14_15 != null) {
                                    try {
                                        var13_13.close();
                                    }
                                    catch (Throwable var23_46) {
                                        var14_15.addSuppressed(var23_46);
                                    }
                                } else {
                                    var13_13.close();
                                }
                            }
                            throw var22_43;
                        }
                    }
                }
                case 2: {
                    var14_16 = var5_5.load();
                    var15_22 = null;
                    try {
                        var13_14 = IO.readWholeStream(var14_16, 0).array();
                    }
                    catch (Throwable var16_25) {
                        var15_22 = var16_25;
                        throw var16_25;
                    }
                    finally {
                        if (var14_16 != null) {
                            if (var15_22 != null) {
                                try {
                                    var14_16.close();
                                }
                                catch (Throwable var16_24) {
                                    var15_22.addSuppressed(var16_24);
                                }
                            } else {
                                var14_16.close();
                            }
                        }
                    }
                    var14_16 = new BinaryDeltaInputStream(var13_14, new InflaterInputStream(new BinaryHunkInputStream(new ByteArrayInputStream(var8_8.getBuffer(), var9_9, var10_10))));
                    var15_22 = null;
                    try {
                        var16_26 = var14_16.getExpectedResultSize();
                        this.initHash(var11_11, var16_26);
                        var18_34 = var12_12;
                        var19_36 = null;
                        try {
                            var20_38 = new ApplyCommand$SHA1InputStream(var11_11, var14_16);
                            var21_42 = null;
                            try {
                                DirCacheCheckout.getContent(var1_1, var2_2, var7_7, new ApplyCommand$StreamLoader((ApplyCommand$StreamSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/io/InputStream;, lambda$applyBinary$2(org.eclipse.jgit.api.ApplyCommand$SHA1InputStream ), ()Ljava/io/InputStream;)((ApplyCommand$SHA1InputStream)var20_38), var16_26), null, var18_34);
                                if (!var4_4.getNewId().toObjectId().equals(var11_11.toObjectId())) {
                                    throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryResultOidWrong, new Object[]{var2_2}));
                                }
                            }
                            catch (Throwable var22_45) {
                                var21_42 = var22_45;
                                throw var22_45;
                            }
                            finally {
                                if (var20_38 != null) {
                                    if (var21_42 != null) {
                                        try {
                                            var20_38.close();
                                        }
                                        catch (Throwable var22_44) {
                                            var21_42.addSuppressed(var22_44);
                                        }
                                    } else {
                                        var20_38.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable var20_40) {
                            var19_36 = var20_40;
                            throw var20_40;
                        }
                        finally {
                            if (var18_34 != null) {
                                if (var19_36 != null) {
                                    try {
                                        var18_34.close();
                                    }
                                    catch (Throwable var20_39) {
                                        var19_36.addSuppressed(var20_39);
                                    }
                                } else {
                                    var18_34.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var16_28) {
                        var15_22 = var16_28;
                        throw var16_28;
                    }
                    finally {
                        if (var14_16 != null) {
                            if (var15_22 != null) {
                                try {
                                    var14_16.close();
                                }
                                catch (Throwable var16_27) {
                                    var15_22.addSuppressed(var16_27);
                                }
                            } else {
                                var14_16.close();
                            }
                        }
                    }
                    var14_16 = var12_12.openInputStream();
                    var15_22 = null;
                    Files.copy(var14_16, var3_3.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    if (var14_16 == null) break;
                    if (var15_22 == null) ** GOTO lbl176
                    try {
                        var14_16.close();
                        ** break;
lbl171:
                        // 1 sources

                    }
                    catch (Throwable var16_29) {
                        var15_22.addSuppressed(var16_29);
                        ** break;
                    }
lbl175:
                    // 1 sources

                    break;
lbl176:
                    // 1 sources

                    var14_16.close();
                    ** break;
lbl178:
                    // 1 sources

                    break;
                    catch (Throwable var16_30) {
                        try {
                            var15_22 = var16_30;
                            throw var16_30;
                        }
                        catch (Throwable var32_55) {
                            if (var14_16 != null) {
                                if (var15_22 != null) {
                                    try {
                                        var14_16.close();
                                    }
                                    catch (Throwable var33_56) {
                                        var15_22.addSuppressed(var33_56);
                                    }
                                } else {
                                    var14_16.close();
                                }
                            }
                            throw var32_55;
                        }
                    }
                }
                ** default:
lbl195:
                // 1 sources

                break;
            }
        }
        finally {
            var12_12.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyText(Repository repository, String string, RawText rawText, File file, FileHeader fileHeader, DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(rawText.size());
        for (int i2 = 0; i2 < rawText.size(); ++i2) {
            arrayList.add(rawText.getRawString(i2));
        }
        ArrayList<ByteBuffer> arrayList2 = new ArrayList<ByteBuffer>(arrayList);
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        for (Object object4 : fileHeader.getHunks()) {
            int n5;
            int n6;
            boolean bl2;
            int n7;
            block54: {
                int n8;
                block53: {
                    if (((HunkHeader)object4).getNewStartLine() <= n4) {
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, object4));
                    }
                    n4 = ((HunkHeader)object4).getNewStartLine();
                    object3 = new byte[((HunkHeader)object4).getEndOffset() - ((HunkHeader)object4).getStartOffset()];
                    System.arraycopy(((HunkHeader)object4).getBuffer(), ((HunkHeader)object4).getStartOffset(), object3, 0, ((byte[])object3).length);
                    object2 = new RawText((byte[])object3);
                    object = new ArrayList(((RawText)object2).size());
                    for (n7 = 0; n7 < ((RawText)object2).size(); ++n7) {
                        object.add(((RawText)object2).getRawString(n7));
                    }
                    if (((HunkHeader)object4).getNewStartLine() == 0) {
                        if (fileHeader.getHunks().size() == 1 && this.canApplyAt((List)object, arrayList2, 0)) {
                            arrayList2.clear();
                            break;
                        }
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, object4));
                    }
                    n7 = ((HunkHeader)object4).getNewStartLine() - 1 + n3;
                    if (n7 < n2 && n3 < 0) {
                        n7 = ((HunkHeader)object4).getNewStartLine() - 1;
                        n3 = 0;
                    }
                    if (n7 < n2) {
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, object4));
                    }
                    bl2 = false;
                    n8 = ((HunkHeader)object4).getLinesContext() + ((HunkHeader)object4).getOldImage().getLinesDeleted();
                    if (n8 > 1) break block53;
                    bl2 = this.canApplyAt((List)object, arrayList2, n7);
                    if (bl2 || n3 == 0) break block54;
                    n7 = ((HunkHeader)object4).getNewStartLine() - 1;
                    bl2 = n7 >= n2 && this.canApplyAt((List)object, arrayList2, n7);
                    break block54;
                }
                n6 = n7 - n2;
                for (n5 = 0; n5 <= n6; ++n5) {
                    if (!this.canApplyAt((List)object, arrayList2, n7 - n5)) continue;
                    bl2 = true;
                    n7 -= n5;
                    break;
                }
                if (!bl2) {
                    n7 = ((HunkHeader)object4).getNewStartLine() - 1 + n3;
                    n6 = arrayList2.size() - n7 - n8;
                    for (n5 = 1; n5 <= n6; ++n5) {
                        if (!this.canApplyAt((List)object, arrayList2, n7 + n5)) continue;
                        bl2 = true;
                        n7 += n5;
                        break;
                    }
                }
            }
            if (!bl2) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, object4));
            }
            n3 = n7 - ((HunkHeader)object4).getNewStartLine() + 1;
            n6 = object.size();
            block31: for (n5 = 1; n5 < n6; ++n5) {
                ByteBuffer byteBuffer = (ByteBuffer)object.get(n5);
                if (!byteBuffer.hasRemaining()) {
                    ++n7;
                    continue;
                }
                switch (byteBuffer.array()[byteBuffer.position()]) {
                    case 32: {
                        ++n7;
                        continue block31;
                    }
                    case 45: {
                        arrayList2.remove(n7);
                        continue block31;
                    }
                    case 43: {
                        arrayList2.add(n7++, this.slice(byteBuffer, 1));
                        continue block31;
                    }
                }
            }
            n2 = n7;
        }
        if (!this.isNoNewlineAtEndOfFile(fileHeader)) {
            arrayList2.add(null);
        }
        if (!rawText.isMissingNewlineAtEnd()) {
            arrayList.add(null);
        }
        if (arrayList.equals(arrayList2)) {
            return;
        }
        TemporaryBuffer$LocalFile temporaryBuffer$LocalFile = new TemporaryBuffer$LocalFile(null);
        try {
            Object object4;
            object4 = temporaryBuffer$LocalFile;
            object3 = null;
            try {
                object2 = arrayList2.iterator();
                while (object2.hasNext()) {
                    object = (ByteBuffer)object2.next();
                    if (object == null) {
                        break;
                    }
                    ((OutputStream)object4).write(((ByteBuffer)object).array(), ((Buffer)object).position(), ((Buffer)object).remaining());
                    if (!object2.hasNext()) continue;
                    ((OutputStream)object4).write(10);
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object4 != null) {
                    if (object3 != null) {
                        try {
                            ((OutputStream)object4).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)object4).close();
                    }
                }
            }
            object4 = new FileOutputStream(file);
            object3 = null;
            try {
                DirCacheCheckout.getContent(repository, string, dirCacheCheckout$CheckoutMetadata, new ApplyCommand$StreamLoader(temporaryBuffer$LocalFile::openInputStream, ((TemporaryBuffer)temporaryBuffer$LocalFile).length()), null, (OutputStream)object4);
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object4 != null) {
                    if (object3 != null) {
                        try {
                            ((OutputStream)object4).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)object4).close();
                    }
                }
            }
        }
        finally {
            ((TemporaryBuffer)temporaryBuffer$LocalFile).destroy();
        }
        repository.getFS().setExecute(file, fileHeader.getNewMode() == FileMode.EXECUTABLE_FILE);
    }

    private boolean canApplyAt(List list, List list2, int n2) {
        int n3 = list.size();
        int n4 = list2.size();
        int n5 = n2;
        block3: for (int i2 = 1; i2 < n3; ++i2) {
            ByteBuffer byteBuffer = (ByteBuffer)list.get(i2);
            if (!byteBuffer.hasRemaining()) {
                if (n5 >= n4 || ((ByteBuffer)list2.get(n5)).hasRemaining()) {
                    return false;
                }
                ++n5;
                continue;
            }
            switch (byteBuffer.array()[byteBuffer.position()]) {
                case 32: 
                case 45: {
                    if (n5 >= n4 || !((ByteBuffer)list2.get(n5)).equals(this.slice(byteBuffer, 1))) {
                        return false;
                    }
                    ++n5;
                    continue block3;
                }
            }
        }
        return true;
    }

    private ByteBuffer slice(ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.position() + n2;
        return ByteBuffer.wrap(byteBuffer.array(), n3, byteBuffer.limit() - n3);
    }

    private boolean isNoNewlineAtEndOfFile(FileHeader fileHeader) {
        List list = fileHeader.getHunks();
        if (list == null || list.isEmpty()) {
            return false;
        }
        HunkHeader hunkHeader = (HunkHeader)list.get(list.size() - 1);
        byte[] byArray = new byte[hunkHeader.getEndOffset() - hunkHeader.getStartOffset()];
        System.arraycopy(hunkHeader.getBuffer(), hunkHeader.getStartOffset(), byArray, 0, byArray.length);
        RawText rawText = new RawText(byArray);
        return rawText.getString(rawText.size() - 1).equals("\\ No newline at end of file");
    }

    private static /* synthetic */ InputStream lambda$applyBinary$2(ApplyCommand$SHA1InputStream applyCommand$SHA1InputStream) {
        return applyCommand$SHA1InputStream;
    }

    private static /* synthetic */ InputStream lambda$applyBinary$1(InputStream inputStream) {
        return inputStream;
    }
}

