/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class AddCommand
extends GitCommand {
    private Collection filepatterns = new LinkedList();
    private WorkingTreeIterator workingTreeIterator;
    private boolean update = false;

    public AddCommand(Repository repository) {
        super(repository);
    }

    public AddCommand addFilepattern(String string) {
        this.checkCallable();
        this.filepatterns.add(string);
        return this;
    }

    public AddCommand setWorkingTreeIterator(WorkingTreeIterator workingTreeIterator) {
        this.workingTreeIterator = workingTreeIterator;
        return this;
    }

    @Override
    public DirCache call() {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dirCache = null;
        boolean bl2 = this.filepatterns.contains(".");
        try (ObjectInserter objectInserter = this.repo.newObjectInserter();
             NameConflictTreeWalk nameConflictTreeWalk = new NameConflictTreeWalk(this.repo);){
            nameConflictTreeWalk.setOperationType(TreeWalk$OperationType.CHECKIN_OP);
            dirCache = this.repo.lockDirCache();
            DirCacheBuilder dirCacheBuilder = dirCache.builder();
            nameConflictTreeWalk.addTree(new DirCacheBuildIterator(dirCacheBuilder));
            if (this.workingTreeIterator == null) {
                this.workingTreeIterator = new FileTreeIterator(this.repo);
            }
            this.workingTreeIterator.setDirCacheIterator(nameConflictTreeWalk, 0);
            nameConflictTreeWalk.addTree(this.workingTreeIterator);
            if (!bl2) {
                nameConflictTreeWalk.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            }
            byte[] byArray = null;
            while (nameConflictTreeWalk.next()) {
                DirCacheEntry dirCacheEntry;
                DirCacheIterator dirCacheIterator = (DirCacheIterator)nameConflictTreeWalk.getTree(0, DirCacheIterator.class);
                WorkingTreeIterator workingTreeIterator = (WorkingTreeIterator)nameConflictTreeWalk.getTree(1, WorkingTreeIterator.class);
                if (dirCacheIterator == null && workingTreeIterator != null && workingTreeIterator.isEntryIgnored() || dirCacheIterator == null && this.update) continue;
                DirCacheEntry dirCacheEntry2 = dirCacheEntry = dirCacheIterator != null ? dirCacheIterator.getDirCacheEntry() : null;
                if (dirCacheEntry != null && dirCacheEntry.getStage() > 0 && byArray != null && byArray.length == nameConflictTreeWalk.getPathLength() && nameConflictTreeWalk.isPathPrefix(byArray, byArray.length) == 0) continue;
                if (nameConflictTreeWalk.isSubtree() && !nameConflictTreeWalk.isDirectoryFileConflict()) {
                    nameConflictTreeWalk.enterSubtree();
                    continue;
                }
                if (workingTreeIterator == null) {
                    if (dirCacheEntry == null || this.update && FileMode.GITLINK != dirCacheEntry.getFileMode()) continue;
                    dirCacheBuilder.add(dirCacheEntry);
                    continue;
                }
                if (dirCacheEntry != null && dirCacheEntry.isAssumeValid()) {
                    dirCacheBuilder.add(dirCacheEntry);
                    continue;
                }
                if (workingTreeIterator.getEntryRawMode() == 16384 && workingTreeIterator.getIndexFileMode(dirCacheIterator) != FileMode.GITLINK || workingTreeIterator.getEntryRawMode() == 57344 && workingTreeIterator.getIndexFileMode(dirCacheIterator) == FileMode.TREE) {
                    nameConflictTreeWalk.enterSubtree();
                    continue;
                }
                byte[] byArray2 = nameConflictTreeWalk.getRawPath();
                if (dirCacheEntry == null || dirCacheEntry.getStage() > 0) {
                    dirCacheEntry = new DirCacheEntry(byArray2);
                }
                FileMode fileMode = workingTreeIterator.getIndexFileMode(dirCacheIterator);
                dirCacheEntry.setFileMode(fileMode);
                if (FileMode.GITLINK != fileMode) {
                    dirCacheEntry.setLength(workingTreeIterator.getEntryLength());
                    dirCacheEntry.setLastModified(workingTreeIterator.getEntryLastModifiedInstant());
                    long l2 = workingTreeIterator.getEntryContentLength();
                    try (InputStream inputStream = workingTreeIterator.openEntryStream();){
                        ObjectId objectId = objectInserter.insert(3, l2, inputStream);
                        dirCacheEntry.setObjectId(objectId);
                    }
                } else {
                    dirCacheEntry.setLength(0);
                    dirCacheEntry.setLastModified(Instant.ofEpochSecond(0L));
                    dirCacheEntry.setObjectId(workingTreeIterator.getEntryObjectId());
                }
                dirCacheBuilder.add(dirCacheEntry);
                byArray = byArray2;
            }
            objectInserter.flush();
            dirCacheBuilder.commit();
            this.setCallable(false);
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.getCause();
            if (throwable != null && throwable instanceof FilterFailedException) {
                throw (FilterFailedException)throwable;
            }
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfAddCommand, iOException);
        }
        finally {
            if (dirCache != null) {
                dirCache.unlock();
            }
        }
        return dirCache;
    }

    public AddCommand setUpdate(boolean bl2) {
        this.update = bl2;
        return this;
    }

    public boolean isUpdate() {
        return this.update;
    }
}

