/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.x11;

import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.x11.ChannelForwardedX11;
import org.apache.sshd.server.x11.X11ForwardSupport;
import org.apache.sshd.server.x11.X11ForwardingExceptionMarker;

public class DefaultX11ForwardSupport
extends AbstractInnerCloseable
implements X11ForwardSupport {
    private final ConnectionService service;
    private IoAcceptor acceptor;

    public DefaultX11ForwardSupport(ConnectionService connectionService) {
        this.service = Objects.requireNonNull(connectionService, "No connection service");
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(this.acceptor).build();
    }

    @Override
    public synchronized String createDisplay(boolean bl2, String string, String string2, int n2) {
        int n3;
        int n4;
        boolean bl3 = this.log.isDebugEnabled();
        if (this.isClosed()) {
            throw new IllegalStateException("X11ForwardSupport is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("X11ForwardSupport is closing");
        }
        if (OsUtils.isWin32()) {
            if (bl3) {
                this.log.debug("createDisplay(auth={}, cookie={}, screen={}) Windows O/S N/A", new Object[]{string, string2, n2});
            }
            return null;
        }
        Session session = Objects.requireNonNull(this.service.getSession(), "No session");
        if (this.acceptor == null) {
            FactoryManager factoryManager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
            IoServiceFactory ioServiceFactory = Objects.requireNonNull(factoryManager.getIoServiceFactory(), "No I/O service factory");
            this.acceptor = ioServiceFactory.createAcceptor(this);
        }
        int n5 = (Integer)CoreModuleProperties.X11_DISPLAY_OFFSET.getRequired(session);
        int n6 = (Integer)CoreModuleProperties.X11_MAX_DISPLAYS.getRequired(session);
        int n7 = (Integer)CoreModuleProperties.X11_BASE_PORT.getRequired(session);
        String string3 = (String)CoreModuleProperties.X11_BIND_HOST.getRequired(session);
        InetSocketAddress inetSocketAddress = null;
        for (n4 = n5; n4 < n6; ++n4) {
            n3 = n7 + n4;
            inetSocketAddress = new InetSocketAddress(string3, n3);
            try {
                this.acceptor.bind(inetSocketAddress);
                break;
            }
            catch (BindException bindException) {
                if (bl3) {
                    this.log.debug("createDisplay(auth={}, cookie={}, screen={}) failed ({}) to bind to address={}: {}", new Object[]{string, string2, n2, bindException.getClass().getSimpleName(), inetSocketAddress, bindException.getMessage()});
                }
                inetSocketAddress = null;
                continue;
            }
        }
        if (inetSocketAddress == null) {
            this.log.warn("createDisplay(auth={}, cookie={}, screen={}) failed to allocate internet-domain X11 display socket in range {}-{}", new Object[]{string, string2, n2, n5, n6});
            Set set = this.acceptor.getBoundAddresses();
            if (GenericUtils.isEmpty(set)) {
                if (bl3) {
                    this.log.debug("createDisplay(auth={}, cookie={}, screen={}) closing - no more bound addresses", new Object[]{string, string2, n2});
                }
                this.close();
            } else if (bl3) {
                this.log.debug("createDisplay(auth={}, cookie={}, screen={}) closing - remaining bound addresses: {}", new Object[]{string, string2, n2, set});
            }
            return null;
        }
        n4 = inetSocketAddress.getPort();
        n3 = n4 - n7;
        String string4 = "unix:" + n3 + "." + n2;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(XAUTH_COMMAND, "remove", string4);
            Process process = processBuilder.start();
            int n8 = process.waitFor();
            if (bl3) {
                this.log.debug("createDisplay({}) {} remove result={}", new Object[]{string4, XAUTH_COMMAND, n8});
            }
            if (n8 == 0) {
                processBuilder = new ProcessBuilder(XAUTH_COMMAND, "add", string4, string, string2);
                process = processBuilder.start();
                n8 = process.waitFor();
                if (bl3) {
                    this.log.debug("createDisplay({}) {} add result={}", new Object[]{string4, XAUTH_COMMAND, n8});
                }
            }
            if (n8 != 0) {
                throw new IllegalStateException("Bad " + XAUTH_COMMAND + " invocation result: " + n8);
            }
            return string3 + ":" + n3 + "." + n2;
        }
        catch (Throwable throwable) {
            this.warn("createDisplay({}) failed ({}) run xauth: {}", string4, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public void sessionCreated(IoSession ioSession) {
        ChannelForwardedX11 channelForwardedX11 = new ChannelForwardedX11(ioSession);
        ioSession.setAttribute(ChannelForwardedX11.class, channelForwardedX11);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sessionCreated({}) channel{}", (Object)ioSession, (Object)channelForwardedX11);
        }
        this.service.registerChannel(channelForwardedX11);
        Duration duration = (Duration)CoreModuleProperties.X11_OPEN_TIMEOUT.getRequired(channelForwardedX11);
        channelForwardedX11.open().verify(duration);
    }

    @Override
    public void sessionClosed(IoSession ioSession) {
        ChannelForwardedX11 channelForwardedX11 = (ChannelForwardedX11)ioSession.removeAttribute(ChannelForwardedX11.class);
        Throwable throwable = (Throwable)ioSession.removeAttribute(X11ForwardingExceptionMarker.class);
        if (channelForwardedX11 != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionClosed({}) close channel={} - cause={}", new Object[]{ioSession, channelForwardedX11, throwable == null ? null : throwable.getClass().getSimpleName()});
            }
            channelForwardedX11.close(throwable != null);
        }
    }

    @Override
    public void messageReceived(IoSession ioSession, Readable readable) {
        ChannelForwardedX11 channelForwardedX11 = (ChannelForwardedX11)ioSession.getAttribute(ChannelForwardedX11.class);
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(readable.available() + 64, false);
        byteArrayBuffer.putBuffer(readable);
        if (this.log.isTraceEnabled()) {
            this.log.trace("messageReceived({}) channel={}, len={}", new Object[]{ioSession, channelForwardedX11, byteArrayBuffer.available()});
        }
        OutputStream outputStream = channelForwardedX11.getInvertedIn();
        outputStream.write(((Buffer)byteArrayBuffer).array(), ((Buffer)byteArrayBuffer).rpos(), byteArrayBuffer.available());
        outputStream.flush();
    }

    @Override
    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        ioSession.setAttribute(X11ForwardingExceptionMarker.class, throwable);
        this.log.debug("exceptionCaught({}) {}: {}", new Object[]{ioSession, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable});
        ioSession.close(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.service.getClass();
    }
}

