/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.x11;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.StreamingChannel$Streaming;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class ChannelForwardedX11
extends AbstractClientChannel {
    private final IoSession serverSession;

    public ChannelForwardedX11(IoSession ioSession) {
        super("x11");
        this.serverSession = ioSession;
    }

    @Override
    public synchronized OpenFuture open() {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.serverSession.getRemoteAddress();
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(inetSocketAddress, this.futureLock);
        Session session = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        String string = inetAddress.getHostAddress();
        LocalWindow localWindow = this.getLocalWindow();
        String string2 = this.getChannelType();
        Buffer buffer = session.createBuffer((byte)90, string.length() + string2.length() + 32);
        buffer.putString(string2);
        buffer.putUInt(this.getChannelId());
        buffer.putUInt(localWindow.getSize());
        buffer.putUInt(localWindow.getPacketSize());
        buffer.putString(string);
        buffer.putUInt(inetSocketAddress.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected synchronized void doOpen() {
        if (StreamingChannel$Streaming.Async.equals((Object)this.streaming)) {
            throw new IllegalArgumentException("Asynchronous streaming isn't supported yet on this channel");
        }
        this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.serverSession, super.getInnerCloseable()).build();
    }

    @Override
    protected synchronized void doWriteData(byte[] byArray, int n2, long l2) {
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", l2);
        LocalWindow localWindow = this.getLocalWindow();
        localWindow.release(l2);
        ByteArrayBuffer byteArrayBuffer = ByteArrayBuffer.getCompactClone(byArray, n2, (int)l2);
        this.serverSession.writeBuffer(byteArrayBuffer);
    }

    @Override
    public void handleEof() {
        super.handleEof();
        this.serverSession.close(false);
    }
}

